/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemDb.orient;

import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tridium.systemDb.BSystemDb;
import com.tridium.systemDb.BSystemDbService;
import com.tridium.systemDb.orient.BOrientSystemDb;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.category.BCategoryMask;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

public class NiagaraPermissionOrientHook
extends ODocumentHookAbstract
implements ODatabaseListener {
    private static final BUser INDEX_USER = new BUser();
    private static final String CREATE_EVENT = "CREATE";
    private static final String READ_EVENT = "READ";
    private static final String UPDATE_EVENT = "UPDATE";
    private static final String DELETE_EVENT = "DELETE";
    static final AtomicInteger OPEN_CONNECTIONS = new AtomicInteger();
    private BUser user;
    private boolean canWriteToSysDb;
    boolean failOnInaccessibleRead;
    boolean skipReadPermissionCheck;
    private static final Logger LOG = BOrientSystemDb.getLogger();
    private static final Logger EVENT_LOGGER = Logger.getLogger("orientSystemDb.event");

    private NiagaraPermissionOrientHook() {
    }

    private NiagaraPermissionOrientHook(ODatabaseDocument database) {
        super(database);
    }

    NiagaraPermissionOrientHook(ODatabaseDocument database, Context cx) {
        this(database);
        this.setNiagaraUser(cx);
        this.registerOnDatabase((ODatabase<?>)database);
        this.setIncludeClasses(new String[]{"V"});
    }

    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        if (this.canWriteToSysDb && this.hasPermission(iDocument, BPermissions.adminWrite)) {
            this.logEvent(iDocument, CREATE_EVENT, false);
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        this.logEvent(iDocument, CREATE_EVENT, true);
        throw this.generatePermissionException(BPermissions.adminWrite);
    }

    public ORecordHook.RESULT onRecordBeforeRead(ODocument iDocument) {
        if (this.skipReadPermissionCheck) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        if (this.hasPermission(iDocument, BPermissions.operatorRead)) {
            this.logEvent(iDocument, READ_EVENT, false);
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        this.logEvent(iDocument, READ_EVENT, true);
        if (this.failOnInaccessibleRead) {
            throw new PermissionException("User does not have operatorRead permission on SystemDb Entity");
        }
        return ORecordHook.RESULT.SKIP;
    }

    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        if (this.canWriteToSysDb && this.hasPermission(iDocument, BPermissions.adminWrite)) {
            this.logEvent(iDocument, UPDATE_EVENT, false);
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        this.logEvent(iDocument, UPDATE_EVENT, true);
        throw this.generatePermissionException(BPermissions.adminWrite);
    }

    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        if (this.canWriteToSysDb && this.hasPermission(iDocument, BPermissions.adminWrite)) {
            this.logEvent(iDocument, DELETE_EVENT, false);
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        this.logEvent(iDocument, DELETE_EVENT, true);
        throw this.generatePermissionException(BPermissions.adminWrite);
    }

    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.BOTH;
    }

    private void setNiagaraUser(Context cx) {
        this.user = cx != null && cx == SystemIndexContextHolder.INDEX_CONTEXT ? INDEX_USER : NiagaraPermissionOrientHook.computeNiagaraUser(cx);
    }

    static BUser computeNiagaraUser(Context cx) {
        BObject userNameFacet;
        BUser user = null;
        if (cx != null && (user = cx.getUser()) == null && (userNameFacet = cx.getFacet("username")) instanceof BString) {
            user = BUserService.getService().getUser(userNameFacet.toString(null));
        }
        if (user == null) {
            user = BUser.getCurrentAuthenticatedUser();
        }
        return user;
    }

    private void registerOnDatabase(ODatabase<?> db) {
        boolean bl = this.canWriteToSysDb = this.user == null || this.user == INDEX_USER;
        if (!this.canWriteToSysDb) {
            try {
                this.user.check((BIProtected)((BSystemDbService)Sys.getService((Type)BSystemDbService.TYPE)).getSystemDatabase(), BPermissions.adminWrite);
                this.canWriteToSysDb = true;
            }
            catch (Exception pe) {
                this.canWriteToSysDb = false;
            }
        }
        db.registerHook((ORecordHook)this);
        db.registerListener((ODatabaseListener)this);
        OPEN_CONNECTIONS.incrementAndGet();
        if (LOG.isLoggable(Level.FINE)) {
            String access = this.canWriteToSysDb ? "with" : "without";
            LOG.log(Level.FINE, () -> "User '" + this.user + "' made a connection (" + db + ") to the SystemDatabase " + access + " adminWrite access to it.");
        }
    }

    private boolean hasPermission(ODocument iDocument, BPermissions requiredPermissions) {
        if (this.user == null || this.user == INDEX_USER) {
            return true;
        }
        Object encodedMask = iDocument.field("CategoryMask");
        if (encodedMask != null) {
            BCategoryMask categoryMask = (BCategoryMask)BCategoryMask.DEFAULT.decodeFromString(encodedMask.toString());
            BPermissionsMap pmap = this.user.getPermissions();
            BPermissions permissions = pmap.getCategoryPermissions(categoryMask);
            return permissions.has(requiredPermissions);
        }
        return this.user.getPermissionsFor((BIProtected)((BSystemDbService)Sys.getService((Type)BSystemDbService.TYPE)).getSystemDatabase()).has(requiredPermissions);
    }

    private PermissionException generatePermissionException(BPermissions requiredPermissions) {
        String msg = this.canWriteToSysDb ? "Unable to modify record in SystemDatabase. User does not have '" + requiredPermissions + "' permission on source Entity." : "Unable to modify record in SystemDatabase. User does not have adminWrite permission on the SystemDatabase.";
        return new PermissionException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logEvent(ODocument iDocument, String event, boolean filtered) {
        if (EVENT_LOGGER.isLoggable(Level.FINE)) {
            boolean originalSkip = this.skipReadPermissionCheck;
            try {
                this.skipReadPermissionCheck = true;
                if (filtered) {
                    EVENT_LOGGER.fine(() -> "Filtering out " + event + " event on SystemDb due to insufficient permissions for connection user '" + this.user + "'. Vertex info: " + iDocument);
                } else {
                    EVENT_LOGGER.fine(() -> "Processing " + event + " event on SystemDb for connection user '" + this.user + "'. Vertex info: " + iDocument);
                }
            }
            finally {
                this.skipReadPermissionCheck = originalSkip;
            }
        }
    }

    @Deprecated
    public void onCreate(ODatabase oDatabase) {
    }

    @Deprecated
    public void onDelete(ODatabase oDatabase) {
    }

    @Deprecated
    public void onOpen(ODatabase oDatabase) {
    }

    public void onBeforeTxBegin(ODatabase oDatabase) {
    }

    public void onBeforeTxRollback(ODatabase oDatabase) {
    }

    public void onAfterTxRollback(ODatabase oDatabase) {
    }

    public void onBeforeTxCommit(ODatabase oDatabase) {
    }

    public void onAfterTxCommit(ODatabase oDatabase) {
    }

    public void onClose(ODatabase oDatabase) {
        OPEN_CONNECTIONS.decrementAndGet();
    }

    public void onBeforeCommand(OCommandRequestText oCommandRequestText, OCommandExecutor oCommandExecutor) {
    }

    public void onAfterCommand(OCommandRequestText oCommandRequestText, OCommandExecutor oCommandExecutor, Object o) {
    }

    private static final class SystemIndexContextHolder {
        static final Context INDEX_CONTEXT = AccessController.doPrivileged(BSystemDb::getSystemIndexContext);

        private SystemIndexContextHolder() {
        }
    }
}

