/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.gx.micro.MicroFontPeer;
import com.tridium.pdf.PdfCidFontInfo;
import com.tridium.pdf.gx.PdfFont;
import com.tridium.pdf.gx.PdfFontReference;
import com.tridium.pdf.gx.PdfGraphics;
import com.tridium.pdf.gx.PdfImageMaskStream;
import com.tridium.pdf.gx.PdfImageStream;
import com.tridium.pdf.gx.PdfObject;
import com.tridium.pdf.gx.PdfPage;
import com.tridium.pdf.gx.PdfStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.gx.BFont;
import javax.baja.gx.Insets;
import javax.baja.gx.Size;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class PdfDocument {
    private static byte[] bytes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static long seq = System.currentTimeMillis();
    private static final String version = "1.4";
    private PdfGraphics graphics;
    private OutputStream out;
    private int offset;
    private int numObjects;
    private int rootId;
    private int pageTreeId;
    private Vector<PdfObject> fonts;
    private Hashtable<String, Integer> fontHash;
    private Vector<PdfPage> pages;
    private PdfPage currentPage;
    private Size pageSize = new Size(612.0, 792.0);
    private Insets margins = new Insets(36.0, 36.0, 36.0, 36.0);
    private Hashtable<Integer, Integer> xref;

    public PdfDocument(OutputStream out) {
        this(out, 612, 792);
    }

    public PdfDocument(OutputStream out, int width, int height) {
        this.out = out;
        this.pages = new Vector();
        this.xref = new Hashtable();
        this.rootId = 1;
        this.pageTreeId = 2;
        this.numObjects = 3;
        this.fonts = new Vector();
        this.fontHash = new Hashtable();
        this.pageSize.set((double)width, (double)height);
        try {
            this.graphics = (PdfGraphics)Sys.newInstance((String)"pdf", (String)"com.tridium.pdf.gx.awt.se.PdfGraphicsSE");
        }
        catch (Throwable e) {
            this.graphics = new PdfGraphics();
        }
    }

    public void start() {
        this.writeln("%PDF-1.4");
        byte[] binData = new byte[]{37, -86, -85, -84, -83, 10};
        this.write(binData);
    }

    public void end() {
        try {
            if (this.currentPage != null) {
                this.currentPage.toPdf();
            }
            this.writeFooter();
            this.out.flush();
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public PdfPage addNewPage() {
        try {
            if (this.currentPage != null) {
                this.currentPage.toPdf();
            }
            this.currentPage = new PdfPage(this, this.numObjects++, 0);
            this.pages.add(this.currentPage);
            this.graphics.setPage(this.currentPage);
            return this.currentPage;
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public PdfPage getCurrentPage() {
        return this.currentPage;
    }

    public int getCurrentPageNumber() {
        return this.pages.size();
    }

    public Size getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(double width, double height) {
        this.pageSize.set(width, height);
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setMargins(double top, double left, double bottom, double right) {
        this.margins.set(top, left, bottom, right);
    }

    public PdfGraphics getGraphics() {
        return this.graphics;
    }

    public PdfStream createStream() {
        return new PdfStream(this, this.numObjects++, 0);
    }

    public PdfImageStream createImageStream() {
        return new PdfImageStream(this, this.numObjects++, 0);
    }

    @Deprecated
    public PdfImageMaskStream createImageMaskStream() {
        return new PdfImageMaskStream(this, this.numObjects++, 0);
    }

    public int getFontId(BFont font) {
        Integer id;
        String name = font.getName();
        if (font.isBold()) {
            name = name + "B";
        }
        if (font.isItalic()) {
            name = name + "I";
        }
        if ((id = this.fontHash.get(name)) == null) {
            PdfFont pdfFont = new PdfFont(font, this, this.numObjects, 0, Lexicon.make((String)"pdf").getText("pdf.encoding"));
            this.numObjects += 3;
            this.fonts.add(pdfFont);
            this.fontHash.put(name, new Integer(pdfFont.getObjectId()));
            return pdfFont.getObjectId();
        }
        return id;
    }

    public int getFontId(MicroFontPeer peer) {
        String name = peer.getPostScriptName();
        Integer id = this.fontHash.get(name);
        if (id == null) {
            PdfFont pdfFont = new PdfFont(peer, this, this.numObjects, 0, Lexicon.make((String)"pdf").getText("pdf.encoding"));
            this.numObjects += 3;
            this.fonts.add(pdfFont);
            this.fontHash.put(name, new Integer(pdfFont.getObjectId()));
            return pdfFont.getObjectId();
        }
        return id;
    }

    public int getReferenceFontId(String fontName, PdfCidFontInfo.CJK cjkFont) {
        Integer id = this.fontHash.get(fontName);
        if (id == null) {
            PdfFontReference fontRef = new PdfFontReference(this, this.numObjects, 0, cjkFont, Lexicon.make((String)"pdf").getText("pdf.font"));
            this.numObjects += 3;
            this.fonts.add(fontRef);
            this.fontHash.put(fontName, new Integer(fontRef.getObjectId()));
            return fontRef.getObjectId();
        }
        return id;
    }

    public int getPageTreeId() {
        return this.pageTreeId;
    }

    public void markOffset(int objId) {
        this.xref.put(new Integer(objId), new Integer(this.offset));
    }

    public void writeFooter() throws IOException {
        this.markOffset(this.rootId);
        this.writeln(this.rootId + " 0 obj");
        this.writeln("<< /Type /Catalog /Pages " + this.pageTreeId + " 0 R >>");
        this.writeln("endobj");
        String str = "<< /Type /Pages /Kids [";
        Enumeration<PdfPage> pageEnumeration = this.pages.elements();
        while (pageEnumeration.hasMoreElements()) {
            PdfPage page = pageEnumeration.nextElement();
            str = str + page.getObjectId() + " " + page.getGenerationNum() + " R ";
        }
        str = str + "] /Count " + this.pages.size() + " >>";
        this.markOffset(this.pageTreeId);
        this.writeln(this.pageTreeId + " 0 obj");
        this.writeln(str);
        this.writeln("endobj");
        Enumeration<PdfObject> fontEnumeration = this.fonts.elements();
        while (fontEnumeration.hasMoreElements()) {
            PdfObject fontObject = fontEnumeration.nextElement();
            if (fontObject instanceof PdfFontReference) {
                PdfFontReference pdfFontReference = (PdfFontReference)fontObject;
                pdfFontReference.toPdf();
                continue;
            }
            PdfFont pdfFont = (PdfFont)fontObject;
            pdfFont.toPdf();
        }
        int xrefOffset = this.offset;
        this.writeln("xref");
        this.writeln("0 " + (this.xref.size() + 1));
        this.writeln("0000000000 65535 f ");
        for (int i = 1; i < this.numObjects; ++i) {
            Integer value = this.xref.get(new Integer(i));
            if (value == null) continue;
            int off = value;
            StringBuffer sb = new StringBuffer("0000000000" + off);
            while (sb.length() > 10) {
                sb.deleteCharAt(0);
            }
            this.writeln(sb.toString() + " 00000 n ");
        }
        this.writeln("trailer");
        this.writeln("<< /Size " + (this.xref.size() + 1) + " /Root " + this.rootId + " 0 R /ID " + PdfDocument.createInfoId(PdfDocument.createDocumentId()) + ">>");
        this.writeln("startxref");
        this.writeln("" + xrefOffset);
        this.writeln("%%EOF");
    }

    private static byte[] createDocumentId() {
        MessageDigest sha256;
        try {
            sha256 = MessageDigest.getInstance("Sha-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        long time = System.currentTimeMillis();
        long mem = Runtime.getRuntime().freeMemory();
        String s = time + "+" + mem + "+" + seq++;
        sha256.update(s.getBytes());
        return sha256.digest();
    }

    private static String createInfoId(byte[] id) {
        int k;
        byte[] b = new byte[2];
        StringBuffer buf = new StringBuffer(90);
        buf.append('[');
        buf.append('<');
        for (k = 0; k < 16; ++k) {
            b[0] = bytes[id[k] >> 4 & 0xF];
            b[1] = bytes[id[k] & 0xF];
            buf.append(new String(b));
        }
        buf.append('>');
        buf.append('<');
        for (k = 0; k < 16; ++k) {
            b[0] = bytes[id[k] >> 4 & 0xF];
            b[1] = bytes[id[k] & 0xF];
            buf.append(new String(b));
        }
        buf.append('>');
        buf.append(']');
        return buf.toString();
    }

    public void write(byte[] data) {
        try {
            this.offset += data.length;
            this.out.write(data);
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void write(String str) {
        try {
            this.offset += str.length();
            this.out.write(str.getBytes());
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void writeln(String str) {
        try {
            this.offset += str.length() + 1;
            this.out.write(str.getBytes());
            this.out.write(10);
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }
}

