/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf;

import com.tridium.pdf.BIPdfAsyncWidget;
import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.PdfUtil;
import com.tridium.pdf.gx.PdfDocument;
import com.tridium.pdf.gx.PdfGraphics;
import com.tridium.ui.Binder;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.agent.BPxView;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.Insets;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.TextUtil;
import javax.baja.pdf.BPdfExporter;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;

public class BWidgetToPdf
extends BPdfExporter {
    public static final Type TYPE = Sys.loadType(BWidgetToPdf.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void export(PdfOp op) throws Exception {
        BWidget widget = (BWidget)op.get();
        OutputStream outputStream = op.getOutputStream();
        int width = op.getWidth();
        int height = op.getHeight();
        if (PdfUtil.log.isLoggable(Level.FINE)) {
            PdfUtil.log.fine("Exporting widget to PDF: " + widget.toString());
            PdfUtil.log.fine("Width of document: " + width);
            PdfUtil.log.fine("Height of document: " + height);
        }
        PdfDocument doc = new PdfDocument(outputStream, width, height);
        try {
            this.renderDocument(widget, doc, op);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderDocument(BWidget widget, PdfDocument doc, PdfOp op) {
        doc.start();
        this.loadImages(widget);
        BWidget child = PdfUtil.getWidget(widget, op);
        if (PdfUtil.log.isLoggable(Level.FINE)) {
            PdfUtil.log.fine("BWidgetToPdf.RenderDocument rendering document with root: " + child);
        }
        if (child == null) {
            doc.addNewPage();
            if (PdfUtil.log.isLoggable(Level.FINE)) {
                PdfUtil.log.fine("BWidgetToPdf.RenderDocument encountered a NULL widget value. Creating blank page.");
            }
        } else {
            BPdfFlowPane root = new BPdfFlowPane();
            root.add(null, (BValue)child);
            Size size = doc.getPageSize();
            Insets m = doc.getMargins();
            double x = m.left;
            double y = m.top;
            double w = size.width - (m.left + m.right);
            double h = size.height - (m.top + m.bottom);
            RectGeom pageDimensions = new RectGeom(x, y, w, h);
            PdfBinder binder = new PdfBinder(root);
            try {
                BWidget z;
                binder.findBindings(root);
                PdfOp bindTarget = op;
                if (op.get().getType() == BPxView.TYPE) {
                    bindTarget = ((BPxView)op.get()).getPxFile().resolve();
                }
                binder.start((OrdTarget)bindTarget, (Context)op);
                for (int i = 0; i < 20; ++i) {
                    try {
                        if (binder.getAllResolved()) break;
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!binder.getAllResolved()) {
                    PdfUtil.log.warning("Failed to resolve all bindings before proceeding with PDF generation");
                }
                ArrayList<BWidget> pages = new ArrayList<BWidget>();
                root.computePreferredSize();
                while (root.getPreferredHeight() > pageDimensions.height && (z = root.getToFit(pageDimensions.width, pageDimensions.height)) != null) {
                    pages.add(z);
                    root.computePreferredSize();
                }
                pages.add(root);
                if (PdfUtil.log.isLoggable(Level.FINE)) {
                    this.dump(pages);
                }
                for (BWidget page : pages) {
                    CompletableFuture<Void> future;
                    page.setBounds(pageDimensions.x, pageDimensions.y, pageDimensions.width, pageDimensions.height);
                    this.layout(page);
                    ArrayList<BIPdfAsyncWidget> asyncPdfWidgets = new ArrayList<BIPdfAsyncWidget>();
                    BWidgetToPdf.findPdfAsyncWidgets(asyncPdfWidgets, page);
                    try {
                        List<CompletableFuture> initFutures = asyncPdfWidgets.stream().map(BIPdfAsyncWidget::initializeAsync).collect(Collectors.toList());
                        if (!initFutures.isEmpty()) {
                            future = CompletableFuture.allOf(initFutures.toArray(new CompletableFuture[0]));
                            long time = Clock.ticks();
                            try {
                                future.get(BIPdfAsyncWidget.ASYNC_WAIT_TIME, TimeUnit.MILLISECONDS);
                                if (PdfUtil.log.isLoggable(Level.FINE)) {
                                    PdfUtil.log.log(Level.FINE, "Successful initialized widgets for PDF generation in " + (Clock.ticks() - time) + "ms");
                                }
                            }
                            catch (Exception e) {
                                PdfUtil.log.log(Level.WARNING, "Failed to asynchronously initialize widgets for PDF generation", e);
                            }
                            try {
                                Thread.sleep(BIPdfAsyncWidget.POST_INITIALIZE_DELAY_TIME);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        doc.addNewPage();
                        PdfGraphics g = doc.getGraphics();
                        g.translate(pageDimensions.x, pageDimensions.y);
                        page.paint((Graphics)g);
                    }
                    finally {
                        List<CompletableFuture> cleanupFutures = asyncPdfWidgets.stream().map(BIPdfAsyncWidget::cleanupAsync).collect(Collectors.toList());
                        if (cleanupFutures.isEmpty()) continue;
                        future = CompletableFuture.allOf(cleanupFutures.toArray(new CompletableFuture[0]));
                        try {
                            future.get(BIPdfAsyncWidget.ASYNC_WAIT_TIME, TimeUnit.MILLISECONDS);
                        }
                        catch (Exception e) {
                            PdfUtil.log.log(Level.WARNING, "Failed to asynchronously clean up widgets for PDF generation", e);
                        }
                    }
                }
                if (PdfUtil.log.isLoggable(Level.FINER)) {
                    this.dump(pages);
                }
            }
            finally {
                binder.stop();
            }
        }
        doc.end();
    }

    private void layout(BWidget w) {
        BWidget[] kids = w.getChildWidgets();
        w.doLayout(kids);
        for (BWidget child : kids) {
            this.layout(child);
        }
    }

    private void loadImages(BWidget w) {
        BWidget[] kids;
        SlotCursor cursor = w.getProperties();
        while (cursor.next()) {
            BBrush brush;
            if (cursor.property().getType().is(BImage.TYPE)) {
                ((BImage)w.get(cursor.property())).sync();
            }
            if (!cursor.property().getType().is(BBrush.TYPE) || !((brush = (BBrush)w.get(cursor.property())).getPaint() instanceof BBrush.Image)) continue;
            ((BBrush.Image)brush.getPaint()).getImage().sync();
        }
        for (BWidget child : kids = w.getChildWidgets()) {
            this.loadImages(child);
        }
    }

    private static void findPdfAsyncWidgets(List<BIPdfAsyncWidget> pdfWidgets, BWidget widget) {
        if (widget == null) {
            return;
        }
        if (widget instanceof BIPdfAsyncWidget) {
            pdfWidgets.add((BIPdfAsyncWidget)widget);
        }
        for (BWidget kid : widget.getChildWidgets()) {
            BWidgetToPdf.findPdfAsyncWidgets(pdfWidgets, kid);
        }
    }

    private void dump(List<BWidget> pages) {
        for (int i = 0; i < pages.size(); ++i) {
            PdfUtil.log.fine("------ Page " + (i + 1) + " --------");
            this.dumpw(0, pages.get(i));
        }
    }

    private void dumpw(int indent, BWidget w) {
        StringBuilder buf = new StringBuilder();
        buf.append(TextUtil.getSpaces((int)indent));
        buf.append(w).append(" (").append((int)w.getPreferredWidth()).append(" ").append((int)w.getPreferredHeight()).append(")");
        if (w instanceof BLabel) {
            buf.append("  \"").append(((BLabel)w).getText()).append("\"");
        }
        buf.append("  ").append(w.getLayout());
        buf.append("  ").append(w.getX());
        buf.append("  ").append(w.getY());
        buf.append("  ").append(w.getWidth());
        buf.append("  ").append(w.getHeight());
        PdfUtil.log.fine(buf.toString());
        for (BWidget child : w.getChildWidgets()) {
            this.dumpw(indent + 2, child);
        }
    }

    static class PdfBinder
    extends Binder {
        public PdfBinder(BWidget owner) {
            super(owner);
        }

        void findBindings(BWidget root) {
            ArrayList<BBinding> bindings = new ArrayList<BBinding>();
            this.findBindings(root, bindings);
            for (BBinding binding : bindings) {
                if (binding.getOrd().isNull()) continue;
                this.bind(binding);
            }
        }

        private void findBindings(BWidget w, List<BBinding> bindings) {
            for (BBinding bBinding : w.getBindings()) {
                bindings.add(bBinding);
            }
            for (BBinding bBinding : w.getChildWidgets()) {
                this.findBindings((BWidget)bBinding, bindings);
            }
        }
    }
}

