/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mobile.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebServlet;
import javax.baja.web.WebOp;
import javax.servlet.http.HttpServletResponse;

public final class BDebugFileServlet
extends BWebServlet {
    public static final Type TYPE = Sys.loadType(BDebugFileServlet.class);

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.setFlags((Slot)servletName, 4);
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public String getServletName() {
        return "debugFile";
    }

    public void doGet(WebOp op) throws Exception {
        if (!AccessController.doPrivileged(() -> Boolean.getBoolean("mobile.debug")).booleanValue()) {
            op.getResponse().sendError(405, "Mobile Debug not enabled!");
            return;
        }
        if (!this.isOperational()) {
            op.getResponse().sendError(405, "Servlet not enabled!");
            return;
        }
        String uri = op.getRequest().getRequestURI();
        int index = uri.indexOf(this.getServletName());
        uri = uri.substring(index + this.getServletName().length(), uri.length());
        BIFile file = (BIFile)BOrd.make((String)("file:" + uri)).get();
        if (file.isDirectory()) {
            op.getResponse().sendError(405, "file is directory");
            return;
        }
        HttpServletResponse resp = op.getResponse();
        int len = (int)file.getSize();
        resp.setContentType(file.getMimeType());
        resp.setContentLength(len);
        FileUtil.pipe((InputStream)file.getInputStream(), (OutputStream)resp.getOutputStream());
    }
}

