/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mobile.util;

import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.mobile.BDefaultMobileWebProfile;
import com.tridium.util.PxUtil;
import com.tridium.web.PxViewFilter;
import com.tridium.web.WebUtil;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.box.BIServerSideCallHandler;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BPermissions;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.web.BIWebProfile;

public final class BComponentServerSideHandler
extends BSingleton
implements BIServerSideCallHandler {
    public static final BComponentServerSideHandler INSTANCE = new BComponentServerSideHandler();
    public static final Type TYPE = Sys.loadType(BComponentServerSideHandler.class);

    public Type getType() {
        return TYPE;
    }

    private BComponentServerSideHandler() {
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getMobileAgentList(String sourceOrd, Context cx) throws Exception {
        OrdTarget target = BOrd.make((String)sourceOrd).resolve((BObject)BLocalHost.INSTANCE, cx);
        BObject o = target.get();
        BComponent data = new BComponent();
        BDefaultMobileWebProfile profile = new BDefaultMobileWebProfile();
        AgentList agents = o.getAgents(cx).filter(profile.getMobileAgentFilter(cx));
        AgentFilter hasFilter = AgentFilter.has((BPermissions)target.getPermissionsForTarget());
        WebUtil.ProfileFilter profileFilter = new WebUtil.ProfileFilter((BIWebProfile)profile, o);
        agents = agents.filter(AgentFilter.and((AgentFilter)AgentFilter.and((AgentFilter)hasFilter, (AgentFilter)new PxViewFilter(target)), (AgentFilter)profileFilter));
        AgentInfo[] infos = agents.list();
        for (int i = 0; i < infos.length; ++i) {
            BPermissions required;
            AgentInfo info = infos[i];
            BPermissions actual = target.getPermissionsForTarget();
            if (!actual.has(required = info.getRequiredPermissions())) continue;
            if (info instanceof PxUtil.PxAgent) {
                info = ((PxUtil.PxAgent)info).getPxView();
            }
            BComponent agentData = new BComponent();
            agentData.add("displayName", (BValue)BString.make((String)info.getDisplayName(cx)));
            agentData.add("ord", (BValue)BOrd.make((BOrd)target.getOrdWithoutViewQuery(), (String)("view:" + info.getAgentId())));
            data.add(null, (BValue)agentData);
        }
        return BsonEncoderPlugin.marshal((BValue)data);
    }

    public BValue getUnits(BComponent component, Context cx) throws Exception {
        JSONArray arr = new JSONArray();
        UnitDatabase.Quantity[] quantities = UnitDatabase.getDefault().getQuantities();
        for (int i = 0; i < quantities.length; ++i) {
            UnitDatabase.Quantity quantity = quantities[i];
            JSONObject quantityObj = new JSONObject();
            String qStr = quantity.toString();
            JSONArray unitArr = new JSONArray();
            BUnit[] units = quantity.getUnits();
            for (int j = 0; j < units.length; ++j) {
                BUnit unit = units[j];
                JSONObject unitObj = new JSONObject();
                unitObj.put("n", (Object)unit.getUnitName());
                unitObj.put("s", (Object)unit.getSymbol());
                unitObj.put("d", (Object)unit.getDimension().encodeToString());
                unitObj.put("sc", unit.getScale());
                unitObj.put("o", unit.getOffset());
                unitObj.put("p", unit.getIsPrefix());
                unitArr.put((Object)unitObj);
            }
            quantityObj.put("q", (Object)qStr);
            quantityObj.put("u", (Object)unitArr);
            arr.put((Object)quantityObj);
        }
        return BString.make((String)arr.toString());
    }
}

