/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ui.editors;

import com.tridiumX.knxnetIp.comms.frames.parts.BSupportedServiceFamiliesDIB;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"knxnetIp:SupportedServiceFamiliesDIB"})})
public class BSupportedServicesFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BSupportedServicesFE.class);
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BSupportedServicesFE.class);
    private static final String NO_SUPPORTED_SERVICE_FAMILIES_LEX_KEY = "noSupportedServiceFamilies";
    private static final String NO_SUPPORTED_SERVICE_FAMILIES_DEFAULT = "No Supported Service Families";
    BSupportedServiceFamiliesDIB services;
    final BList displayList = new BList();

    public Type getType() {
        return TYPE;
    }

    public BSupportedServicesFE() {
        this.setContent((BWidget)this.displayList);
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.services = (BSupportedServiceFamiliesDIB)value;
        this.updateDisplayList();
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        return value;
    }

    private void updateDisplayList() {
        this.displayList.removeAllItems();
        if (this.services.getCore().getSupport()) {
            String core = "V" + this.services.getCore().getVersion() + " " + lexicon.get("serviceFamiliesDib.core");
            this.displayList.addItem((Object)core);
        }
        if (this.services.getDeviceManagement().getSupport()) {
            String dm = "V" + this.services.getDeviceManagement().getVersion() + " " + lexicon.get("serviceFamiliesDib.deviceManagement");
            this.displayList.addItem((Object)dm);
        }
        if (this.services.getTunneling().getSupport()) {
            String tun = "V" + this.services.getTunneling().getVersion() + " " + lexicon.get("serviceFamiliesDib.tunneling");
            this.displayList.addItem((Object)tun);
        }
        if (this.services.getRouting().getSupport()) {
            String rt = "V" + this.services.getRouting().getVersion() + " " + lexicon.get("serviceFamiliesDib.routing");
            this.displayList.addItem((Object)rt);
        }
        if (this.services.getRemoteLogging().getSupport()) {
            String rl = "V" + this.services.getRemoteLogging().getVersion() + " " + lexicon.get("serviceFamiliesDib.remoteLogging");
            this.displayList.addItem((Object)rl);
        }
        if (this.services.getRemoteConfiguration().getSupport()) {
            String rc = "V" + this.services.getRemoteConfiguration().getVersion() + " " + lexicon.get("serviceFamiliesDib.remoteConfig");
            this.displayList.addItem((Object)rc);
        }
        if (this.services.getObjectServer().getSupport()) {
            String os = "V" + this.services.getObjectServer().getVersion() + " " + lexicon.get("serviceFamiliesDib.objectServer");
            this.displayList.addItem((Object)os);
        }
        if (this.displayList.getItemCount() == 0) {
            this.displayList.addItem((Object)lexicon.get(NO_SUPPORTED_SERVICE_FAMILIES_LEX_KEY, NO_SUPPORTED_SERVICE_FAMILIES_DEFAULT));
        }
        this.relayout();
    }
}

