/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ui.editors;

import com.tridiumX.knxnetIp.addresses.BGroupAddress;
import com.tridiumX.knxnetIp.addresses.BKnxAddress;
import com.tridiumX.knxnetIp.addresses.BKnxAddressStyle;
import com.tridiumX.knxnetIp.addresses.IKnxAddress;
import com.tridiumX.knxnetIp.ets.EtsUtil;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.TextController;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"knxnetIp:GroupAddress"})})
@NiagaraActions(value={@NiagaraAction(name="propagateFocusEvent", parameterType="BFocusEvent", defaultValue="new BFocusEvent()", flags=4), @NiagaraAction(name="propagateKeyEvent", parameterType="BKeyEvent", defaultValue="new BKeyEvent()", flags=4), @NiagaraAction(name="propagateMouseEvent", parameterType="BMouseEvent", defaultValue="new BMouseEvent()", flags=4)})
public final class BGroupAddressFE
extends BWbFieldEditor {
    public static final Action propagateFocusEvent = BGroupAddressFE.newAction((int)4, (BValue)new BFocusEvent(), null);
    public static final Action propagateKeyEvent = BGroupAddressFE.newAction((int)4, (BValue)new BKeyEvent(), null);
    public static final Action propagateMouseEvent = BGroupAddressFE.newAction((int)4, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BGroupAddressFE.class);
    private final BTextField field = new BTextField("", 8);
    private BKnxAddressStyle addressStyle;
    public static final UiLexicon lex = UiLexicon.makeUiLexicon((BModule)TYPE.getModule());
    private static final Logger log = Logger.getLogger(TYPE.getModule().getModuleName());
    private static final String GROUP_ADDRESS_DIALOG_BASE_LEX_KEY = "groupAddressDialog.";
    private static final String GROUP_ADDRESS_DIALOG_IMPROPER_FORMAT_LEX_KEY = "groupAddressDialog.improperFormat";
    private static final String GROUP_ADDRESS_DIALOG_IMPROPER_FORMAT_DEFAULT = "Improper 'GroupAddress' format.\n{0}";

    public void propagateFocusEvent(BFocusEvent parameter) {
        this.invoke(propagateFocusEvent, (BValue)parameter, null);
    }

    public void propagateKeyEvent(BKeyEvent parameter) {
        this.invoke(propagateKeyEvent, (BValue)parameter, null);
    }

    public void propagateMouseEvent(BMouseEvent parameter) {
        this.invoke(propagateMouseEvent, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BGroupAddressFE() {
        this.field.setController((TextController)new Controller());
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.field, (Slot)BWidget.focusEvent, (Slot)propagateFocusEvent);
        this.linkTo("lk3", (BComponent)this.field, (Slot)BWidget.keyEvent, (Slot)propagateKeyEvent);
        this.linkTo("lk4", (BComponent)this.field, (Slot)BWidget.mouseEvent, (Slot)propagateMouseEvent);
        this.setContent((BWidget)this.field);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BKnxAddress knxAddress = (BKnxAddress)value.as(BKnxAddress.class);
        this.field.setText(knxAddress.getFriendlyAddress());
        this.addressStyle = ((BKnxAddress)value).getAddressStyle();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BGroupAddress gp = (BGroupAddress)value;
        gp.setStyle(this.addressStyle.getAddressStyle());
        String s = this.field.getText();
        try {
            gp.setFriendlyAddress(s);
        }
        catch (Exception ex) {
            MessageFormat mf = new MessageFormat(lex.get(GROUP_ADDRESS_DIALOG_IMPROPER_FORMAT_LEX_KEY, GROUP_ADDRESS_DIALOG_IMPROPER_FORMAT_DEFAULT));
            throw new CannotSaveException(mf.format(new Object[]{ex.getLocalizedMessage()}));
        }
        return gp;
    }

    protected void doSetReadonly(boolean readonly) {
        this.setEnabled(!readonly);
    }

    public void setEnabled(boolean value) {
        this.field.setEditable(value);
    }

    public void doPropagateFocusEvent(BFocusEvent evt) {
        if (!this.isModified()) {
            try {
                IKnxAddress knxAddress = this.addressStyle.getFriendlyAddress(this.field.getText());
                BGroupAddress ga = (BGroupAddress)knxAddress;
                if (ga.isZero()) {
                    this.setModified();
                }
            }
            catch (IllegalArgumentException ex) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(ex.getMessage());
                }
                this.setModified();
            }
        }
        this.fireFocusEvent(new BFocusEvent(evt.getId(), (BWidget)this, evt.isTemporary()));
    }

    public void doPropagateKeyEvent(BKeyEvent evt) {
        this.fireKeyEvent(new BKeyEvent(evt.getId(), (BWidget)this, evt.getModifiers(), evt.getKeyCode(), evt.getKeyChar()));
    }

    public void doPropagateMouseEvent(BMouseEvent evt) {
        this.fireMouseEvent(new BMouseEvent(evt.getId(), (BWidget)this, evt.getModifiers(), evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger()));
    }

    private class Controller
    extends TextController {
        private Controller() {
        }

        public void keyTyped(BKeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == ' ') {
                keyChar = BGroupAddressFE.this.addressStyle.getSeparator();
                int modifiers = event.getModifiers();
                int keyCode = event.getKeyCode();
                int id = event.getId();
                BWidget source = event.getWidget();
                event.consume();
                super.keyTyped(new BKeyEvent(id, source, modifiers, keyCode, keyChar));
            } else {
                super.keyTyped(event);
            }
            String updatedText = ((BTextEditor)event.getWidget()).getText();
            boolean isValid = false;
            for (BKnxAddressStyle style : BKnxAddressStyle.ALL_GA_STYLES) {
                if (!EtsUtil.isValidGroupAddress(updatedText, style)) continue;
                BGroupAddressFE.this.addressStyle = style;
                isValid = true;
                break;
            }
            this.setOkButtonEnabled(isValid);
        }

        protected void setOkButtonEnabled(boolean enabled) {
            BWidget[] aWidgets;
            for (BWidget widget : aWidgets = this.getShell().getChildWidgets()) {
                if (!"okButton".equals(widget.getName())) continue;
                widget.setEnabled(enabled);
            }
        }
    }
}

