/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon;

import com.tridium.crypto.core.cert.NKey;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.platcrypto.daemon.BPlatCryptoBase;
import com.tridium.platcrypto.daemon.messages.DeleteEntryMessage;
import com.tridium.platcrypto.daemon.messages.GetCertificateAliasMessage;
import com.tridium.platcrypto.daemon.messages.GetCertificateChainMessage;
import com.tridium.platcrypto.daemon.messages.GetCertificateMessage;
import com.tridium.platcrypto.daemon.messages.GetCertificatesMessage;
import com.tridium.platcrypto.daemon.messages.GetKeyMessage;
import com.tridium.platcrypto.daemon.messages.KeyStoreMessage;
import com.tridium.platcrypto.daemon.messages.SaveMessage;
import com.tridium.platcrypto.daemon.messages.SetCertificateEntryMessage;
import com.tridium.platcrypto.daemon.messages.SetKeyEntryMessage;
import com.tridium.platcrypto.daemon.messages.SetKeyEntryWithResponseMessage;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;

@NiagaraType
public class BPlatKeyStore
extends BPlatCryptoBase
implements ICoreKeyStore {
    public static final Type TYPE = Sys.loadType(BPlatKeyStore.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BPlatKeyStore() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public BPlatKeyStore(BDaemonSession session) {
        super(session);
    }

    public String getKeyStoreType() {
        return "userKeyStore";
    }

    private List<String> getAliases() throws Exception {
        InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)new KeyStoreMessage(this.getKeyStoreType()));
        XElem keyStore = XParser.make((InputStream)in).parse();
        XElem[] keys = keyStore.elems("key");
        ArrayList<String> aliases = new ArrayList<String>(keys != null ? keys.length : 0);
        if (keys != null) {
            for (XElem key : keys) {
                String alias = key.get("alias");
                if (alias == null || alias.length() <= 0) continue;
                aliases.add(alias);
            }
        }
        return aliases;
    }

    public Enumeration<String> aliases() throws Exception {
        return Collections.enumeration(this.getAliases());
    }

    public boolean containsAlias(String alias) throws Exception {
        return this.getAliases().contains(alias.toLowerCase(Locale.ENGLISH));
    }

    public void deleteEntries(String[] aliases) throws Exception {
        for (String alias : aliases) {
            this.deleteEntry(alias);
        }
    }

    public void deleteEntry(String alias) throws Exception {
        this.getDaemonSession().sendMessage((DaemonMessage)new DeleteEntryMessage(this.getKeyStoreType(), alias));
    }

    public X509Certificate[] getCertificateChain(String alias) throws Exception {
        XElem[] certs = this.send(new GetCertificateChainMessage(this.getKeyStoreType(), alias), "certificate");
        if (certs == null || certs.length == 0) {
            return null;
        }
        X509Certificate[] certificates = new X509Certificate[certs.length];
        for (int i = 0; i < certificates.length; ++i) {
            if (certs[i] == null || certs[i].text() == null || certs[i].text().length() <= 0) continue;
            certificates[i] = NX509Certificate.decodeFromString((String)certs[i].text().string());
        }
        return certificates;
    }

    public Key getKey(String alias, char[] password) throws Exception {
        SharedSecretKey sharedKey = this.getDaemonSession().generateSharedSecretKey("getKey");
        InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)new GetKeyMessage(this.getKeyStoreType(), alias, password, sharedKey));
        try {
            String key;
            XText value;
            XElem keyElem = XParser.make((InputStream)in).parse();
            if (keyElem != null && (value = keyElem.text()) != null && (key = value.toString()) != null && key.length() > 0) {
                String decrypted = sharedKey.decryptChars(Base64.getDecoder().decode(key)).asString(true);
                return NKey.decodeFromString((String)decrypted);
            }
        }
        catch (Exception e) {
            if (password == null && alias != null) {
                logger.log(Level.FINE, "unable to retrieve key '" + alias + "' without a password (" + e + ")");
            }
            logger.log(Level.SEVERE, "unable to retrieve key '" + alias + "' with provided password", e);
        }
        throw new UnrecoverableKeyException("unable to recover key");
    }

    public Date getCreationDate(String alias) throws Exception {
        String date;
        InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)new KeyStoreMessage(this.getKeyStoreType(), alias));
        XElem[] keys = XParser.make((InputStream)in).parse().elems("key");
        if (keys.length > 0 && (date = keys[0].get("creationDate")) != null && date.length() == "yyyy-MM-dd HH:mm:ss".length()) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return format.parse(date);
        }
        return null;
    }

    public boolean isKeyEntry(String alias) throws Exception {
        InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)new KeyStoreMessage(this.getKeyStoreType(), alias));
        XElem[] keys = XParser.make((InputStream)in).parse().elems("key");
        return keys.length > 0 && keys[0].getb("keyEntry");
    }

    public boolean isCertificateEntry(String alias) throws Exception {
        InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)new KeyStoreMessage(this.getKeyStoreType(), alias));
        XElem[] keys = XParser.make((InputStream)in).parse().elems("key");
        return keys.length > 0 && keys[0].getb("certEntry");
    }

    public void setCertificateEntry(String alias, X509Certificate cert) throws Exception {
        this.send(new SetCertificateEntryMessage(this.getKeyStoreType(), alias, cert));
    }

    public void setKeyEntry(String alias, byte[] key, X509Certificate[] chain) throws Exception {
        XElem response = this.send(new SetKeyEntryWithResponseMessage(this.getKeyStoreType(), alias, key, chain, this.getDaemonSession().generateSharedSecretKey("setKeyEntryWithResponse")));
        if (response.text() != null) {
            if (!response.text().string().equalsIgnoreCase("success")) {
                throw new Exception(response.text().string());
            }
        } else {
            this.send(new SetKeyEntryMessage(this.getKeyStoreType(), alias, key, chain, this.getDaemonSession().generateSharedSecretKey("setKeyEntry")));
        }
    }

    public void setKeyEntry(String alias, Key key, char[] password, X509Certificate[] chain) throws Exception {
        XElem response = this.send(new SetKeyEntryWithResponseMessage(this.getKeyStoreType(), alias, key, password, chain, this.getDaemonSession().generateSharedSecretKey("setKeyEntryWithResponse")));
        if (response.text() != null) {
            if (!response.text().string().equalsIgnoreCase("success")) {
                throw new Exception(response.text().string());
            }
        } else {
            this.send(new SetKeyEntryMessage(this.getKeyStoreType(), alias, key, password, chain, this.getDaemonSession().generateSharedSecretKey("setKeyEntry")));
        }
    }

    public Enumeration<NX509CertificateEntry> getCertificates() throws Exception {
        XElem[] certificates = this.send(new GetCertificatesMessage(this.getKeyStoreType()), "certificateEntry");
        ArrayList<NX509CertificateEntry> certs = new ArrayList<NX509CertificateEntry>(certificates != null ? certificates.length : 0);
        if (certificates != null) {
            for (XElem certificate : certificates) {
                String certEntry = certificate.text().toString();
                if (certEntry == null || certEntry.length() <= 0) continue;
                certs.add(NX509CertificateEntry.decodeFromString((String)certEntry));
            }
        }
        return Collections.enumeration(certs);
    }

    public String findCertificate(X509Certificate cert) throws Exception {
        Enumeration<NX509CertificateEntry> certs = this.getCertificates();
        while (certs.hasMoreElements()) {
            NX509CertificateEntry certEntry = certs.nextElement();
            NX509Certificate otherCert = certEntry.getCertificate(0);
            if (otherCert == null || !otherCert.getPublicKey().equals(cert.getPublicKey())) continue;
            return certEntry.getAlias();
        }
        return null;
    }

    public X509Certificate getCertificate(String alias) throws Exception {
        XElem certificate = this.send(new GetCertificateMessage(this.getKeyStoreType(), alias));
        if (certificate != null && certificate.text() != null) {
            String cert = certificate.text().toString();
            return NX509Certificate.decodeFromString((String)cert);
        }
        return null;
    }

    public String getCertificateAlias(X509Certificate cert) throws Exception {
        InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)new GetCertificateAliasMessage(this.getKeyStoreType(), cert));
        XElem keyStore = XParser.make((InputStream)in).parse();
        return keyStore.get("alias");
    }

    public int size() throws Exception {
        return this.getAliases().size();
    }

    public long getLastModified() throws Exception {
        return 0L;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void load() throws Exception {
    }

    public void save() throws Exception {
        this.send(new SaveMessage(this.getKeyStoreType()));
    }

    public KeyStore getKeyStore() throws Exception {
        throw new UnsupportedOperationException("can't access raw keystore remotely");
    }
}

