/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email.converters;

import javax.baja.agent.BIAgent;
import javax.baja.data.BIDataValue;
import javax.baja.email.BEmailAddress;
import javax.baja.email.BEmailAddressList;
import javax.baja.email.converters.BAbstractStringToEmailAddressConverter;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BStringToEmailAddressList
extends BAbstractStringToEmailAddressConverter
implements BIAgent {
    public static final Property delimiter = BStringToEmailAddressList.newProperty((int)0, (String)",", (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1), (String)"max", (BIDataValue)BInteger.make((int)1), (String)"fieldWidth", (BIDataValue)BInteger.make((int)1)));
    public static final Type TYPE = Sys.loadType(BStringToEmailAddressList.class);

    public final String getDelimiter() {
        return this.getString(delimiter);
    }

    public final void setDelimiter(String delimiter) {
        this.setString(BStringToEmailAddressList.delimiter, delimiter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        BString emailString = (BString)from;
        if (emailString.equals((Object)BString.DEFAULT)) {
            return BEmailAddressList.NULL;
        }
        Array list = new Array(BEmailAddress.class);
        String[] addresses = TextUtil.split((String)emailString.toString(), (char)this.getDelimiter().toString().charAt(0));
        for (int i = 0; i < addresses.length; ++i) {
            BEmailAddress address = this.getEmailAddress(addresses[i].trim());
            if (address == null) continue;
            list.add((Object)address);
        }
        return BEmailAddressList.make((BEmailAddress[])list.trim());
    }
}

