/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email.converters;

import javax.baja.agent.BIAgent;
import javax.baja.data.BIDataValue;
import javax.baja.email.BEmailAddress;
import javax.baja.email.BEmailAddressList;
import javax.baja.email.converters.BStringToEmailAddressList;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;
import javax.baja.util.BFormat;

public final class BEmailAddressListToStatusString
extends BConverter
implements BIAgent {
    public static final Property format = BEmailAddressListToStatusString.newProperty((int)0, (BValue)BFormat.make((String)"\"%personal%\" <%address%>"), (BFacets)BFacets.NULL);
    public static final Property delimiter = BEmailAddressListToStatusString.newProperty((int)0, (String)",", (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1), (String)"max", (BIDataValue)BInteger.make((int)1), (String)"fieldWidth", (BIDataValue)BInteger.make((int)1)));
    public static final Type TYPE = Sys.loadType(BEmailAddressListToStatusString.class);

    public final BFormat getFormat() {
        return (BFormat)this.get(format);
    }

    public final void setFormat(BFormat format) {
        this.set(BEmailAddressListToStatusString.format, (BValue)format, null);
    }

    public final String getDelimiter() {
        return this.getString(delimiter);
    }

    public final void setDelimiter(String delimiter) {
        this.setString(BStringToEmailAddressList.delimiter, delimiter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        BEmailAddressList emailAddressList = (BEmailAddressList)from;
        BStatusString statusString = (BStatusString)to;
        if (emailAddressList.isNull()) {
            statusString.setStatus(64);
        } else {
            StringBuffer buffer = new StringBuffer();
            BEmailAddress[] addresses = emailAddressList.getAddresses();
            for (int i = 0; i < addresses.length; ++i) {
                buffer.append(this.getFormat().format((Object)addresses[i]));
                if (i + 1 >= addresses.length) continue;
                buffer.append(this.getDelimiter());
            }
            statusString.setStatus(BStatus.ok);
            statusString.setValue(buffer.toString());
        }
        return statusString;
    }
}

