/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email;

import com.tridium.email.EmailUtil;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAccount;
import javax.baja.email.BEmailAddress;
import javax.baja.email.BEmailService;
import javax.baja.email.BTransport;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Queue;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

public class BOutgoingAccount
extends BEmailAccount {
    public static final Property port = BOutgoingAccount.newProperty((int)0, (int)25, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)-1)));
    public static final Property transport = BOutgoingAccount.newProperty((int)0, (BValue)BTransport.smtp, null);
    public static final Property connectionTimeout = BOutgoingAccount.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), null);
    public static final Property useAuthentication = BOutgoingAccount.newProperty((int)0, (boolean)false, null);
    public static final Property replyTo = BOutgoingAccount.newProperty((int)0, (BValue)BEmailAddress.DEFAULT, null);
    public static final Property persistent = BOutgoingAccount.newProperty((int)0, (boolean)false, null);
    public static final Property persistenceDirectory = BOutgoingAccount.newProperty((int)0, (BValue)BOrd.make((String)"file:^email"), null);
    public static final Property allowDisabledQueueing = BOutgoingAccount.newProperty((int)0, (boolean)false, null);
    public static final Property queueSize = BOutgoingAccount.newProperty((int)3, (int)0, null);
    public static final Property maxQueueSize = BOutgoingAccount.newProperty((int)0, (int)100, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property numberSent = BOutgoingAccount.newProperty((int)3, (int)0, null);
    public static final Property maxSendablePerDay = BOutgoingAccount.newProperty((int)0, (int)100, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property numberDiscarded = BOutgoingAccount.newProperty((int)3, (int)0, null);
    public static final Property lastDiscard = BOutgoingAccount.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastDiscardCause = BOutgoingAccount.newProperty((int)1, (String)"", null);
    public static final Action send = BOutgoingAccount.newAction((int)0, (BValue)new BEmail(), null);
    public static final Action clearQueue = BOutgoingAccount.newAction((int)0, null);
    public static final Action resetNumberSent = BOutgoingAccount.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BOutgoingAccount.class);
    private static final BIcon icon = BIcon.std((String)"outbox.png");
    private BOrd oldPersistenceDirectory = null;
    private File dirFile = null;
    private final Queue q = new Queue();
    private final Set<File> undeletable = new HashSet<File>();
    private Clock.Ticket ticket;

    public BTransport getTransport() {
        return (BTransport)this.get(transport);
    }

    public void setTransport(BTransport v) {
        this.set(transport, (BValue)v, null);
    }

    public BRelTime getConnectionTimeout() {
        return (BRelTime)this.get(connectionTimeout);
    }

    public void setConnectionTimeout(BRelTime v) {
        this.set(connectionTimeout, (BValue)v, null);
    }

    public boolean getUseAuthentication() {
        return this.getBoolean(useAuthentication);
    }

    public void setUseAuthentication(boolean v) {
        this.setBoolean(useAuthentication, v, null);
    }

    public BEmailAddress getReplyTo() {
        return (BEmailAddress)this.get(replyTo);
    }

    public void setReplyTo(BEmailAddress v) {
        this.set(replyTo, (BValue)v, null);
    }

    public boolean getPersistent() {
        return this.getBoolean(persistent);
    }

    public void setPersistent(boolean v) {
        this.setBoolean(persistent, v, null);
    }

    public BOrd getPersistenceDirectory() {
        return (BOrd)this.get(persistenceDirectory);
    }

    public void setPersistenceDirectory(BOrd v) {
        this.set(persistenceDirectory, (BValue)v, null);
    }

    public boolean getAllowDisabledQueueing() {
        return this.getBoolean(allowDisabledQueueing);
    }

    public void setAllowDisabledQueueing(boolean v) {
        this.setBoolean(allowDisabledQueueing, v, null);
    }

    public int getQueueSize() {
        return this.getInt(queueSize);
    }

    public void setQueueSize(int v) {
        this.setInt(queueSize, v, null);
    }

    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    public void setMaxQueueSize(int v) {
        this.setInt(maxQueueSize, v, null);
    }

    public int getNumberSent() {
        return this.getInt(numberSent);
    }

    public void setNumberSent(int v) {
        this.setInt(numberSent, v, null);
    }

    public int getMaxSendablePerDay() {
        return this.getInt(maxSendablePerDay);
    }

    public void setMaxSendablePerDay(int v) {
        this.setInt(maxSendablePerDay, v, null);
    }

    public int getNumberDiscarded() {
        return this.getInt(numberDiscarded);
    }

    public void setNumberDiscarded(int v) {
        this.setInt(numberDiscarded, v, null);
    }

    public BAbsTime getLastDiscard() {
        return (BAbsTime)this.get(lastDiscard);
    }

    public void setLastDiscard(BAbsTime v) {
        this.set(lastDiscard, (BValue)v, null);
    }

    public String getLastDiscardCause() {
        return this.getString(lastDiscardCause);
    }

    public void setLastDiscardCause(String v) {
        this.setString(lastDiscardCause, v, null);
    }

    public void send(BEmail email) {
        this.invoke(send, (BValue)email, null);
    }

    public void clearQueue() {
        this.invoke(clearQueue, null, null);
    }

    public void resetNumberSent() {
        this.invoke(resetNumberSent, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void started() throws Exception {
        super.started();
        if (this.getPersistent()) {
            BOutgoingAccount bOutgoingAccount = this;
            synchronized (bOutgoingAccount) {
                this.setQueueSize(this.dirFile().listFiles().length);
            }
            this.oldPersistenceDirectory = this.getPersistenceDirectory();
        } else {
            this.setQueueSize(this.q.size());
        }
        this.ticket = this.midnight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changed(Property prop, Context cx) {
        block20: {
            super.changed(prop, cx);
            if (!this.isRunning()) {
                return;
            }
            if (prop.equals(persistent)) {
                try {
                    if (this.getQueueSize() <= 0) break block20;
                    if (this.getPersistent()) {
                        File file = null;
                        BOutgoingAccount bOutgoingAccount = this;
                        synchronized (bOutgoingAccount) {
                            file = new File(this.dirFile(), BUuid.make().toString() + ".xml");
                        }
                        while (!this.q.isEmpty()) {
                            BEmail email = (BEmail)((Object)this.q.dequeue());
                            new ValueDocEncoder(file).encodeDocument((BValue)email);
                        }
                        this.oldPersistenceDirectory = this.getPersistenceDirectory();
                        break block20;
                    }
                    BEmailService service = this.getService();
                    File[] kids = this.dirFile().listFiles();
                    for (int i = 0; i < kids.length; ++i) {
                        BEmail email = (BEmail)new ValueDocDecoder(kids[i]).decodeDocument();
                        this.q.enqueue((Object)email);
                        this.deleteFile(kids[i], service);
                    }
                }
                catch (Exception e) {
                    BEmailService.log.log(Level.SEVERE, "BOutgoingAccount unable to set switch Email Directory", e);
                }
            }
        }
        if (prop.equals(persistenceDirectory)) {
            try {
                this.setDirFile();
                if (this.getPersistent() && this.getQueueSize() > 0) {
                    File oldDir = this.getDirFile(this.oldPersistenceDirectory);
                    File[] files = oldDir.listFiles();
                    BEmailService service = this.getService();
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            String name = files[i].getName();
                            BEmail email = (BEmail)new ValueDocDecoder(files[i]).decodeDocument();
                            File file = new File(this.dirFile(), name);
                            new ValueDocEncoder(file).encodeDocument((BValue)email);
                            continue;
                        }
                        catch (Exception e) {
                            BEmailService.log.log(Level.SEVERE, "BOutgoingAccount unable to move email Persistence Location", e);
                            continue;
                        }
                        finally {
                            this.deleteFile(files[i], service);
                        }
                    }
                    this.oldPersistenceDirectory = this.getPersistenceDirectory();
                }
            }
            catch (IOException e) {
                BEmailService.log.log(Level.SEVERE, "BOutgoingAccount unable to set persistant Email Directory", e);
            }
        }
    }

    @Override
    public void poll() throws Exception {
        this.pollQueue();
        this.pollUndeletables();
    }

    public void pollUndeletables() {
        if (this.undeletable.size() > 0) {
            BEmailService service = this.getService();
            Object[] files = this.undeletable.toArray();
            for (int i = 0; i < files.length; ++i) {
                this.deleteFile((File)files[i], service);
            }
        }
    }

    public void pollQueue() throws Exception {
        BEmailService.log.fine("BOutgoingAccount poll start");
        if (this.getPersistent() ? this.getQueueSize() == 0 : this.q.isEmpty()) {
            return;
        }
        if (this.getNumberSent() >= this.getMaxSendablePerDay()) {
            BEmailService service = this.getService();
            if (service != null) {
                BEmailService.log.log(Level.SEVERE, "BOutgoingAccount has already sent too many, ignoring poll request and clearing queue.");
            }
            this.doClearQueue();
            return;
        }
        Session session = this.mailPlatformHandler.getOutgoingSession(this);
        session.setDebug(this.getDebug());
        session.setDebugOut(System.out);
        Transport transport = null;
        transport = session.getTransport("smtp");
        transport.connect();
        if (this.getPersistent()) {
            this.dequeueDisk(transport, session);
        } else {
            this.dequeueMemory(transport, session);
        }
        transport.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSend(BEmail email, Context cx) {
        BEmailService service = this.getService();
        if (!(this.getAllowDisabledQueueing() || this.getEnabled() && this.isOperational())) {
            this.addDiscarded("BOutgoingAccount queue disabled, discarding email.", null, 1, false);
            return;
        }
        if (this.getQueueSize() >= this.getMaxQueueSize()) {
            this.addDiscarded("BOutgoingAccount queue is full, discarding email.");
            return;
        }
        if (this.getNumberSent() >= this.getMaxSendablePerDay()) {
            this.addDiscarded("BOutgoingAccount has already sent too many, discarding email and clearing queue.");
            this.doClearQueue();
            return;
        }
        if (email.getFrom().equals((Object)BEmailAddress.DEFAULT)) {
            email.setFrom(this.getReplyTo());
        }
        try {
            if (this.getPersistent()) {
                File file = null;
                BOutgoingAccount bOutgoingAccount = this;
                synchronized (bOutgoingAccount) {
                    file = new File(this.dirFile(), BUuid.make().toString() + ".xml");
                }
                new ValueDocEncoder(file).encodeDocument((BValue)email);
                bOutgoingAccount = this;
                synchronized (bOutgoingAccount) {
                    this.setQueueSize(this.dirFile().listFiles().length);
                }
            }
            this.q.enqueue((Object)email);
            this.setQueueSize(this.q.size());
            BEmailService.log.fine("BOutgoingAccount has just enqueued an email for delivery.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addDiscarded("BOutgoingAccount could not enqueue email", e);
        }
    }

    public void doClearQueue() {
        BEmailService service = this.getService();
        int amount = this.getQueueSize();
        if (this.getPersistent() && this.getQueueSize() > 0) {
            try {
                File[] kids = this.dirFile().listFiles();
                for (int i = 0; i < kids.length; ++i) {
                    this.deleteFile(kids[i], service);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (service != null) {
                    BEmailService.log.log(Level.SEVERE, "BOutgoingAccount could not clear queue: ", e);
                }
                --amount;
            }
        } else {
            this.q.clear();
        }
        if (amount > 0) {
            this.addDiscarded("BOutgoingAccount queue cleared.", null, amount, false);
        }
        this.setQueueSize(0);
    }

    public void doResetNumberSent() {
        this.ticket.cancel();
        this.ticket = this.midnight();
        this.setNumberSent(0);
        this.setNumberDiscarded(0);
    }

    private File dirFile() throws IOException {
        if (this.dirFile == null) {
            return this.setDirFile();
        }
        return this.dirFile;
    }

    private File setDirFile() throws IOException {
        BFileSystem fs = BFileSystem.INSTANCE;
        FilePath path = (FilePath)this.getPersistenceDirectory().parse()[0];
        BDirectory bdir = fs.makeDir(path);
        this.dirFile = ((BLocalFileStore)bdir.getStore()).getLocalFile();
        return this.dirFile;
    }

    private File getDirFile(BOrd directory) throws IOException {
        BFileSystem fs = BFileSystem.INSTANCE;
        FilePath path = (FilePath)directory.parse()[0];
        BDirectory bdir = fs.makeDir(path);
        return ((BLocalFileStore)bdir.getStore()).getLocalFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dequeueDisk(Transport transport, Session session) throws Exception {
        BEmailService service = this.getService();
        File dir = this.dirFile();
        File[] kids = dir.listFiles();
        Arrays.sort(kids, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return (int)(f1.lastModified() - f2.lastModified());
            }
        });
        int currentNumberSent = 0;
        for (int i = 0; i < kids.length; ++i) {
            if (this.getNumberSent() >= this.getMaxSendablePerDay()) {
                if (service != null) {
                    BEmailService.log.log(Level.SEVERE, "BOutgoingAccount has already sent too many, discarding email and clearing queue.");
                }
                this.doClearQueue();
                return;
            }
            try {
                if (this.undeletable.contains(kids[i])) continue;
                BEmail email = (BEmail)new ValueDocDecoder(kids[i]).decodeDocument();
                MimeMessage msg = EmailUtil.toMessage(email, session);
                if (msg.getAllRecipients() == null || msg.getAllRecipients().length == 0) {
                    throw new BajaRuntimeException("There must be at least one email address in the To, Cc, or Bcc fields.");
                }
                try {
                    AccessController.doPrivileged(() -> BOutgoingAccount.lambda$dequeueDisk$0(transport, (Message)msg));
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
                this.setNumberSent(this.getNumberSent() + 1);
                ++currentNumberSent;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addDiscarded("BOutgoingAccount could not dequeue persistent email", e);
                continue;
            }
            finally {
                this.deleteFile(kids[i], service);
            }
        }
        if (currentNumberSent > 0) {
            BEmailService.log.fine("BOutgoingAccount has just sent " + currentNumberSent + " email(s).");
        }
        this.setQueueSize(0);
    }

    private void deleteFile(File file, BEmailService service) {
        if (file.delete()) {
            if (this.undeletable.contains(file)) {
                this.undeletable.remove(file);
            }
        } else if (!this.undeletable.contains(file)) {
            this.undeletable.add(file);
            file.deleteOnExit();
        }
    }

    private void dequeueMemory(Transport transport, Session session) throws Exception {
        BEmailService service = this.getService();
        int currentNumberSent = 0;
        while (!this.q.isEmpty()) {
            if (this.getNumberSent() >= this.getMaxSendablePerDay()) {
                this.addDiscarded("BOutgoingAccount has already sent too many, discarding email and clearing queue.", null, this.getQueueSize(), true);
                this.doClearQueue();
                return;
            }
            BEmail email = (BEmail)((Object)this.q.dequeue());
            try {
                MimeMessage msg = EmailUtil.toMessage(email, session);
                Address[] recipients = msg.getAllRecipients();
                if (recipients == null || recipients.length == 0) {
                    throw new BajaRuntimeException("There must be at least one email address in the To, Cc, or Bcc fields.");
                }
                try {
                    AccessController.doPrivileged(() -> BOutgoingAccount.lambda$dequeueMemory$1(transport, (Message)msg, recipients));
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
                this.setNumberSent(this.getNumberSent() + 1);
                ++currentNumberSent;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addDiscarded("BOutgoingAccount could not dequeue in-memory email", e);
            }
        }
        if (currentNumberSent > 0) {
            BEmailService.log.fine("BOutgoingAccount has just sent " + currentNumberSent + " email(s).");
        }
        this.setQueueSize(0);
    }

    private Clock.Ticket midnight() {
        BAbsTime now = BAbsTime.now();
        BAbsTime next = now.nextDay();
        BAbsTime midnight = next.timeOfDay(0, 0, 0, 0);
        return Clock.schedule((BComponent)this, (BAbsTime)midnight, (Action)resetNumberSent, null);
    }

    public void addDiscarded(String message) {
        this.addDiscarded(message, null);
    }

    public void addDiscarded(Exception e) {
        this.addDiscarded(null, e);
    }

    public void addDiscarded(String message, Exception e) {
        this.addDiscarded(message, e, 1, true);
    }

    public void addDiscarded(String message, Exception e, int amount, boolean logError) {
        this.setNumberDiscarded(this.getNumberDiscarded() + amount);
        this.setLastDiscard(BAbsTime.now());
        StringBuffer b = new StringBuffer();
        if (message != null && message.length() > 0) {
            b.append(message);
        }
        if (message != null && message.length() > 0 && e != null) {
            b.append(": ");
        }
        if (e != null) {
            b.append(e.getMessage());
        }
        if (e != null && e.getCause() != null) {
            b.append(": ").append(e.getCause().getMessage());
        }
        this.setLastDiscardCause(b.toString());
        if (logError) {
            BEmailService.log.log(Level.SEVERE, b.toString(), e);
        } else {
            BEmailService.log.fine(b.toString());
        }
    }

    private static /* synthetic */ Object lambda$dequeueMemory$1(Transport transport, Message msg, Address[] recipients) throws Exception {
        transport.sendMessage(msg, recipients);
        return null;
    }

    private static /* synthetic */ Object lambda$dequeueDisk$0(Transport transport, Message msg) throws Exception {
        transport.sendMessage(msg, msg.getAllRecipients());
        return null;
    }
}

