/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email;

import com.tridium.email.EmailUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.email.BDeliveryPolicy;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAccount;
import javax.baja.email.BEmailRead;
import javax.baja.email.BEmailService;
import javax.baja.email.BStore;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;

public class BIncomingAccount
extends BEmailAccount {
    public static final Property port = BIncomingAccount.newProperty((int)0, (int)110, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)-1)));
    public static final Property store = BIncomingAccount.newProperty((int)0, (BValue)BStore.pop3, null);
    public static final Property deliveryPolicy = BIncomingAccount.newProperty((int)0, (BValue)BDeliveryPolicy.delete, null);
    public static final Property emailToRead = BIncomingAccount.newProperty((int)0, (BValue)BEmailRead.unreadEmail, null);
    public static final Topic received = BIncomingAccount.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BIncomingAccount.class);
    private static final BIcon icon = BIcon.std((String)"inbox.png");

    public BStore getStore() {
        return (BStore)this.get(store);
    }

    public void setStore(BStore v) {
        this.set(store, (BValue)v, null);
    }

    public BDeliveryPolicy getDeliveryPolicy() {
        return (BDeliveryPolicy)this.get(deliveryPolicy);
    }

    public void setDeliveryPolicy(BDeliveryPolicy v) {
        this.set(deliveryPolicy, (BValue)v, null);
    }

    public BEmailRead getEmailToRead() {
        return (BEmailRead)this.get(emailToRead);
    }

    public void setEmailToRead(BEmailRead v) {
        this.set(emailToRead, (BValue)v, null);
    }

    public void fireReceived(BEmail event) {
        this.fire(received, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    @Override
    public void poll() throws Exception {
        int noOfEmailToRead = 0;
        Folder inbox = this.getInbox();
        inbox.open(2);
        if (inbox.getMessageCount() == 0) {
            inbox.close(false);
            return;
        }
        BEmailService.log.fine("BIncomingAccount just received " + inbox.getMessageCount() + " email(s).");
        int emailCount = this.getEmailToRead().getEmailReadCount();
        Message[] messages = null;
        if ((this.getDeliveryPolicy() == BDeliveryPolicy.delete || this.getDeliveryPolicy() == BDeliveryPolicy.markAsRead) && this.getEmailToRead() == BEmailRead.unreadEmail) {
            messages = inbox.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false));
            noOfEmailToRead = messages.length <= emailCount ? messages.length : emailCount;
        } else {
            messages = inbox.getMessages();
            noOfEmailToRead = messages.length;
        }
        FetchProfile fp = new FetchProfile();
        fp.add(FetchProfile.Item.ENVELOPE);
        fp.add(FetchProfile.Item.FLAGS);
        fp.add("X-Mailer");
        inbox.fetch(messages, fp);
        for (int i = 0; i < noOfEmailToRead; ++i) {
            Message m;
            block12: {
                m = messages[i];
                String subject = "?";
                try {
                    BEmail mail;
                    subject = m.getSubject();
                    try {
                        mail = AccessController.doPrivileged(() -> EmailUtil.fromMessage(m));
                    }
                    catch (PrivilegedActionException e) {
                        throw e.getException();
                    }
                    this.fireReceived(mail);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BEmailService service = this.getService();
                    if (service == null) break block12;
                    BEmailService.log.log(Level.SEVERE, "BIncomingAccount could not process message: " + subject, e);
                }
            }
            if (this.getDeliveryPolicy() == BDeliveryPolicy.delete) {
                m.setFlag(Flags.Flag.DELETED, true);
                continue;
            }
            if (this.getDeliveryPolicy() == BDeliveryPolicy.markAsRead) {
                m.setFlag(Flags.Flag.SEEN, true);
                continue;
            }
            if (this.getDeliveryPolicy() != BDeliveryPolicy.markAsUnread) continue;
            m.setFlag(Flags.Flag.SEEN, false);
        }
        if (this.getDeliveryPolicy() == BDeliveryPolicy.delete) {
            inbox.close(true);
        } else {
            inbox.close(false);
        }
    }

    private Folder getInbox() throws Exception {
        Session session = this.mailPlatformHandler.getIncomingSession(this, this.store());
        Store store = session.getStore(this.store());
        store.connect();
        Folder folder = store.getDefaultFolder();
        if (folder == null) {
            throw new IllegalStateException("No default mail folder");
        }
        if ((folder = folder.getFolder("INBOX")) == null) {
            throw new IllegalStateException("No inbox folder.");
        }
        return folder;
    }

    private String store() {
        switch (this.getStore().getOrdinal()) {
            case 0: {
                return "pop3";
            }
            case 1: {
                return "imap";
            }
        }
        throw new IllegalStateException();
    }
}

