/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.email.BEmailAccount;
import javax.baja.email.BEmailService;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"email:EmailService"})})
public final class BEmailServiceSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    public static final Type TYPE = Sys.loadType(BEmailServiceSecurityDashboardProviderAgent.class);
    private BEmailService service;
    private static final String NO_EMAIL_ACCOUNTS_SUMMARY = "securityDashboard.emailService.noEmailAccounts.summary";
    private static final String NO_EMAIL_ACCOUNTS_DESCRIPTION = "securityDashboard.emailService.noEmailAccounts.description";
    private static final String DEBUG_ENABLED_FOR_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.debugEnabledForDisabledAccount.summary";
    private static final String DEBUG_DISABLED_FOR_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.debugDisabledForDisabledAccount.summary";
    private static final String DEBUG_ENABLED_FOR_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.debugEnabledForEnabledAccount.summary";
    private static final String DEBUG_DISABLED_FOR_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.debugDisabledForEnabledAccount.summary";
    private static final String ENABLING_DEBUG_DESCRIPTION = "securityDashboard.emailService.enablingDebug.description";
    private static final String NO_TLS_FOR_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.noTLSForDisabledAccount.summary";
    private static final String SPECIFIED_TLS_FOR_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.specifiedTLSForDisabledAccount.summary";
    private static final String NO_TLS_FOR_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.noTLSForEnabledAccount.summary";
    private static final String SPECIFIED_TLS_FOR_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.specifiedTLSForEnabledAccount.summary";
    private static final String DISABLING_TLS_DESCRIPTION = "securityDashboard.emailService.disablingTLS.description";

    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.service = (BEmailService)object;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)this.service.getType(), (String)"securityDashboard.emailService.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.service.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        BEmailAccount[] accounts = (BEmailAccount[])this.service.getChildren(BEmailAccount.class);
        if (accounts.length == 0) {
            items.add(SecurityDashboardItem.makeInfo((Type)TYPE, (String)NO_EMAIL_ACCOUNTS_SUMMARY, (String)NO_EMAIL_ACCOUNTS_DESCRIPTION));
        } else {
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getDebugDisabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getNoDebugDisabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getDebugEnabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getNoDebugEnabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getInsecureDisabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getSecureDisabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getInsecureEnabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getSecureEnabled(accounts, cx));
        }
        return Collections.unmodifiableList(items);
    }

    private static List<SecurityDashboardItem> getDebugDisabled(BEmailAccount[] accounts, Context context) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        List debugDisabledAccounts = Arrays.stream(accounts).filter(account -> account.getDebug() && !account.getEnabled()).map(account -> account.getDisplayName(context)).collect(Collectors.toList());
        if (!debugDisabledAccounts.isEmpty()) {
            items.add(SecurityDashboardItem.makeInfo((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)DEBUG_ENABLED_FOR_DISABLED_ACCOUNT_SUMMARY, (String)String.join((CharSequence)", ", debugDisabledAccounts)), (String)ENABLING_DEBUG_DESCRIPTION));
        }
        return items;
    }

    private static List<SecurityDashboardItem> getNoDebugDisabled(BEmailAccount[] accounts, Context context) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        List noDebugDisabledAccounts = Arrays.stream(accounts).filter(account -> !account.getDebug() && !account.getEnabled()).map(account -> account.getDisplayName(context)).collect(Collectors.toList());
        if (!noDebugDisabledAccounts.isEmpty()) {
            items.add(SecurityDashboardItem.makeInfo((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)DEBUG_DISABLED_FOR_DISABLED_ACCOUNT_SUMMARY, (String)String.join((CharSequence)", ", noDebugDisabledAccounts)), (String)ENABLING_DEBUG_DESCRIPTION));
        }
        return items;
    }

    private static List<SecurityDashboardItem> getDebugEnabled(BEmailAccount[] accounts, Context context) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        List debugEnabledAccounts = Arrays.stream(accounts).filter(account -> account.getDebug() && account.getEnabled()).map(account -> account.getDisplayName(context)).collect(Collectors.toList());
        if (!debugEnabledAccounts.isEmpty()) {
            items.add(SecurityDashboardItem.makeAlert((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)DEBUG_ENABLED_FOR_ENABLED_ACCOUNT_SUMMARY, (String)String.join((CharSequence)", ", debugEnabledAccounts)), (String)ENABLING_DEBUG_DESCRIPTION));
        }
        return items;
    }

    private static List<SecurityDashboardItem> getNoDebugEnabled(BEmailAccount[] accounts, Context context) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        List noDebugEnabledAccounts = Arrays.stream(accounts).filter(account -> !account.getDebug() && account.getEnabled()).map(account -> account.getDisplayName(context)).collect(Collectors.toList());
        if (!noDebugEnabledAccounts.isEmpty()) {
            items.add(SecurityDashboardItem.makeOk((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)DEBUG_DISABLED_FOR_ENABLED_ACCOUNT_SUMMARY, (String)String.join((CharSequence)", ", noDebugEnabledAccounts)), (String)ENABLING_DEBUG_DESCRIPTION));
        }
        return items;
    }

    private static List<SecurityDashboardItem> getInsecureDisabled(BEmailAccount[] accounts, Context context) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        List insecureDisabledAccounts = Arrays.stream(accounts).filter(account -> !account.getUseSsl() && !account.getUseStartTls() && !account.getEnabled()).map(account -> account.getDisplayName(context)).collect(Collectors.toList());
        if (!insecureDisabledAccounts.isEmpty()) {
            items.add(SecurityDashboardItem.makeInfo((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)NO_TLS_FOR_DISABLED_ACCOUNT_SUMMARY, (String)String.join((CharSequence)", ", insecureDisabledAccounts)), (String)DISABLING_TLS_DESCRIPTION));
        }
        return items;
    }

    private static List<SecurityDashboardItem> getSecureDisabled(BEmailAccount[] accounts, Context context) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        List secureDisabledAccounts = Arrays.stream(accounts).filter(account -> (account.getUseSsl() || account.getUseStartTls()) && !account.getEnabled()).map(account -> account.getDisplayName(context)).collect(Collectors.toList());
        if (!secureDisabledAccounts.isEmpty()) {
            items.add(SecurityDashboardItem.makeInfo((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)SPECIFIED_TLS_FOR_DISABLED_ACCOUNT_SUMMARY, (String)String.join((CharSequence)", ", secureDisabledAccounts)), (String)DISABLING_TLS_DESCRIPTION));
        }
        return items;
    }

    private static List<SecurityDashboardItem> getInsecureEnabled(BEmailAccount[] accounts, Context context) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        List insecureEnabledAccounts = Arrays.stream(accounts).filter(account -> !account.getUseSsl() && !account.getUseStartTls() && account.getEnabled()).map(account -> account.getDisplayName(context)).collect(Collectors.toList());
        if (!insecureEnabledAccounts.isEmpty()) {
            items.add(SecurityDashboardItem.makeAlert((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)NO_TLS_FOR_ENABLED_ACCOUNT_SUMMARY, (String)String.join((CharSequence)", ", insecureEnabledAccounts)), (String)DISABLING_TLS_DESCRIPTION));
        }
        return items;
    }

    private static List<SecurityDashboardItem> getSecureEnabled(BEmailAccount[] accounts, Context context) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        List secureEnabledAccounts = Arrays.stream(accounts).filter(account -> (account.getUseSsl() || account.getUseStartTls()) && account.getEnabled()).map(account -> account.getDisplayName(context)).collect(Collectors.toList());
        if (!secureEnabledAccounts.isEmpty()) {
            items.add(SecurityDashboardItem.makeOk((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)SPECIFIED_TLS_FOR_ENABLED_ACCOUNT_SUMMARY, (String)String.join((CharSequence)", ", secureEnabledAccounts)), (String)DISABLING_TLS_DESCRIPTION));
        }
        return items;
    }
}

