/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.ui;

import com.tridium.rdb.ui.BJobMonitorPane;
import com.tridium.rdb.util.BRdbmsUpdater;
import com.tridium.rdb.util.history.BHistoryUnicodeUpdater;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.StepWizardModel;
import com.tridium.ui.wizard.step.WidgetUiHandler;
import com.tridium.ui.wizard.step.WizardStep;
import com.tridium.ui.wizard.step.util.WizardHeaderUiHandler;
import javax.baja.driver.BDevice;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsNetwork;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;

public class RdbmsUpdateWizard {
    private final BWidget owner;
    private final BRdbmsNetwork rdbmsNetwork;
    private final Context cx;
    private static final Lexicon lex = Lexicon.make(RdbmsUpdateWizard.class);
    private static final BImage WIZARD_ICON = BImage.make((BIcon)BIcon.std((String)"wizard.png"));
    private static final BImage DATABASE_ICON = BImage.make((BIcon)BIcon.std((String)"database.png"));
    private static final String WIZARD_DIALOG_TITLE = lex.getText("rdb.wizard.dialog.title");
    private static final String STEP1_TITLE = lex.getText("rdb.wizard.step1.title");
    private static final String STEP1_DESC = lex.getText("rdb.wizard.step1.description");
    private static final String STEP2_UNICODE_TITLE = lex.getText("rdb.wizard.step2.unicode.title");
    private static final String STEP2_UNICODE_DESC = lex.getText("rdb.wizard.step2.unicode.description");
    private static final String STEP3_UNICODE_TITLE = lex.getText("rdb.wizard.step3.unicode.title");
    private static final String STEP3_UNICODE_DESC = lex.getText("rdb.wizard.step3.unicode.description");
    private final BCheckBox step1UnicodeUpdateCb = new BCheckBox(lex.getText("rdb.wizard.step1.unicodeCbLabel"), true);
    private final BCheckList unicodeDbList = new BCheckList();

    private RdbmsUpdateWizard(BWidget owner, BRdbmsNetwork rdbmsNetwork, Context cx) {
        this.owner = owner;
        this.rdbmsNetwork = rdbmsNetwork;
        this.cx = cx;
    }

    public static RdbmsUpdateWizard make(BWidget owner, BRdbmsNetwork rdbms, Context cx) {
        return new RdbmsUpdateWizard(owner, rdbms, cx);
    }

    public CommandArtifact doInvoke() {
        BWizard.open((BWidget)this.owner, (WizardModel)this.makeWizardModel());
        return null;
    }

    private WizardModel makeWizardModel() {
        WizardStep step1 = RdbmsUpdateWizard.makeStep(STEP1_TITLE, STEP1_DESC, this.makeStep1Widget());
        WizardStep unicodeSelectDbStep = RdbmsUpdateWizard.makeStep(STEP2_UNICODE_TITLE, STEP2_UNICODE_DESC, this.makeSelectDbsWidget(this.unicodeDbList));
        step1.setRouter((artifact, model, view, cx) -> this.step1UnicodeUpdateCb.isSelected() ? unicodeSelectDbStep : null);
        unicodeSelectDbStep.setRouter((artifact, model, view, cx) -> RdbmsUpdateWizard.makeStep(STEP3_UNICODE_TITLE, STEP3_UNICODE_DESC, this.makeJobProgressWidget(this.unicodeDbList, (BRdbmsUpdater)new BHistoryUnicodeUpdater())));
        return new StepWizardModel(StepModel.make((WizardStep)step1), WIZARD_DIALOG_TITLE);
    }

    private static WizardStep makeStep(String title, String desc, BWidget widget) {
        WizardHeaderUiHandler uiHandler = new WizardHeaderUiHandler(WIZARD_ICON, title, desc, (WizardStep.IUiHandler)new WidgetUiHandler(widget));
        return new WizardStep((WizardStep.IUiHandler)uiHandler);
    }

    private BWidget makeStep1Widget() {
        BGridPane gp = new BGridPane(1, new BWidget[]{this.step1UnicodeUpdateCb});
        gp.setHalign(BHalign.left);
        gp.setValign(BValign.top);
        return new BBorderPane((BWidget)gp, BInsets.make((double)10.0));
    }

    private BWidget makeSelectDbsWidget(BCheckList checkList) {
        for (BRdbms db : this.getDatabases()) {
            checkList.addItem(DATABASE_ICON, (Object)new DbEntry(db.getDisplayName(null), db.getHandleOrd()));
        }
        return new BBorderPane((BWidget)checkList, BInsets.make((double)10.0));
    }

    private BWidget makeJobProgressWidget(BCheckList list, BRdbmsUpdater updater) {
        BOrdList dbOrdList = RdbmsUpdateWizard.getDbOrdList(list);
        updater.setDatabaseOrds(dbOrdList);
        return new BJobMonitorPane(updater, this.rdbmsNetwork);
    }

    private static BOrdList getDbOrdList(BCheckList checkList) {
        Object[] selectedEntries = checkList.getSelectedItems();
        Array dbOrds = new Array(BOrd.class);
        for (Object selectedEntry : selectedEntries) {
            DbEntry entry = (DbEntry)selectedEntry;
            dbOrds.add((Object)entry.dbOrd);
        }
        return BOrdList.make((BOrd[])((BOrd[])dbOrds.trim()));
    }

    private BRdbms[] getDatabases() {
        if (this.rdbmsNetwork == null) {
            return new BRdbms[0];
        }
        Array databases = new Array(BRdbms.class);
        for (BDevice rdbmsDevice : this.rdbmsNetwork.getBDeviceList()) {
            databases.add((Object)((BRdbms)rdbmsDevice));
        }
        return (BRdbms[])databases.trim();
    }

    private static class DbEntry {
        private final BOrd dbOrd;
        private final String displayName;

        DbEntry(String displayName, BOrd dbOrd) {
            this.displayName = displayName;
            this.dbOrd = dbOrd;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

