/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dashboard.ui;

import com.tridium.dashboard.BDashboardService;
import com.tridium.json.JSONObject;
import com.tridium.ui.theme.LabelTheme;
import com.tridium.ui.theme.Theme;
import com.tridium.util.CompUtil;
import com.tridium.workbench.web.browser.BWebWidget;
import java.util.Iterator;
import java.util.Optional;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BIActiveOrdShell;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.naming.BWidgetScheme;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.util.WebProperty;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType
@NiagaraSlots(properties={@NiagaraProperty(name="id", type="baja:Format", defaultValue="BFormat.make(\"%ord%;%viewId%;%widgetOrd%;%jsOrd%\")"), @NiagaraProperty(name="content", type="baja:Widget", defaultValue="new BNullWidget()")})
public class BDashboardPane
extends BPane {
    public static final Property id = BDashboardPane.newProperty((int)0, (BValue)BFormat.make((String)"%ord%;%viewId%;%widgetOrd%;%jsOrd%"), null);
    public static final Property content = BDashboardPane.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Type TYPE = Sys.loadType(BDashboardPane.class);
    private volatile boolean errorStarting;
    private volatile boolean dashboardPropsSet;
    private volatile BAbsTime lastClear = BAbsTime.DEFAULT;
    private volatile Optional<BDashboardService> service = Optional.empty();
    private static final double indent = 5.0;
    private static final Lexicon lex = Lexicon.make(BDashboardPane.class);

    public BFormat getId() {
        return (BFormat)this.get(id);
    }

    public void setId(BFormat v) {
        this.set(id, (BValue)v, null);
    }

    public BWidget getContent() {
        return (BWidget)this.get(content);
    }

    public void setContent(BWidget v) {
        this.set(content, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void computePreferredSize() {
        BWidget w = this.getContent();
        w.computePreferredSize();
        this.setPreferredSize(w.getPreferredWidth(), w.getPreferredHeight());
    }

    public void doLayout(BWidget[] children) {
        this.getContent().setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    public void paint(Graphics g) {
        super.paint(g);
        String key = this.getMessageLexKey();
        if (!key.isEmpty()) {
            this.drawText(key, g);
        }
    }

    private void drawText(String key, Graphics g) {
        String txt = lex.get(key);
        double width = this.getWidth();
        double height = this.getHeight();
        LabelTheme theme = Theme.label();
        g.setBrush(theme.getTextBrush());
        BFont font = theme.getTextFont();
        g.setFont(font);
        double w = font.width(txt);
        double h = font.getDescent();
        double x = width > w + 10.0 ? (width - w) / 2.0 : 0.0;
        double y = height > h ? height / 2.0 + h : font.getHeight();
        g.drawString(txt, x + 5.0, y);
    }

    public final boolean isChildLegal(BComponent child) {
        return !(child instanceof BWidget) || child instanceof BNullWidget || child instanceof BWebWidget;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 11) {
            if (!this.isDesignTime()) {
                this.getWebWidget().ifPresent(ww -> this.init());
            }
        } else if (x == 308) {
            return this.service.map(srv -> BBoolean.make((!srv.getLastClear().equals((Object)this.lastClear) ? 1 : 0) != 0)).orElse(BBoolean.FALSE);
        }
        return super.fw(x, a, b, c, d);
    }

    protected final void init() {
        this.getWebWidget().ifPresent(ww -> {
            ww.setOnLoaded(this::onLoaded);
            this.dashboardPropsSet = this.syncProperties();
        });
    }

    public final boolean syncProperties() {
        Optional<BWebWidget> wwOpt = this.getWebWidget();
        if (!wwOpt.isPresent()) {
            return false;
        }
        BWebWidget ww = wwOpt.get();
        Optional<BIActiveOrdShell> shell = BDashboardPane.findActiveOrdShell((BComplex)this);
        if (shell.isPresent()) {
            OrdTarget target = shell.get().getActiveOrdTarget();
            try {
                this.service = Optional.of((BDashboardService)BOrd.make((String)"service:dashboard:DashboardService").get(target.get()));
                this.service.get().lease();
                if (!this.service.get().isOperational()) {
                    throw new Exception("Not operational!");
                }
                this.lastClear = this.service.get().getLastClear();
            }
            catch (Exception err) {
                ww.setVisible(false);
                this.errorStarting = true;
                this.relayout();
                return false;
            }
            CompUtil.setOrAdd((BComponent)ww, (String)"dashboard", (BValue)BBoolean.TRUE, (int)0x40000007, (BFacets)BFacets.DEFAULT, null);
            String contents = this.service.get().invoke(BDashboardService.readDashboard, (BValue)BString.make((String)this.getDashboardId(shell.get())), (Context)target).toString();
            if (!contents.isEmpty()) {
                JSONObject obj = new JSONObject(contents);
                boolean dashboardPropSet = false;
                Iterator it = obj.keys();
                while (it.hasNext()) {
                    String value;
                    Object o = it.next();
                    String name = o.toString();
                    if (WebProperty.setProperty((BWidget)ww, (String)name, (String)(value = obj.get(name).toString())) == null) continue;
                    dashboardPropSet = true;
                }
                return dashboardPropSet;
            }
        }
        return false;
    }

    private void onLoaded() {
        if (this.isDesignTime()) {
            return;
        }
        this.getWebWidget().ifPresent(ww -> BDashboardPane.findActiveOrdShell((BComplex)this).ifPresent(shell -> {
            String js = String.format("setTimeout(function () { require(['jquery', 'nmodule/dashboard/rc/dashboard'], function($, db) {db.initialize($('body > .bajaux-container > .bajaux-widget-container > .bajaux-widget:first'), '%s', %b);})}, 0);", this.getDashboardId((BIActiveOrdShell)shell), this.dashboardPropsSet);
            ww.executeScript(js);
        }));
    }

    public final String getDashboardId(BIActiveOrdShell shell) {
        OrdTarget target = shell.getActiveOrdTarget();
        BOrd ord = target.getOrdWithoutViewQuery().relativizeToSession();
        String viewId = shell.getActiveViewId();
        if ("hx:HxPxView".equals(viewId)) {
            viewId = "workbench:WbPxView";
        }
        BWebWidget widget = this.getWebWidget().get();
        BOrd widgetOrd = BWidgetScheme.makeWidgetOrd((BWidget)widget);
        return this.getId().format((Object)new IdFormat(ord, viewId, widgetOrd, widget.getJs()));
    }

    public static Optional<BIActiveOrdShell> findActiveOrdShell(BComplex c) {
        BWbShell shell;
        if (c == null) {
            return Optional.empty();
        }
        if (c instanceof BIActiveOrdShell) {
            BIActiveOrdShell activeShell = (BIActiveOrdShell)c;
            return activeShell.getActiveOrdTarget() == null ? Optional.empty() : Optional.of(activeShell);
        }
        if (c instanceof BWidget && (shell = BWbShell.getWbShell((BWidget)((BWidget)c))) != null) {
            return shell.getActiveOrdTarget() == null ? Optional.empty() : Optional.of(shell);
        }
        return BDashboardPane.findActiveOrdShell(c.getParent());
    }

    public final String getMessageLexKey() {
        if (this.errorStarting) {
            return "dashboardPane.errorStarting";
        }
        if (!this.getWebWidget().isPresent()) {
            return "dashboardPane.addToContent";
        }
        return "";
    }

    protected Optional<BWebWidget> getWebWidget() {
        BWidget w = this.getContent();
        return w instanceof BWebWidget ? Optional.of((BWebWidget)w) : Optional.empty();
    }

    public static final class IdFormat {
        private String ord;
        private String viewId;
        private String widgetOrd;
        private String jsOrd;

        private IdFormat(BOrd ord, String viewId, BOrd widgetOrd, BOrd jsOrd) {
            this.ord = SlotPath.escape((String)ord.toString());
            this.viewId = viewId != null ? SlotPath.escape((String)viewId) : "";
            this.widgetOrd = SlotPath.escape((String)widgetOrd.toString());
            this.jsOrd = SlotPath.escape((String)jsOrd.toString());
        }

        public String getOrd() {
            return this.ord;
        }

        public String getViewId() {
            return this.viewId;
        }

        public String getWidgetOrd() {
            return this.widgetOrd;
        }

        public String getJsOrd() {
            return this.jsOrd;
        }
    }
}

