/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.version3;

import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.comm.SnmpListener;
import com.tridium.nSnmp.version3.dispatcher.BSnmpDispatcher;
import com.tridium.nSnmp.version3.dto.SnmpV3Message;
import com.tridium.nSnmp.version3.messageProcessingModel.BSnmpMessageProcessingModel;
import com.tridium.nSnmp.version3.messageProcessingModel.BSnmpMessageProcessingModelFactory;
import java.util.HashMap;
import java.util.Map;

public class BSnmpV3Communicator {
    private BSnmpNetwork snmpNetwork;
    private static Map<BSnmpNetwork, BSnmpV3Communicator> mapBSnmpV3Communicator = new HashMap<BSnmpNetwork, BSnmpV3Communicator>();

    private BSnmpV3Communicator(BSnmpNetwork snmpNet) {
        this.snmpNetwork = snmpNet;
    }

    public static BSnmpV3Communicator getBSnmpV3CommunicatorInstance(BSnmpNetwork snmpNetwork) {
        BSnmpV3Communicator communicator = mapBSnmpV3Communicator.get(snmpNetwork);
        if (communicator == null) {
            communicator = new BSnmpV3Communicator(snmpNetwork);
            mapBSnmpV3Communicator.put(snmpNetwork, communicator);
        }
        return communicator;
    }

    public SnmpV3Message sendMessage(SnmpV3Message msg) throws Exception {
        SnmpV3Message responseMessage = null;
        BSnmpMessageProcessingModel messageProcessingModel = BSnmpMessageProcessingModelFactory.getBSnmpMessageProcessingModelInstance(3);
        BSnmpDispatcher dispatcher = BSnmpDispatcher.getBSnmpDispatcherInstance(messageProcessingModel, this.snmpNetwork);
        responseMessage = dispatcher.sendPDU(msg);
        return responseMessage;
    }

    public void sendResponseMessage(SnmpV3Message msg, SnmpListener listener) {
        BSnmpMessageProcessingModel messageProcessingModel = BSnmpMessageProcessingModelFactory.getBSnmpMessageProcessingModelInstance(3);
        BSnmpDispatcher dispatcher = BSnmpDispatcher.getBSnmpDispatcherInstance(messageProcessingModel, this.snmpNetwork);
        dispatcher.listenAndRespondSNMPMessage(msg, listener);
    }
}

