/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.util;

import com.tridium.nSnmp.BSnmpDevice;
import com.tridium.nSnmp.datatypes.BMibListEntry;
import com.tridium.nSnmp.datatypes.BMibListTable;
import com.tridium.nSnmp.enums.BSnmpMibEntryTypeEnum;
import com.tridium.nSnmp.enums.BSnmpVariableTypeEnum;
import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.point.BSnmpPointDeviceExt;
import com.tridium.nSnmp.snmptypes.SnmpString;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.snmptypes.SnmpVarBind;
import com.tridium.nSnmp.table.BSnmpTable;
import com.tridium.nSnmp.util.DisplayHintParser;
import com.tridium.nSnmp.util.SnmpUtil;
import java.util.Vector;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.sys.BIcon;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSnmpWalkMibJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BSnmpWalkMibJob.class);
    BSnmpDevice device;
    BMibListTable mibTable;
    public static BIcon icon = BIcon.std((String)"find.png");
    BSnmpPointDeviceExt deviceExt;
    boolean walkCanceled = false;

    public Type getType() {
        return TYPE;
    }

    public BSnmpWalkMibJob() {
    }

    public BSnmpWalkMibJob(BSnmpDevice device, BMibListTable mibList) {
        this.device = device;
        this.mibTable = mibList;
    }

    public void doCancel(Context cx) {
        this.walkCanceled = true;
        super.doCancel(cx);
    }

    private void createNodesFromReceivedPdu(String colOid, String oid, BMibListEntry[] createList, int i, int count, SnmpVarBind varBind) throws Exception {
        String nodeName;
        int lastDecimal = oid.lastIndexOf(46);
        if (lastDecimal >= 0 && lastDecimal + 1 < oid.length()) {
            String rowId = oid.substring(colOid.length() + 1);
            nodeName = createList[i].getEntryName() + "_" + rowId;
        } else {
            nodeName = createList[i].getEntryName() + "_" + count;
        }
        BMibListEntry newChild = new BMibListEntry(nodeName, oid, createList[i].getObjectSyntax(), createList[i].getDisplayHint(), createList[i].getVariableType(), createList[i].getAccess(), createList[i].getStatus(), createList[i].getDesc(), BSnmpMibEntryTypeEnum.sequenceValue);
        SnmpVar varTemp = varBind.getVariable();
        String value = this.applyDisplayHint(createList[i].getDisplayHint(), createList[i].getVariableType(), varTemp);
        newChild.setValue(value);
        newChild.setEnumRange(createList[i].getEnumRange());
        createList[i].addChild(newChild);
    }

    protected void sendBulkRequestForMibWalk(String currentOid, SnmpPDU snmpmsg, SnmpPDU pdu, String colOid, BMibListEntry[] createList, int i, int count) throws Exception {
        block0: while (true) {
            BSnmpTable snmpTable = new BSnmpTable();
            long[] testOid = SnmpUtil.getLongArray(currentOid);
            SnmpVarBind[] var = snmpTable.newSnmpVarBind(testOid);
            snmpmsg = snmpTable.getNewSnmpPdumsg(this.device);
            snmpmsg.addVariableBinding(var[0]);
            snmpmsg.setMaxRepetitions(this.device.getMaxVariableBindingsPerRequest());
            snmpmsg.setResponseTimeOut(this.device.getResponseTimeout().getSeconds() * 1000);
            snmpmsg.setRetryCount(this.device.getRetryCount());
            pdu = snmpTable.getSnmpPdu(this.device, snmpmsg);
            if (pdu == null) {
                return;
            }
            Vector<SnmpVarBind> vars = pdu.getVariableBindings();
            if (vars == null || vars.size() <= 0) {
                return;
            }
            int size_of_vars = 0;
            while (true) {
                if (size_of_vars >= vars.size()) continue block0;
                SnmpVarBind varBind = vars.elementAt(size_of_vars);
                String oid = varBind.getObjectID().toString();
                if (!oid.startsWith(colOid) || oid.equals(colOid) || oid.equals(currentOid)) {
                    return;
                }
                this.createNodesFromReceivedPdu(colOid, oid, createList, i, count, varBind);
                currentOid = oid;
                ++size_of_vars;
            }
            break;
        }
    }

    public void run(Context cx) throws Exception {
        this.progress(0);
        this.log().start("Walking MIB...");
        BMibListEntry[] createList = this.mibTable.getPointListCopy();
        int total = createList.length;
        if (total <= 0) {
            total = 1;
        }
        int iteration = 0;
        SnmpPDU snmpmsg = null;
        SnmpPDU pdu = null;
        for (int i = 0; i < createList.length; ++i) {
            Vector<SnmpVarBind> vars;
            String displayHint = createList[i].getDisplayHint();
            BSnmpVariableTypeEnum variabletype = createList[i].getVariableType();
            if (this.walkCanceled) break;
            this.progress((int)((float)iteration / (float)total * 100.0f));
            ++iteration;
            BSnmpMibEntryTypeEnum entryType = createList[i].getElementType();
            if (entryType.equals((Object)BSnmpMibEntryTypeEnum.sequenceElement)) {
                String colOid;
                boolean keepLooking = true;
                String currentOid = colOid = createList[i].getOid();
                this.log().message("Reading table values for " + createList[i].getEntryName() + " (" + currentOid + ")...");
                createList[i].clearChildren();
                int count = 1;
                if (this.device.getSnmpVersion() > 1) {
                    this.sendBulkRequestForMibWalk(currentOid, snmpmsg, pdu, colOid, createList, i, count);
                    continue;
                }
                while (keepLooking && !this.walkCanceled) {
                    pdu = this.device.updateGetNext(currentOid);
                    if (pdu == null) {
                        keepLooking = false;
                        continue;
                    }
                    Vector<SnmpVarBind> vars2 = pdu.getVariableBindings();
                    if (vars2 == null || vars2.size() <= 0) {
                        keepLooking = false;
                        continue;
                    }
                    SnmpVarBind varBind = vars2.elementAt(0);
                    String oid = varBind.getObjectID().toString();
                    if (oid.startsWith(colOid) && !oid.equals(colOid) && !oid.equals(currentOid)) {
                        this.createNodesFromReceivedPdu(colOid, oid, createList, i, count, varBind);
                        currentOid = oid;
                    } else {
                        keepLooking = false;
                    }
                    ++count;
                }
                continue;
            }
            if (!entryType.isAccessibleValue()) continue;
            String currentOid = createList[i].getOid();
            this.log().message("Reading present value for " + createList[i].getEntryName() + " (" + currentOid + ")...");
            long start = Clock.nanoTicks();
            pdu = this.device.updateGet(currentOid);
            if (pdu == null || (vars = pdu.getVariableBindings()) == null || vars.size() <= 0) continue;
            SnmpVarBind varBind = vars.elementAt(0);
            SnmpVar var = varBind.getVariable();
            String value = this.applyDisplayHint(displayHint, variabletype, var);
            createList[i].setValue(value);
        }
        if (this.walkCanceled) {
            throw new JobCancelException();
        }
        this.log().success("MIB Walk Complete");
        this.device.getPoints().fireMibWalkedEvent(new BMibListTable(createList));
    }

    private String applyDisplayHint(String displayHint, BSnmpVariableTypeEnum variabletype, SnmpVar var) throws Exception {
        String value = var.toStringValue();
        if (value.equals("") || value == null) {
            return value;
        }
        if (displayHint == null || displayHint.equals("")) {
            return value;
        }
        if (variabletype == BSnmpVariableTypeEnum.integerType || variabletype == BSnmpVariableTypeEnum.counter || variabletype == BSnmpVariableTypeEnum.gauge || variabletype == BSnmpVariableTypeEnum.timeticks) {
            value = DisplayHintParser.numericDisplay(value, displayHint);
        } else if (variabletype == BSnmpVariableTypeEnum.stringType && var instanceof SnmpString) {
            value = DisplayHintParser.stringDisplay(((SnmpString)var).getRawData(), displayHint);
        }
        return value;
    }

    public BIcon getIcon() {
        return icon;
    }
}

