/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.snmptypes;

import com.tridium.nSnmp.snmptypes.ASNOutput;
import com.tridium.nSnmp.snmptypes.SnmpConst;
import com.tridium.nSnmp.snmptypes.SnmpVar;

public class SnmpString
extends SnmpVar
implements SnmpConst {
    private byte[] a;

    public SnmpString(byte[] a) {
        this.type = 4;
        this.a = a;
    }

    public SnmpString(String val) {
        this.type = 4;
        this.a = val.getBytes();
    }

    @Override
    public String toTagString() {
        return "STRING: " + new String(this.a);
    }

    @Override
    public void encode(ASNOutput out) {
        out.addOctetString(this.a);
    }

    public String toValue() {
        return new String(this.a);
    }

    public String toString() {
        return new String(this.a);
    }

    @Override
    public String toStringValue() {
        return new String(this.a);
    }

    public String toNumericStringValue() {
        StringBuffer sb = new StringBuffer();
        boolean foundDigit = false;
        for (int i = 0; i < this.a.length; ++i) {
            if (Character.isDigit((char)this.a[i])) {
                sb.append((char)this.a[i]);
                foundDigit = true;
                continue;
            }
            if (this.a[i] == 46 && foundDigit) {
                sb.append((char)this.a[i]);
                continue;
            }
            if (this.a[i] == 45 && i + 1 < this.a.length && Character.isDigit((char)this.a[i + 1])) {
                sb.append((char)this.a[i]);
                continue;
            }
            if ((this.a[i] == 101 || this.a[i] == 69) && foundDigit && (i + 1 < this.a.length && Character.isDigit((char)this.a[i + 1]) || i + 2 < this.a.length && this.a[i + 1] == 45 && Character.isDigit((char)this.a[i + 2]))) {
                sb.append((char)this.a[i]);
                continue;
            }
            if (foundDigit) break;
        }
        return sb.toString();
    }

    public byte[] getRawData() {
        return this.a;
    }
}

