/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.snmptypes;

import com.tridium.nSnmp.snmptypes.ASNOutput;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.util.SnmpUtil;
import java.net.InetAddress;

public class SnmpIpAddress
extends SnmpVar {
    private byte[] a;
    private boolean valid = true;

    public SnmpIpAddress(byte[] a) {
        this.a = a;
        this.valid = true;
        this.type = 64;
    }

    public SnmpIpAddress(String IpAddr) {
        try {
            InetAddress temp = InetAddress.getByName(IpAddr);
            this.a = temp.getAddress();
        }
        catch (Exception e) {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void encode(ASNOutput out) {
        out.addIpAddress(this.a);
    }

    @Override
    public String toTagString() {
        return "IP ADDRESS: " + SnmpUtil.byteArrayToString(this.a);
    }

    public String getIPString() {
        return SnmpUtil.byteArrayToString(this.a);
    }

    @Override
    public String toStringValue() {
        return this.getIPString();
    }
}

