/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.object;

import com.tridium.driver.util.DrByteArrayUtil;
import com.tridium.nSnmp.enums.BSnmpVariableTypeEnum;
import com.tridium.nSnmp.object.BSnmpObjectExt;
import com.tridium.nSnmp.snmptypes.SnmpString;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.util.SnmpUtil;
import javax.baja.control.BStringPoint;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSnmpStringObjectExt
extends BSnmpObjectExt {
    public static final Property variableType = BSnmpStringObjectExt.newProperty((int)0, (BValue)BSnmpVariableTypeEnum.stringType, null);
    public static final Type TYPE = Sys.loadType(BSnmpStringObjectExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public SnmpVar getValue() {
        BStringPoint pnt = (BStringPoint)this.getParentPoint();
        String sVal = pnt.getOutStatusString().getValue();
        if (this.isRaw() && this.getVariableType().equals((Object)BSnmpVariableTypeEnum.stringType)) {
            return new SnmpString(DrByteArrayUtil.getBytes((String)sVal));
        }
        return SnmpUtil.getSnmpVar(sVal, this.getVariableType());
    }

    @Override
    public void tryDecodeForSet(SnmpVar var) throws Exception {
        SnmpUtil.getString(var);
    }

    @Override
    public SnmpVar setValue(SnmpVar value) {
        try {
            String sVal = SnmpUtil.getString(value);
            if (this.isRaw() && value instanceof SnmpString) {
                sVal = DrByteArrayUtil.toString((byte[])((SnmpString)value).getRawData());
            }
            this.readOk((BStatusValue)new BStatusString(sVal));
            return SnmpUtil.getSnmpVar(sVal, this.getVariableType());
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
            return null;
        }
    }

    private boolean isRaw() {
        return this.getDeviceFacets().getb("raw", false);
    }
}

