/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.mib.table;

import com.tridium.nSnmp.mib.table.SmiTable;
import com.tridium.nSnmp.mib.table.TableEntry;
import java.util.Vector;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;

public class PointTable
extends SmiTable {
    private boolean started = false;
    private Vector<TableEntry> store = null;
    TableEntry[] aEntries = null;
    protected IntHashMap hash = new IntHashMap(50);
    boolean hashMod = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        PointTable pointTable = this;
        synchronized (pointTable) {
            this.started = true;
            if (this.store != null) {
                for (int i = 0; i < this.store.size(); ++i) {
                    this.registerIoObject(this.store.elementAt(i));
                }
            }
            this.store = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIoObject(TableEntry ioObj) {
        int index = ioObj.getIndex();
        if (index == 0) {
            PointTable pointTable = this;
            synchronized (pointTable) {
                if (!this.started) {
                    if (this.store == null) {
                        this.store = new Vector();
                    }
                    this.store.addElement(ioObj);
                    return;
                }
                this.claimNextIndex(ioObj);
            }
        }
        this.hashDevice(ioObj);
    }

    public void unregisterIoObject(TableEntry ioObj) {
        this.unhashDevice(ioObj);
    }

    private synchronized void claimNextIndex(TableEntry ioObj) {
        int index = 1;
        this.unregisterIoObject(ioObj);
        while (this.hash.get(index) != null) {
            if (++index != 0) continue;
            return;
        }
        ioObj.setIndex(index);
    }

    @Override
    public synchronized TableEntry[] getArray() {
        if (this.aEntries == null || this.hash.size() != this.aEntries.length) {
            this.aEntries = new TableEntry[this.hash.size()];
        }
        if (this.hashMod) {
            this.hash.toArray((Object[])this.aEntries);
            this.hashMod = false;
        }
        return this.aEntries;
    }

    public synchronized int getNextIndex(int offset) {
        int index = offset + 1;
        while (this.hash.get(index) != null) {
            if (++index != 0) continue;
            return 0;
        }
        return index;
    }

    private synchronized void hashDevice(TableEntry ioObj) {
        int index = ioObj.getIndex();
        TableEntry origObj = (TableEntry)this.hash.get(index);
        if (origObj == null) {
            this.hash.put(index, (Object)ioObj);
            this.hashMod = true;
            ioObj.setLastHash(index);
        } else if (!origObj.equals(ioObj)) {
            String msg = "Duplicate index detected in SmiTable for " + origObj.getPointName() + " & " + ioObj.getPointName() + ".  Will use next available index for " + ioObj.getPointName();
            System.out.println(msg);
            ioObj.setIndex(0);
            this.registerIoObject(ioObj);
        }
    }

    private synchronized void unhashDevice(TableEntry ioObj) {
        int index = ioObj.getLastHash();
        TableEntry he = (TableEntry)this.hash.get(index);
        if (he == null || !he.equals(ioObj)) {
            return;
        }
        this.hash.remove(index);
        this.hashMod = true;
        ioObj.setLastHash(-1);
    }

    @Override
    public TableEntry getNextEntry(int index) {
        int i;
        TableEntry[] a = this.getArray();
        if (a.length == 0) {
            return null;
        }
        if (index == 0) {
            return a[0];
        }
        for (i = 0; i < a.length && a[i].getIndex() != index; ++i) {
        }
        if (++i >= a.length) {
            return null;
        }
        return a[i];
    }

    public TableEntry getObject(int index) {
        return (TableEntry)this.hash.get(index);
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        TableEntry[] entries = this.getArray();
        if (entries != null && entries.length > 0) {
            out.startTable(true);
            out.w((Object)"<tr>").th((Object)(entries.length + " Entries as of " + BAbsTime.now())).w((Object)"</tr>\n");
            for (int i = 0; i < entries.length; ++i) {
                out.tr((Object)entries[i].toString());
            }
            out.endTable();
        }
    }
}

