/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.messages;

import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.messages.AlarmTrap;
import com.tridium.nSnmp.mib.table.AlarmEntry;
import com.tridium.nSnmp.services.BSnmpRecipient;
import com.tridium.nSnmp.snmptypes.ASNOutput;
import com.tridium.nSnmp.version3.securityModel.usm.BUsmSecurity;
import com.tridium.nSnmp.version3.securityModel.usm.authentication.BUsmAuthenticationProtocol;
import com.tridium.nSnmp.version3.securityModel.usm.privacy.UsmPrivacyProtocol;
import com.tridium.nSnmp.version3.securityModel.usmUser.BUsmUser;
import com.tridium.nSnmp.version3.securityModel.usmUser.BUsmUserTable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.AccessController;
import java.util.Enumeration;
import javax.baja.security.BPassword;
import javax.baja.sys.BFrozenEnum;

public class SnmpV3AlarmTrap
extends AlarmTrap {
    private int msgID;
    private int msgMaxSize;
    private byte msgFlags;
    private int msgSecurityModel;
    private byte[] msgAuthoritativeEngineID;
    private int msgAuthoritativeEngineBoots;
    private int msgAuthoritativeEngineTime;
    private String userName;
    private byte[] msgAuthenticationParameters;
    private byte[] msgPrivacyParameter;
    private byte[] contextId;
    private String contextName;
    private int securityLevel;
    private boolean allowReplay;
    byte[] encryptedPdu;
    boolean generateRequestMsgAlreadyCalled = false;
    private String authProtocol;
    private String authKey;
    private String privacyProtocol;
    private String privacykey;

    public SnmpV3AlarmTrap(BSnmpNetwork snmp, AlarmEntry entry) {
        super(snmp, entry);
        BUsmUser bUsmUser = BUsmUserTable.getUserforTrap(this.getDestinationIp().getHostAddress());
        this.userName = bUsmUser.getName();
        this.contextName = bUsmUser.getContextName();
        this.authProtocol = this.getStringValueFromFrozenEnum(bUsmUser.getAuthenticationProtocol());
        this.authKey = AccessController.doPrivileged(() -> ((BPassword)bUsmUser.getAuthenticationPassphrase()).getValue());
        this.privacyProtocol = this.getStringValueFromFrozenEnum(bUsmUser.getPrivacyProtocol());
        this.privacykey = AccessController.doPrivileged(() -> ((BPassword)bUsmUser.getPrivacyPassphrase()).getValue());
        this.securityLevel = this.getCorrectSecurityLevel(bUsmUser.getSecurityLevel().getOrdinal());
        this.msgSecurityModel = 3;
    }

    private String getStringValueFromFrozenEnum(BFrozenEnum enumVal) {
        BFrozenEnum val;
        String stringVal = "";
        if (enumVal instanceof BUsmAuthenticationProtocol && (val = (BUsmAuthenticationProtocol)enumVal) == BUsmAuthenticationProtocol.sha) {
            return "SHA";
        }
        if (enumVal instanceof UsmPrivacyProtocol) {
            val = (UsmPrivacyProtocol)enumVal;
            if (val == UsmPrivacyProtocol.des) {
                return "DES";
            }
            if (val == UsmPrivacyProtocol.aes128) {
                return "AES128";
            }
            if (val == UsmPrivacyProtocol.aes192) {
                return "AES192";
            }
            if (val == UsmPrivacyProtocol.aes256) {
                return "AES256";
            }
        }
        return stringVal;
    }

    public SnmpV3AlarmTrap(BSnmpRecipient recipient, AlarmEntry entry) {
        super(recipient, entry);
        BUsmUser bUsmUser = BUsmUserTable.getUserforTrap(this.getDestinationIp().getHostAddress());
        this.userName = bUsmUser.getName();
        this.contextName = bUsmUser.getContextName();
        this.securityLevel = this.getCorrectSecurityLevel(bUsmUser.getSecurityLevel().getOrdinal());
        this.msgSecurityModel = 3;
    }

    private int getCorrectSecurityLevel(int securityLevel) {
        switch (securityLevel) {
            case 301: {
                return 0;
            }
            case 302: {
                return 1;
            }
            case 304: {
                return 3;
            }
        }
        return 0;
    }

    public static void sendAlarmTrap(BSnmpNetwork snmp, AlarmEntry entry) {
        SnmpV3AlarmTrap trap = new SnmpV3AlarmTrap(snmp, entry);
        trap.send();
    }

    public static void sendAlarmTrap(BSnmpRecipient recipient, AlarmEntry entry) {
        SnmpV3AlarmTrap trap = new SnmpV3AlarmTrap(recipient, entry);
        trap.send();
    }

    @Override
    public byte[] encodeData() {
        ASNOutput out = new ASNOutput();
        out.addInt(3);
        int v3specificDataPos = out.getPosition();
        this.populateV3Data();
        if (this.securityLevel >= 1 && !this.generateRequestMsgAlreadyCalled) {
            this.generateRequestMsgAlreadyCalled = true;
            BUsmSecurity.getUsmSecurityInstance().generateTrapMsg(this);
        }
        out.addInt(this.msgID);
        out.addInt(this.msgMaxSize);
        out.addOctetString(new byte[]{(byte)this.securityLevel});
        out.addInt(this.msgSecurityModel);
        out.insertTag(48, v3specificDataPos);
        int octetStringTagPosForSecurity = out.getPosition();
        int sequenceTagPosForSecurity = out.getPosition();
        out.addOctetString(this.msgAuthoritativeEngineID != null ? this.msgAuthoritativeEngineID : null);
        out.addInt(this.msgAuthoritativeEngineBoots);
        out.addInt(this.msgAuthoritativeEngineTime);
        out.addOctetString(this.userName.getBytes());
        out.addOctetString(this.msgAuthenticationParameters != null ? this.msgAuthenticationParameters : "".getBytes());
        out.addOctetString(this.msgPrivacyParameter != null ? this.msgPrivacyParameter : "".getBytes());
        out.insertTag(48, sequenceTagPosForSecurity);
        out.insertTag(4, octetStringTagPosForSecurity);
        if ((this.securityLevel & 3) == 3) {
            out.addOctetString(this.encryptedPdu);
            out.insertTag(48, 0);
            return out.getBytes();
        }
        int scopedPduSquencePos = out.getPosition();
        out.addOctetString(this.contextId);
        out.addOctetString(this.contextName.getBytes());
        int pduSquencePos = out.getPosition();
        this.insertCommandBasedData(out);
        out.insertTag(167, pduSquencePos);
        out.insertTag(48, scopedPduSquencePos);
        out.insertTag(48, 0);
        return out.getBytes();
    }

    private void populateV3Data() {
        this.msgMaxSize = 328987;
        this.msgSecurityModel = 3;
        this.msgAuthoritativeEngineID = this.msgAuthoritativeEngineID == null ? this.createLocalEngineID() : this.msgAuthoritativeEngineID;
        this.contextId = this.contextId != null ? this.contextId : this.msgAuthoritativeEngineID;
    }

    public byte[] createLocalEngineID() {
        byte[] engineID = new byte[12];
        int enterpriseID = 4131;
        engineID[0] = (byte)(0x80 | enterpriseID >> 24 & 0xFF);
        engineID[1] = (byte)(enterpriseID >> 16 & 0xFF);
        engineID[2] = (byte)(enterpriseID >> 8 & 0xFF);
        engineID[3] = (byte)(enterpriseID & 0xFF);
        engineID[4] = -128;
        byte[] address = null;
        address = this.getCurrentIp().getAddress();
        int j = 0;
        for (int i = 5; i < 12 && j < 4; ++i, ++j) {
            engineID[i] = address[j];
        }
        return engineID;
    }

    private InetAddress getCurrentIp() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                Enumeration<InetAddress> nias = ni.getInetAddresses();
                while (nias.hasMoreElements()) {
                    InetAddress ia = nias.nextElement();
                    if (ia.isLinkLocalAddress() || ia.isLoopbackAddress() || !(ia instanceof Inet4Address)) continue;
                    return ia;
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException("unable to get current IP " + e.getMessage());
        }
        return null;
    }

    public String getUserSecurityName() {
        return this.userName;
    }

    public void setUserSecurityName(String userName) {
        this.userName = userName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = securityLevel;
    }

    public int getMsgSecurityModel() {
        return this.msgSecurityModel;
    }

    public void setMsgSecurityModel(int msgSecurityModel) {
        this.msgSecurityModel = msgSecurityModel;
    }

    public int getMsgID() {
        return this.msgID;
    }

    public void setMsgID(int msgID) {
        this.msgID = msgID;
    }

    public int getMsgMaxSize() {
        return this.msgMaxSize;
    }

    public void setMsgMaxSize(int msgMaxSize) {
        this.msgMaxSize = msgMaxSize;
    }

    public byte getMsgFlags() {
        return this.msgFlags;
    }

    public void setMsgFlags(byte msgFlags) {
        this.msgFlags = msgFlags;
    }

    public byte[] getMsgAuthoritativeEngineID() {
        return this.msgAuthoritativeEngineID;
    }

    public void setMsgAuthoritativeEngineID(byte[] msgAuthoritativeEngineID) {
        this.msgAuthoritativeEngineID = msgAuthoritativeEngineID;
    }

    public int getMsgAuthoritativeEngineBoots() {
        return this.msgAuthoritativeEngineBoots;
    }

    public void setMsgAuthoritativeEngineBoots(int msgAuthoritativeEngineBoots) {
        this.msgAuthoritativeEngineBoots = msgAuthoritativeEngineBoots;
    }

    public int getMsgAuthoritativeEngineTime() {
        return this.msgAuthoritativeEngineTime;
    }

    public void setMsgAuthoritativeEngineTime(int msgAuthoritativeEngineTime) {
        this.msgAuthoritativeEngineTime = msgAuthoritativeEngineTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public byte[] getMsgAuthenticationParameters() {
        return this.msgAuthenticationParameters;
    }

    public void setMsgAuthenticationParameters(byte[] msgAuthenticationParameters) {
        this.msgAuthenticationParameters = msgAuthenticationParameters;
    }

    public byte[] getMsgPrivacyParameter() {
        return this.msgPrivacyParameter;
    }

    public void setMsgPrivacyParameter(byte[] msgPrivacyParameter) {
        this.msgPrivacyParameter = msgPrivacyParameter;
    }

    public byte[] getContextId() {
        return this.contextId;
    }

    public void setContextId(byte[] contextId) {
        this.contextId = contextId;
    }

    public boolean isAllowReplay() {
        return this.allowReplay;
    }

    public void setAllowReplay(boolean allowReplay) {
        this.allowReplay = allowReplay;
    }

    public String getAuthProtocol() {
        return this.authProtocol;
    }

    public void setAuthProtocol(String authProtocol) {
        this.authProtocol = authProtocol;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public void setAuthKey(String authKey) {
        this.authKey = authKey;
    }

    public String getPrivacyProtocol() {
        return this.privacyProtocol;
    }

    public void setPrivacyProtocol(String privacyProtocol) {
        this.privacyProtocol = privacyProtocol;
    }

    public String getPrivacykey() {
        return this.privacykey;
    }

    public void setPrivacykey(String privacykey) {
        this.privacykey = privacykey;
    }

    public byte[] getEncryptedPdu() {
        return this.encryptedPdu;
    }

    public void setEncryptedPdu(byte[] encryptedPdu) {
        this.encryptedPdu = encryptedPdu;
    }

    public static void sendColdStart(BSnmpNetwork snmp) {
        SnmpV3AlarmTrap trap = new SnmpV3AlarmTrap(snmp, null);
        trap.send();
    }

    public byte[] encodeScopedPduData() {
        ASNOutput out = new ASNOutput();
        int scopedPduSquencePos = out.getPosition();
        out.addOctetString(this.contextId);
        out.addOctetString(this.contextName.getBytes());
        int pduSquencePos = out.getPosition();
        this.insertCommandBasedData(out);
        out.insertTag(this.pduType, pduSquencePos);
        out.insertTag(48, scopedPduSquencePos);
        return out.getBytes();
    }
}

