/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.comm;

import com.tridium.nSnmp.BSnmpDevice;
import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.alarm.BTrapType;
import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.snmptypes.SnmpExceptionVar;
import com.tridium.nSnmp.snmptypes.SnmpInt;
import com.tridium.nSnmp.snmptypes.SnmpOID;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.snmptypes.SnmpVarBind;
import com.tridium.nSnmp.util.SnmpUtil;
import com.tridium.nSnmp.version3.BSnmpV3Communicator;
import com.tridium.nSnmp.version3.dto.SnmpV3Message;
import com.tridium.nSnmp.version3.vacm.BSnmpVACM;
import com.tridium.nSnmp.version3.vacm.VacmException;
import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NMessage;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;

public class SnmpListener
implements ICommListener {
    private BSnmpNetwork snmp;
    private NComm comm = null;
    private static final int NO_ACCESS = 0;
    private static final int READ_ONLY = 1;
    private static final int READ_WRITE = 2;

    public SnmpListener(BSnmpNetwork snmpNetwork) {
        this.snmp = snmpNetwork;
    }

    public void receiveMessage(NMessage nMsg) {
        SnmpPDU receivedData = (SnmpPDU)nMsg;
        SnmpPDU resp = null;
        if (receivedData != null) {
            int access = this.checkReceivedRequest(receivedData);
            if (access == 0) {
                // empty if block
            }
            if (receivedData.getVersion() != 3 || (receivedData.getCommand() & 0xFF) == 167) {
                resp = this.prepareResponse(receivedData, access);
            } else {
                BSnmpV3Communicator snmpCommunicator = BSnmpV3Communicator.getBSnmpV3CommunicatorInstance(this.snmp);
                snmpCommunicator.sendResponseMessage((SnmpV3Message)receivedData, this);
            }
            if (resp != null) {
                this.sendResponse(receivedData, resp);
            }
        }
    }

    private void fetchPduData(SnmpV3Message pdu, SnmpV3Message resp) {
        int msgID = pdu.getMsgID();
        int msgMaxSize = pdu.getMsgMaxSize();
        byte msgFlags = pdu.getMsgFlag();
        int msgSecurityModel = pdu.getMsgSecurityModel();
        byte[] msgAuthoritativeEngineID = pdu.getMsgAuthoritativeEngineID();
        int msgAuthoritativeEngineBoots = pdu.getMsgAuthoritativeEngineBoots();
        int msgAuthoritativeEngineTime = pdu.getMsgAuthoritativeEngineTime();
        String userName = pdu.getUserSecurityName();
        byte[] contextId = pdu.getContextId();
        String contextName = pdu.getContextName();
        resp.setMsgID(msgID);
        resp.setMsgMaxSize(msgMaxSize);
        resp.setMsgFlag(msgFlags);
        resp.setSecurityLevel(msgFlags & 3);
        resp.setMsgSecurityModel(msgSecurityModel);
        resp.setMsgAuthoritativeEngineID(msgAuthoritativeEngineID);
        resp.setMsgAuthoritativeEngineBoots(msgAuthoritativeEngineBoots);
        resp.setMsgAuthoritativeEngineTime(msgAuthoritativeEngineTime);
        resp.setUserSecurityName(userName);
        resp.setContextId(contextId);
        resp.setContextName(contextName);
    }

    public SnmpPDU prepareResponse(SnmpPDU receivedData, int access) {
        SnmpPDU resp = null;
        if (receivedData.isFull()) {
            resp = this.createSnmpResponseObject(receivedData);
            resp.setErrstat(1);
            resp.setErrindex(0);
        } else {
            try {
                int version = receivedData.getVersion();
                if (version == 3 && receivedData.getVariableBindings().size() == 0) {
                    SnmpV3Message received_v3_data = (SnmpV3Message)receivedData;
                    received_v3_data.setMsgID(((SnmpV3Message)receivedData).getMsgID());
                    received_v3_data.setMsgAuthoritativeEngineID(null);
                    received_v3_data.setMsgAuthoritativeEngineBoots(0);
                    received_v3_data.setMsgAuthoritativeEngineTime(0);
                    received_v3_data.setMsgAuthenticationParameters(null);
                    received_v3_data.setMsgPrivacyParameter(null);
                    received_v3_data.addVariableBinding(new SnmpVarBind(new SnmpOID("1.3.6.1.6.3.15.1.1.4.0"), new SnmpInt(7)));
                    return received_v3_data;
                }
                int command = receivedData.getCommand() & 0xFF;
                switch (command) {
                    case 160: {
                        resp = this.processGet(receivedData);
                        break;
                    }
                    case 161: {
                        resp = this.processGetNext(receivedData);
                        break;
                    }
                    case 165: {
                        resp = this.processBulkRequest(receivedData);
                        break;
                    }
                    case 163: {
                        if (access == 2) {
                            resp = this.processSet(receivedData);
                        }
                        break;
                    }
                    case 164: {
                        this.processTrap(receivedData, 0);
                        break;
                    }
                    case 167: {
                        this.processTrap(receivedData, receivedData.getVersion());
                        break;
                    }
                    default: {
                        this.snmp.getSnmpLog().info("Received Unprocessable SNMP request (Command: " + receivedData.getCommand() + ")");
                        break;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.snmp.getSnmpLog().severe("Exception processing pdu:" + e.getMessage());
            }
        }
        return resp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processTrap(SnmpPDU pdu, int version) {
        TrapData map = new TrapData();
        StringBuffer sb = new StringBuffer();
        SnmpVarBind[] vbs = pdu.getVaribleBindingArray();
        BSnmpDevice dev = null;
        if (version == 0) {
            dev = this.snmp.findDevice(pdu.getSourceIp());
            if (dev == null) return;
            BTrapType trap = dev.getTraps().getTrapTypeByGenericSpecific(pdu.getTrapEnterprise(), pdu.getGenericTrapAsInt(), pdu.getSpecificTrapAsInt());
            if (trap != null) {
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.trapData")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.recognizedV1") + " " + dev.getName() + "(" + pdu.getSourceIp() + ")")));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.name")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(trap.getTrapName())));
                sb.append(SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.recognizedV1") + " " + dev.getName() + "(" + pdu.getSourceIp() + "): ") + "\n");
                sb.append(this.localizeText("rcvTraps.strings.name") + "= " + SnmpListener.insertLineFeeds(trap.getTrapName()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.variables") + "= \n");
                String[] variables = trap.getVariables();
                for (int i = 0; i < vbs.length; ++i) {
                    this.snmp.getSnmpLog().info("trap var " + vbs[i].toString());
                    if (i > 0) {
                        sb.append(", \n");
                    }
                    SnmpOID oid = vbs[i].getObjectID();
                    SnmpVar var = vbs[i].getVariable();
                    if (i < variables.length) {
                        sb.append(variables[i]);
                        sb.append(SnmpListener.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                        map.put(SnmpListener.makeValidName(variables[i]), (BObject)BString.make((String)SnmpListener.insertLineFeeds(var.toStringValue())));
                        continue;
                    }
                    sb.append(this.localizeText("rcvTraps.strings.variables") + "_" + i);
                    sb.append(SnmpListener.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                    map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.variables") + "_" + i), (BObject)BString.make((String)SnmpListener.insertLineFeeds(var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")")));
                }
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.description")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(trap.getDescription())));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.reference")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(trap.getReference())));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.enterprise")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(pdu.getTrapEnterprise())));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.agentAddr")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(pdu.getAgentAddr())));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.generic")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(pdu.getGenericTrap())));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.specific")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(pdu.getSpecificTrap())));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.timestamp")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(pdu.getTrapTimeStamp())));
                sb.append("; \n" + this.localizeText("rcvTraps.strings.description") + "= " + SnmpListener.insertLineFeeds(trap.getDescription()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.reference") + "=" + SnmpListener.insertLineFeeds(trap.getReference()) + "; \n");
                sb.append("[" + this.localizeText("rcvTraps.strings.details") + "= \n");
                sb.append(this.localizeText("rcvTraps.strings.enterprise") + ": " + SnmpListener.insertLineFeeds(pdu.getTrapEnterprise()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.agentAddr") + ": " + SnmpListener.insertLineFeeds(pdu.getAgentAddr()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.generic") + ": " + SnmpListener.insertLineFeeds(pdu.getGenericTrap()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.specific") + ": " + SnmpListener.insertLineFeeds(pdu.getSpecificTrap()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.timestamp") + ": " + SnmpListener.insertLineFeeds(pdu.getTrapTimeStamp()) + "]");
            } else {
                if (dev.getTraps().getIgnoreUnrecognizedTraps()) {
                    return;
                }
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.trapData")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.unrecognizedV1") + " " + dev.getName() + "(" + pdu.getSourceIp() + ")")));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.enterprise")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(pdu.getTrapEnterprise())));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.agentAddr")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(pdu.getAgentAddr())));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.generic")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(pdu.getGenericTrap())));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.specific")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(pdu.getSpecificTrap())));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.timestamp")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(pdu.getTrapTimeStamp())));
                sb.append(SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.unrecognizedV1") + " " + dev.getName() + "(" + pdu.getSourceIp() + "): ") + "\n");
                sb.append(this.localizeText("rcvTraps.strings.details") + "= \n");
                sb.append(this.localizeText("rcvTraps.strings.enterprise") + ": " + SnmpListener.insertLineFeeds(pdu.getTrapEnterprise()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.agentAddr") + ": " + SnmpListener.insertLineFeeds(pdu.getAgentAddr()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.generic") + ": " + SnmpListener.insertLineFeeds(pdu.getGenericTrap()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.specific") + ": " + SnmpListener.insertLineFeeds(pdu.getSpecificTrap()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.timestamp") + ": " + SnmpListener.insertLineFeeds(pdu.getTrapTimeStamp()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.varbinds") + ": \n");
                for (int i = 0; i < vbs.length; ++i) {
                    this.snmp.getSnmpLog().info("trap var " + vbs[i].toString());
                    if (i > 0) {
                        sb.append(", \n");
                    }
                    SnmpOID oid = vbs[i].getObjectID();
                    SnmpVar var = vbs[i].getVariable();
                    sb.append(this.localizeText("rcvTraps.strings.varbinds") + "_" + i);
                    sb.append(SnmpListener.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                    map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.varbinds") + "_" + i), (BObject)BString.make((String)SnmpListener.insertLineFeeds(var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")")));
                }
            }
        } else if (version == 1) {
            int i;
            dev = this.snmp.findDevice(pdu.getSourceIp());
            if (dev == null) return;
            BTrapType trap = null;
            for (i = 0; i < vbs.length; ++i) {
                if (!vbs[i].getObjectID().equals(new SnmpOID("1.3.6.1.6.3.1.1.4.1.0")) || !(vbs[i].getVariable() instanceof SnmpOID)) continue;
                trap = dev.getTraps().getTrapTypeByOID((SnmpOID)vbs[i].getVariable());
            }
            if (trap != null) {
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.trapData")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.recognizedV2") + " " + dev.getName() + "(" + pdu.getSourceIp() + ")")));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.name")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(trap.getTrapName() + "(" + SnmpUtil.longArrayToString(trap.getOid()) + ")")));
                sb.append(SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.recognizedV2") + " " + dev.getName() + "(" + pdu.getSourceIp() + "): ") + "\n");
                sb.append(SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.name") + "= " + trap.getTrapName() + "(" + SnmpUtil.longArrayToString(trap.getOid()) + "); ") + "\n");
                sb.append(this.localizeText("rcvTraps.strings.objects") + "= \n");
                String[] variables = trap.getVariables();
                int count = 0;
                for (int i2 = 0; i2 < vbs.length; ++i2) {
                    SnmpVar var;
                    SnmpOID oid;
                    this.snmp.getSnmpLog().info("trap var " + vbs[i2].toString());
                    if (vbs[i2].getObjectID().equals(new SnmpOID("1.3.6.1.6.3.1.1.4.1.0")) && vbs[i2].getVariable() instanceof SnmpOID) continue;
                    if (i2 > 0) {
                        sb.append(", \n");
                    }
                    if (vbs[i2].getObjectID().equals(new SnmpOID("1.3.6.1.2.1.1.3.0"))) {
                        oid = vbs[i2].getObjectID();
                        var = vbs[i2].getVariable();
                        sb.append(SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.sysUpTime") + "= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                        map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.sysUpTime")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(var.toStringValue())));
                        ++count;
                        continue;
                    }
                    oid = vbs[i2].getObjectID();
                    var = vbs[i2].getVariable();
                    if (count < variables.length) {
                        sb.append(variables[count]);
                        sb.append(SnmpListener.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                        map.put(SnmpListener.makeValidName(variables[++count - 1]), (BObject)BString.make((String)SnmpListener.insertLineFeeds(var.toStringValue())));
                        continue;
                    }
                    sb.append(this.localizeText("rcvTraps.strings.objects") + "_" + i2);
                    sb.append(SnmpListener.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                    map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.objects") + "_" + i2), (BObject)BString.make((String)SnmpListener.insertLineFeeds(var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")")));
                }
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.description")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(trap.getDescription())));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.reference")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(trap.getReference())));
                sb.append("; \n" + this.localizeText("rcvTraps.strings.description") + "= " + SnmpListener.insertLineFeeds(trap.getDescription()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.reference") + "= " + SnmpListener.insertLineFeeds(trap.getReference()));
            } else {
                if (dev.getTraps().getIgnoreUnrecognizedTraps()) {
                    return;
                }
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.trapData")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.unrecognizedV2") + " " + dev.getName() + "(" + pdu.getSourceIp() + ")")));
                sb.append(SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.unrecognizedV2") + " " + dev.getName() + "(" + pdu.getSourceIp() + "): ") + "\n");
                sb.append(this.localizeText("rcvTraps.strings.objects") + "= \n");
                for (i = 0; i < vbs.length; ++i) {
                    this.snmp.getSnmpLog().info("trap var " + vbs[i].toString());
                    if (i > 0) {
                        sb.append(", \n");
                    }
                    SnmpOID oid = vbs[i].getObjectID();
                    SnmpVar var = vbs[i].getVariable();
                    sb.append(this.localizeText("rcvTraps.strings.objects") + "_" + i);
                    sb.append(SnmpListener.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                    map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.objects") + "_" + i), (BObject)BString.make((String)SnmpListener.insertLineFeeds(var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")")));
                }
            }
        } else {
            int i;
            dev = this.snmp.findDevice(pdu.getSourceIp());
            if (dev == null) return;
            BTrapType trap = null;
            for (i = 0; i < vbs.length; ++i) {
                if (!vbs[i].getObjectID().equals(new SnmpOID("1.3.6.1.6.3.1.1.4.1.0")) || !(vbs[i].getVariable() instanceof SnmpOID)) continue;
                trap = dev.getTraps().getTrapTypeByOID((SnmpOID)vbs[i].getVariable());
            }
            if (trap != null) {
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.trapData")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.recognizedV3") + " " + dev.getName() + "(" + pdu.getSourceIp() + ")")));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.name")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(trap.getTrapName() + "(" + SnmpUtil.longArrayToString(trap.getOid()) + ")")));
                sb.append(SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.recognizedV3") + " " + dev.getName() + "(" + pdu.getSourceIp() + "): ") + "\n");
                sb.append(SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.name") + "= " + trap.getTrapName() + "(" + SnmpUtil.longArrayToString(trap.getOid()) + "); ") + "\n");
                sb.append(this.localizeText("rcvTraps.strings.objects") + "= \n");
                String[] variables = trap.getVariables();
                int count = 0;
                for (int i3 = 0; i3 < vbs.length; ++i3) {
                    SnmpVar var;
                    SnmpOID oid;
                    this.snmp.getSnmpLog().info("trap var " + vbs[i3].toString());
                    if (vbs[i3].getObjectID().equals(new SnmpOID("1.3.6.1.6.3.1.1.4.1.0")) && vbs[i3].getVariable() instanceof SnmpOID) continue;
                    if (i3 > 0) {
                        sb.append(", \n");
                    }
                    if (vbs[i3].getObjectID().equals(new SnmpOID("1.3.6.1.2.1.1.3.0"))) {
                        oid = vbs[i3].getObjectID();
                        var = vbs[i3].getVariable();
                        sb.append(SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.sysUpTime") + "= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                        map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.sysUpTime")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(var.toStringValue())));
                        ++count;
                        continue;
                    }
                    oid = vbs[i3].getObjectID();
                    var = vbs[i3].getVariable();
                    if (count < variables.length) {
                        sb.append(variables[count]);
                        sb.append(SnmpListener.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                        map.put(SnmpListener.makeValidName(variables[++count - 1]), (BObject)BString.make((String)SnmpListener.insertLineFeeds(var.toStringValue())));
                        continue;
                    }
                    sb.append(this.localizeText("rcvTraps.strings.objects") + "_" + i3);
                    sb.append(SnmpListener.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                    map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.objects") + "_" + i3), (BObject)BString.make((String)SnmpListener.insertLineFeeds(var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")")));
                }
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.description")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(trap.getDescription())));
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.reference")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(trap.getReference())));
                sb.append("; \n" + this.localizeText("rcvTraps.strings.description") + "= " + SnmpListener.insertLineFeeds(trap.getDescription()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.reference") + "= " + SnmpListener.insertLineFeeds(trap.getReference()));
            } else {
                if (dev.getTraps().getIgnoreUnrecognizedTraps()) {
                    return;
                }
                map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.trapData")), (BObject)BString.make((String)SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.unrecognizedV3") + " " + dev.getName() + "(" + pdu.getSourceIp() + ")")));
                sb.append(SnmpListener.insertLineFeeds(this.localizeText("rcvTraps.strings.unrecognizedV3") + " " + dev.getName() + "(" + pdu.getSourceIp() + "): ") + "\n");
                sb.append(this.localizeText("rcvTraps.strings.objects") + "= \n");
                for (i = 0; i < vbs.length; ++i) {
                    this.snmp.getSnmpLog().info("trap var " + vbs[i].toString());
                    if (i > 0) {
                        sb.append(", \n");
                    }
                    SnmpOID oid = vbs[i].getObjectID();
                    SnmpVar var = vbs[i].getVariable();
                    sb.append(this.localizeText("rcvTraps.strings.objects") + "_" + i);
                    sb.append(SnmpListener.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                    map.put(SnmpListener.makeValidName(this.localizeText("rcvTraps.strings.objects") + "_" + i), (BObject)BString.make((String)SnmpListener.insertLineFeeds(var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")")));
                }
            }
        }
        dev.getTraps().issueTrapAlert(BFacets.make((String[])map.getKeys(), (BIDataValue[])map.getValues()), sb.toString());
    }

    private static String makeValidName(String name) {
        if (!SlotPath.isValidName((String)name)) {
            name = SlotPath.escape((String)name);
        }
        return name;
    }

    private String localizeText(String key) {
        return this.snmp.getLexicon().getText(key);
    }

    private void sendResponse(SnmpPDU pdu, SnmpPDU resp) {
        try {
            resp.setVersion(pdu.getVersion());
            resp.setReqid(pdu.getReqid());
            resp.setCommunity(pdu.getCommunity());
            resp.setCommand(162);
            resp.setRemotePort(pdu.getRemotePort());
            resp.setDestinationIp(pdu.getSourceIp());
            this.snmp.getSnmpLog().info("Sending response " + resp);
            this.snmp.sendAsyncResponseMessage(resp);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.snmp.getSnmpLog().severe("Exception while sending response: " + e.getMessage());
        }
    }

    private SnmpPDU processSet(SnmpPDU pdu) {
        int i;
        int ver = pdu.getVersion();
        SnmpVarBind[] vbs = pdu.getVaribleBindingArray();
        SnmpPDU resp = this.createSnmpResponseObject(pdu);
        for (i = 0; i < vbs.length; ++i) {
            SnmpOID oid = vbs[i].getObjectID();
            int error = 0;
            try {
                if (pdu.getVersion() != 3 || this.checkAccessControlFor((SnmpV3Message)pdu, oid, true)) {
                    error = this.snmp.getMib().validateForSet(vbs[i], resp, ver);
                }
            }
            catch (VacmException e) {
                e.printStackTrace();
            }
            if (error == 0) continue;
            resp.setErrstat(error);
            resp.setErrindex(i + 1);
            return resp;
        }
        for (i = 0; i < vbs.length; ++i) {
            int error = this.snmp.getMib().processSet(vbs[i], resp, ver);
            if (error == 0) continue;
            resp.clearVariableBindings();
            if (ver == 0) {
                resp.setErrstat(error);
                resp.setErrindex(i + 1);
                break;
            }
            resp.setErrstat(i == 0 ? 14 : 15);
            resp.setErrindex(0);
            break;
        }
        return resp;
    }

    private SnmpPDU createSnmpResponseObject(SnmpPDU pdu) {
        SnmpPDU resp = null;
        try {
            resp = (SnmpPDU)pdu.getClass().newInstance();
            if (resp instanceof SnmpV3Message) {
                this.fetchPduData((SnmpV3Message)pdu, (SnmpV3Message)resp);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return resp;
    }

    private SnmpPDU processGet(SnmpPDU pdu) {
        int ver = pdu.getVersion();
        SnmpVarBind[] vbs = pdu.getVaribleBindingArray();
        SnmpPDU resp = this.createSnmpResponseObject(pdu);
        for (int i = 0; i < vbs.length; ++i) {
            SnmpOID oid = vbs[i].getObjectID();
            int error = 0;
            try {
                if (pdu.getVersion() == 3 && !this.checkAccessControlFor((SnmpV3Message)pdu, oid, false) || (error = this.snmp.getMib().processGet(oid, resp, ver)) == 0 || ver != 0) continue;
                resp.clearVariableBindings();
                resp.setErrstat(error);
                resp.setErrindex(i + 1);
                break;
            }
            catch (VacmException e) {
                resp.clearVariableBindings();
                resp.setErrstat(error);
                resp.setErrindex(i + 1);
                e.printStackTrace();
            }
        }
        return resp;
    }

    private SnmpPDU processGetNext(SnmpPDU pdu) {
        int ver = pdu.getVersion();
        SnmpVarBind[] vbs = pdu.getVaribleBindingArray();
        SnmpPDU resp = this.createSnmpResponseObject(pdu);
        for (int i = 0; i < vbs.length; ++i) {
            SnmpOID oid = vbs[i].getObjectID();
            SnmpVarBind varBind = null;
            try {
                if (pdu.getVersion() != 3 || this.checkAccessControlFor((SnmpV3Message)pdu, oid, false)) {
                    varBind = this.snmp.getMib().processGetNext(oid);
                }
            }
            catch (VacmException e) {
                e.printStackTrace();
            }
            if (varBind == null) {
                if (ver == 0) {
                    resp.clearVariableBindings();
                    resp.setErrstat(2);
                    resp.setErrindex(i + 1);
                    return resp;
                }
                varBind = new SnmpVarBind(oid, new SnmpExceptionVar(130));
            }
            resp.addVariableBinding(varBind);
        }
        return resp;
    }

    private SnmpPDU processBulkRequest(SnmpPDU pdu) {
        int maxRpt;
        SnmpVarBind[] vbs = pdu.getVaribleBindingArray();
        int nonRptCnt = pdu.getNonRepeaters();
        if (nonRptCnt > vbs.length) {
            nonRptCnt = vbs.length;
        }
        if ((maxRpt = pdu.getMaxRepetitions()) < 0) {
            maxRpt = 0;
        }
        SnmpPDU resp = this.createSnmpResponseObject(pdu);
        for (int i = 0; i < nonRptCnt; ++i) {
            SnmpOID oid = vbs[i].getObjectID();
            SnmpVarBind varBind = null;
            try {
                if (pdu.getVersion() != 3 || this.checkAccessControlFor((SnmpV3Message)pdu, oid, false)) {
                    varBind = this.snmp.getMib().processGetNext(oid);
                }
            }
            catch (VacmException e) {
                e.printStackTrace();
            }
            if (varBind == null) {
                varBind = new SnmpVarBind(oid, new SnmpExceptionVar(130));
            }
            resp.addVariableBinding(varBind);
        }
        int rptCnt = vbs.length - nonRptCnt;
        SnmpOID[] oids = new SnmpOID[rptCnt];
        for (int i = 0; i < rptCnt; ++i) {
            oids[i] = vbs[i + nonRptCnt].getObjectID();
        }
        for (int n = 0; n < maxRpt; ++n) {
            for (int i = 0; i < rptCnt; ++i) {
                SnmpVarBind varBind = this.snmp.getMib().processGetNext(oids[i]);
                if (varBind == null) {
                    varBind = new SnmpVarBind(oids[i], new SnmpExceptionVar(130));
                }
                oids[i] = varBind.getObjectID();
                resp.addVariableBinding(varBind);
            }
        }
        Vector<SnmpVarBind> v = resp.getVariableBindings();
        boolean first = false;
        for (int i = v.size() - 1; i >= 0; --i) {
            SnmpVarBind varBind = v.elementAt(i);
            SnmpVar var = varBind.getVariable();
            if (var.type != 130) break;
            if (!first) {
                first = true;
                continue;
            }
            v.removeElementAt(i + 1);
        }
        return resp;
    }

    private int checkReceivedRequest(SnmpPDU pdu) {
        if (this.snmp.getIgnoreRequestsFromUnrecognizedSources() && !this.sourceIpRecognized(pdu.getSourceIp().getHostAddress())) {
            return 0;
        }
        if (!this.snmp.getCheckCommunityOnRequests()) {
            return 2;
        }
        if (pdu.getCommunity().equals(this.snmp.getReadWriteCommunity())) {
            return 2;
        }
        if (pdu.getCommunity().equals(this.snmp.getReadOnlyCommunity())) {
            return 1;
        }
        return 0;
    }

    private boolean sourceIpRecognized(String source) {
        String[] addressList = this.snmp.getRecognizedSources().getAddressList();
        if (addressList == null || addressList.length <= 0) {
            return false;
        }
        for (int i = 0; i < addressList.length; ++i) {
            if (!source.equals(addressList[i])) continue;
            return true;
        }
        return false;
    }

    public static String insertLineFeeds(String data) {
        if (data.length() <= 75) {
            return data;
        }
        StringBuffer sbuf = new StringBuffer();
        String remainder = new String(data);
        while (remainder.length() > 75) {
            int finishIndex = remainder.indexOf(" ", 75);
            if (finishIndex < 0) {
                finishIndex = 100;
            }
            if (finishIndex > remainder.length()) {
                sbuf.append(remainder);
                return sbuf.toString();
            }
            String line = remainder.substring(0, finishIndex + 1);
            sbuf.append(line);
            sbuf.append("\n");
            remainder = remainder.substring(finishIndex, remainder.length());
        }
        if (remainder.length() > 0) {
            sbuf.append(remainder);
        }
        return sbuf.toString();
    }

    private boolean checkAccessControlFor(SnmpV3Message message, SnmpOID oid, boolean accessToSet) throws VacmException {
        boolean status = false;
        BSnmpVACM vacm = BSnmpVACM.getBSnmpVACMinstance();
        status = vacm.isAccessAllowed(message, oid, accessToSet);
        return status;
    }

    private class TrapData {
        private String[] keys = null;
        private BIDataValue[] values = null;

        public void put(String key, BObject value) {
            int nextIndex = 0;
            if (this.keys == null || this.values == null) {
                this.keys = new String[1];
                this.values = new BIDataValue[1];
                this.keys[nextIndex] = key;
                this.values[nextIndex] = (BIDataValue)value;
                return;
            }
            nextIndex = this.keys.length;
            String[] temp1 = new String[nextIndex + 1];
            System.arraycopy(this.keys, 0, temp1, 0, nextIndex);
            temp1[nextIndex] = key;
            this.keys = temp1;
            BIDataValue[] temp2 = new BIDataValue[nextIndex + 1];
            System.arraycopy(this.values, 0, temp2, 0, nextIndex);
            temp2[nextIndex] = (BIDataValue)value;
            this.values = temp2;
        }

        public String[] getKeys() {
            return this.keys;
        }

        public BIDataValue[] getValues() {
            return this.values;
        }
    }
}

