/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.ui.device;

import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.datatypes.BPupDeviceDiscoveryConfig;
import com.tridium.aapup.job.BPupDiscoverDevicesJob;
import com.tridium.aapup.job.BPupDiscoveryDevice;
import java.util.Vector;
import javax.baja.driver.BDevice;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.driver.ui.device.DeviceState;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BPupDeviceManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType(BPupDeviceManager.class);
    static final UiLexicon lex = UiLexicon.makeUiLexicon(BPupDeviceManager.class);
    private static final MgrTypeInfo[] NEW_TYPES = new MgrTypeInfo[]{new MyTypeInfoImpl(BPupDevice.TYPE.getTypeInfo(), lex.getText("mgrTypeInfo.pup"))};
    private BPupNetwork network;
    private MgrColumn colUnitNumber;
    private MgrColumn colManufacturer;
    private MgrColumn colControllerType;
    private MgrColumn colControllerDescription;
    private MgrColumn colPeerType;
    private MgrColumn colVersion;
    private Vector<BPupDiscoveryDevice> discoveredDevices = new Vector();

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    public void doLoadValue(BObject obj, Context cx) {
        try {
            this.network = (BPupNetwork)((BIDeviceFolder)obj).getNetwork();
            super.doLoadValue(obj, cx);
            BPupDevice[] devices = (BPupDevice[])((BComponent)obj).getChildren(BPupDevice.class);
            this.registerForComponentEvents((BComponent[])devices, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        String slotName;
        super.handleComponentEvent(event);
        BJob discJob = this.getLearn().getJob();
        if (discJob != null & event.getSourceComponent() == discJob && event.getId() == 5 && "deviceLearned".equalsIgnoreCase(slotName = event.getSlotName())) {
            BPupDiscoveryDevice value = (BPupDiscoveryDevice)event.getValue();
            this.discoveredDevices.addElement(value);
            this.updateDiscoveryRows();
        }
    }

    private void updateDiscoveryRows() {
        if (this.discoveredDevices.size() > 0) {
            Object[] discoveredRows = new BPupDiscoveryDevice[this.discoveredDevices.size()];
            this.discoveredDevices.copyInto(discoveredRows);
            this.getLearn().updateRoots(discoveredRows);
        }
    }

    public BPupNetwork getNetwork() {
        if (this.network == null) {
            this.network = (BPupNetwork)((BIDeviceFolder)this.getCurrentValue()).getNetwork();
        }
        return this.network;
    }

    public static MgrTypeInfo[] getNewTypes() {
        return NEW_TYPES;
    }

    static class MyTypeInfoImpl
    extends MgrTypeInfo {
        TypeInfo ti;
        String displayName;

        MyTypeInfoImpl(TypeInfo proto) {
            this.ti = proto;
        }

        MyTypeInfoImpl(TypeInfo proto, String disp) {
            this.ti = proto;
            this.displayName = disp;
        }

        MyTypeInfoImpl(String description) {
            this.ti = BTypeSpec.make((String)"aapup:PupDevice").getTypeInfo();
            this.displayName = description;
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            if (this.ti.is(BPupDevice.TYPE)) {
                return lex.getText("mgrTypeInfo.aapup");
            }
            return this.ti.getDisplayName(null);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.ti.getIcon(null));
        }

        public BComponent newInstance() {
            return (BComponent)this.ti.getInstance();
        }

        public boolean isMatchable(BComponent db) {
            return db.getType().is(this.ti);
        }
    }

    class State
    extends DeviceState {
        BJob lastJob;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            Learn lrn = (Learn)m.getLearn();
            this.lastJob = lrn.getJob();
        }

        protected void restoreForOrd(BAbstractManager manager) {
            super.restoreForOrd(manager);
            BPupDeviceManager devManager = (BPupDeviceManager)manager;
            if (this.lastJob != null && this.lastJob.isMounted()) {
                BPupDiscoverDevicesJob discJob = (BPupDiscoverDevicesJob)this.lastJob;
                discJob.lease(2);
                devManager.getLearn().setJob(this.lastJob);
                devManager.discoveredDevices.removeAllElements();
                BPupDiscoveryDevice[] jobDevices = (BPupDiscoveryDevice[])discJob.getLearnedDevices().getChildren(BPupDiscoveryDevice.class);
                if (jobDevices.length > 0) {
                    for (int i = 0; i < jobDevices.length; ++i) {
                        devManager.discoveredDevices.addElement(jobDevices[i]);
                    }
                    devManager.updateDiscoveryRows();
                }
            }
        }
    }

    class Controller
    extends DeviceController {
        BPupDeviceManager devManager;

        public Controller(BPupDeviceManager manager) {
            super((BDeviceManager)manager);
            this.devManager = manager;
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BPupDeviceDiscoveryConfig config = new BPupDeviceDiscoveryConfig();
            config.setControllerList(BPupDeviceManager.this.getNetwork().getDeviceTypesFile());
            BPupDeviceDiscoveryConfig params = (BPupDeviceDiscoveryConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)lex.get("pupDevMgr.discover.description"), (BObject)config);
            if (params != null) {
                BPupDeviceManager.this.getNetwork().setDeviceTypesFile(params.getControllerList());
                this.devManager.discoveredDevices.removeAllElements();
                this.devManager.updateDiscoveryRows();
                this.getManager().getLearn().setJob(BPupDeviceManager.this.getNetwork().submitDeviceDiscoveryJob(params));
            }
            return null;
        }
    }

    class Learn
    extends MgrLearn {
        BPupDiscoveryDevice[] lastLearn;

        public Learn(BPupDeviceManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BPupDiscoveryDevice.unitNumber, 0), new MgrColumn.Prop(BPupDiscoveryDevice.controllerType, 0), new MgrColumn.Prop(BPupDiscoveryDevice.controllerDescription, 0), new MgrColumn.Prop(BPupDiscoveryDevice.peerType, 0), new MgrColumn.Prop(BPupDiscoveryDevice.version, 0)};
        }

        public boolean isExisting(Object discovery, BComponent component) {
            if (component instanceof BPupDevice && discovery instanceof BPupDiscoveryDevice) {
                BPupDiscoveryDevice disc = (BPupDiscoveryDevice)discovery;
                BPupDevice dev = (BPupDevice)component;
                return disc.getUnitNumber() == dev.getUnitNumber() && disc.getControllerType() == dev.getControllerType() && disc.getManufacturer() == dev.getManufacturer();
            }
            return false;
        }

        public boolean isMatchable(Object discovery, BComponent database) {
            return false;
        }

        public void jobComplete(BJob job) {
            BPupDeviceManager.this.updateDiscoveryRows();
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            BPupDiscoveryDevice disc = (BPupDiscoveryDevice)dis;
            return new MgrTypeInfo[]{new MyTypeInfoImpl(disc.getControllerDescription())};
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            BPupDiscoveryDevice disc = (BPupDiscoveryDevice)dis;
            row.setCell(BPupDeviceManager.this.colUnitNumber, (BValue)BInteger.make((int)disc.getUnitNumber()));
            row.setCell(BPupDeviceManager.this.colManufacturer, (BValue)BInteger.make((int)disc.getManufacturer()));
            row.setCell(BPupDeviceManager.this.colControllerType, (BValue)BInteger.make((int)disc.getControllerType()));
            row.setCell(BPupDeviceManager.this.colControllerDescription, (BValue)BString.make((String)disc.getControllerDescription()));
            row.setCell(BPupDeviceManager.this.colPeerType, (BValue)disc.getPeerType());
            row.setCell(BPupDeviceManager.this.colVersion, (BValue)BBoolean.make((boolean)disc.getVersion()));
        }
    }

    class Model
    extends DeviceModel {
        Model(BPupDeviceManager mgr) {
            super((BDeviceManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Path(2), new MgrColumn.Name(), new MgrColumn.Type(2), new MgrColumn.Prop(BDevice.enabled, 1), BPupDeviceManager.this.colUnitNumber = (MgrColumn)new MgrColumn.Prop(BPupDevice.unitNumber, 1), BPupDeviceManager.this.colManufacturer = (MgrColumn)new MgrColumn.Prop(BPupDevice.manufacturer, 5), BPupDeviceManager.this.colControllerType = (MgrColumn)new MgrColumn.Prop(BPupDevice.controllerType, 5), BPupDeviceManager.this.colControllerDescription = (MgrColumn)new MgrColumn.Prop(BPupDevice.controllerDescription, 5), BPupDeviceManager.this.colPeerType = (MgrColumn)new MgrColumn.Prop(BPupDevice.peerType, 5), BPupDeviceManager.this.colVersion = (MgrColumn)new MgrColumn.Prop(BPupDevice.version, 5), new DeviceExtsColumn((BDevice)new BPupDevice())};
        }
    }
}

