/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.mqttClientDriver.proxyExt.BMqttClientAbstractProxyExt;
import com.tridium.mqttClientDriver.proxyExt.publishers.BMqttBooleanObjectPublishExt;
import com.tridium.mqttClientDriver.proxyExt.publishers.BMqttClientAbstractPublisherPoint;
import com.tridium.mqttClientDriver.proxyExt.publishers.BMqttEnumObjectPublishExt;
import com.tridium.mqttClientDriver.proxyExt.publishers.BMqttNumericObjectPublishExt;
import com.tridium.mqttClientDriver.proxyExt.publishers.BMqttStringObjectPublishExt;
import com.tridium.mqttClientDriver.proxyExt.subscribers.BMqttBooleanObjectSubscribeExt;
import com.tridium.mqttClientDriver.proxyExt.subscribers.BMqttClientAbstractSubscriberPoint;
import com.tridium.mqttClientDriver.proxyExt.subscribers.BMqttEnumObjectSubscribeExt;
import com.tridium.mqttClientDriver.proxyExt.subscribers.BMqttNumericObjectSubscribeExt;
import com.tridium.mqttClientDriver.proxyExt.subscribers.BMqttStringObjectSubscribeExt;
import com.tridium.ndriver.ui.NMgrLearn;
import com.tridium.ndriver.ui.point.BNPointManager;
import com.tridium.ndriver.ui.point.NPointModel;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import java.util.ArrayList;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.gx.BImage;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrEditDialog;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;

@NiagaraType(agent={@AgentOn(types={"abstractMqttDriver:MqttClientDriverPointDeviceExt", "abstractMqttDriver:MqttClientDriverPointFolder"})})
public class BMqttClientDriverPointManager
extends BNPointManager {
    public static final Type TYPE = Sys.loadType(BMqttClientDriverPointManager.class);
    static Lexicon lex = Lexicon.make(BMqttClientDriverPointManager.class);
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type();
    MgrColumn colToString = new MgrColumn.ToString("Out", 0);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.enabled}, 3);
    MgrColumn colTopic = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMqttClientAbstractProxyExt.topic}, 1);
    MgrColumn colLocalPoint = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMqttClientAbstractProxyExt.localPoint}, 1);
    MgrColumn colLocalPointSlot = new MqttLocalPointSlot();
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 1);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.deviceFacets}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.conversion}, 3);
    MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
    MgrColumn colReadValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    MgrColumn colWriteValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colToString, this.colEnabled, this.colLocalPoint, this.colTopic, this.colLocalPointSlot, this.colFacets, this.colTuning, this.colDeviceFacets, this.colConversion, this.colFaultCause, this.colReadValue, this.colWriteValue};
    MgrColumn dcolPath = new Column("SlotPath", "toPathString");
    MgrColumn dcolHandle = new Column("Handle", "handle", 2);
    MgrColumn dcolType = new Column("Type", "type");
    MgrColumn[] dcols = new MgrColumn[]{this.dcolPath, this.dcolHandle, this.dcolType};
    public static final MqttClientDriverMgrTypeInfo MQTT_BOOLEAN_PUBLISH_POINT = new MqttClientDriverMgrTypeInfo(Sys.getRegistry().getType("control:BooleanWritable"), "type.BooleanWritable");
    private static final MqttClientDriverMgrTypeInfo MQTT_BOOLEAN_SUBSCRIBE_POINT = new MqttClientDriverMgrTypeInfo(Sys.getRegistry().getType("control:BooleanPoint"), "type.BooleanPoint");
    private static final MqttClientDriverMgrTypeInfo MQTT_NUMERIC_PUBLISH_POINT = new MqttClientDriverMgrTypeInfo(Sys.getRegistry().getType("control:NumericWritable"), "type.NumericWritable");
    private static final MqttClientDriverMgrTypeInfo MQTT_NUMERIC_SUBSCRIBE_POINT = new MqttClientDriverMgrTypeInfo(Sys.getRegistry().getType("control:NumericPoint"), "type.NumericPoint");
    private static final MqttClientDriverMgrTypeInfo MQTT_STRING_PUBLISH_POINT = new MqttClientDriverMgrTypeInfo(Sys.getRegistry().getType("control:StringWritable"), "type.StringWritable");
    private static final MqttClientDriverMgrTypeInfo MQTT_STRING_SUBSCRIBE_POINT = new MqttClientDriverMgrTypeInfo(Sys.getRegistry().getType("control:StringPoint"), "type.StringPoint");
    private static final MqttClientDriverMgrTypeInfo MQTT_ENUM_PUBLISH_POINT = new MqttClientDriverMgrTypeInfo(Sys.getRegistry().getType("control:EnumWritable"), "type.EnumWritable");
    private static final MqttClientDriverMgrTypeInfo MQTT_ENUM_SUBSCRIBE_POINT = new MqttClientDriverMgrTypeInfo(Sys.getRegistry().getType("control:EnumPoint"), "type.EnumPoint");
    private static String[] INPUT_SLOTS = new String[]{"in15", "in14", "in13", "in12", "in11", "in10", "in9", "in7", "in6", "in5", "in4", "in3", "in2"};

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn((BAbstractManager)this);
    }

    public static String toSlotPathString(String ordString) {
        if (ordString.startsWith("station:|")) {
            return ordString.substring(9);
        }
        if (!ordString.startsWith("slot:")) {
            return "slot:" + ordString;
        }
        return ordString;
    }

    void loadNodes(ExportNode[] nodes) {
        Array acc = new Array(BComponent.class);
        for (int i = 0; i < nodes.length; ++i) {
            ExportNode node = nodes[i];
            if (node.value != null) continue;
            String handle = node.get(this.dcolHandle).toString();
            BComponent c = (BComponent)BOrd.make((String)("station:|h:" + handle)).get((BObject)node.session);
            node.value = c;
            node.name = c.getName();
            node.path = c.getSlotPath().getBody();
            acc.add((Object)c);
        }
        BComponent[] toLease = (BComponent[])acc.trim();
        BComponent.lease((BComponent[])toLease, (int)0);
    }

    public static class MqttLocalPointSlot
    extends MgrColumn {
        boolean isDefault = false;
        String pointSlotProp = "localPointSlot";
        String outSlot = "out";

        public MqttLocalPointSlot() {
            super(lex.getText("table.columnTitle.localPointSlot"), 3);
        }

        public Object get(Object row) {
            BAbstractProxyExt ext;
            if (row instanceof BControlPoint && (ext = ((BControlPoint)row).getProxyExt()) instanceof BMqttClientAbstractProxyExt) {
                return ((BMqttClientAbstractProxyExt)ext).getLocalPointSlot().getTag();
            }
            return "";
        }

        public BValue load(MgrEditRow row) {
            BAbstractProxyExt ext;
            this.isDefault = false;
            BComponent val = row.getTarget();
            ExportNode node = (ExportNode)row.getDiscovery();
            if (node == null) {
                BComponent c = row.getTarget();
                BComplex parent = c.getParent();
                if (parent != null && c instanceof BControlPoint) {
                    BAbstractProxyExt proxyExt = ((BControlPoint)c).getProxyExt();
                    if (proxyExt instanceof BMqttClientAbstractPublisherPoint) {
                        return ((BMqttClientAbstractProxyExt)proxyExt).getLocalPointSlot();
                    }
                    if (proxyExt instanceof BMqttClientAbstractSubscriberPoint) {
                        BMqttClientAbstractSubscriberPoint subsExt = (BMqttClientAbstractSubscriberPoint)proxyExt;
                        BControlPoint targetPoint = (BControlPoint)subsExt.getLocalPoint().get((BObject)parent);
                        return this.getLinkableSlots(targetPoint);
                    }
                }
            } else if (val instanceof BControlPoint && (ext = ((BControlPoint)val).getProxyExt()) instanceof BMqttClientAbstractProxyExt) {
                if (ext instanceof BMqttClientAbstractSubscriberPoint) {
                    return this.getLinkableSlots((BControlPoint)node.value);
                }
                BEnumRange inRange = BEnumRange.make((String[])new String[]{"out"});
                return BDynamicEnum.make((int)0, (BEnumRange)inRange);
            }
            this.isDefault = true;
            BEnumRange inRange = BEnumRange.make((String[])new String[]{"na"});
            return BDynamicEnum.make((int)0, (BEnumRange)inRange);
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BAbstractProxyExt ext;
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint && (ext = ((BControlPoint)val).getProxyExt()) instanceof BMqttClientAbstractProxyExt) {
                ((BMqttClientAbstractProxyExt)ext).setLocalPointSlot(BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])new String[]{value.toString()})));
            }
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(row, value, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows == null || rows.length <= 0) {
                return null;
            }
            for (int i = 0; i < rows.length; ++i) {
                BComponent val = rows[i].getTarget();
                if (!(val instanceof BControlPoint)) {
                    return null;
                }
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BMqttClientAbstractProxyExt) continue;
                return null;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty(this.pointSlotProp)};
            return MqttLocalPointSlot.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])props);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            if (rows == null || rows.length <= 0) {
                return;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty(this.pointSlotProp)};
            MqttLocalPointSlot.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])props);
        }

        private BDynamicEnum getLinkableSlots(BControlPoint point) {
            BDynamicEnum inSelEnum = BDynamicEnum.DEFAULT;
            try {
                String[] inTags = this.getLinkableSlotsNames(point);
                BEnumRange inRange = BEnumRange.make((String[])inTags);
                inSelEnum = BDynamicEnum.make((int)0, (BEnumRange)inRange);
                return inSelEnum;
            }
            catch (Exception e) {
                e.printStackTrace();
                return inSelEnum;
            }
        }

        private String[] getLinkableSlotsNames(BControlPoint point) {
            ArrayList<String> aList = new ArrayList<String>();
            if (!point.isWritablePoint()) {
                aList.add("out");
            } else {
                String inputSlot;
                Slot slot;
                String[] stringArray = INPUT_SLOTS;
                int n = stringArray.length;
                for (int i = 0; i < n && (slot = point.getSlot(inputSlot = stringArray[i])) != null; ++i) {
                    if (Flags.isReadonly((BComplex)point, (Slot)slot) || !Flags.isFanIn((BComplex)point, (Slot)slot) && point.isLinkTarget(slot)) continue;
                    aList.add(inputSlot);
                }
            }
            return aList.toArray(new String[aList.size()]);
        }
    }

    static class MqttClientDriverMgrTypeInfo
    extends MgrTypeInfo {
        private TypeInfo pntType;
        private String displayName;

        MqttClientDriverMgrTypeInfo(TypeInfo pntType, String displayKey) {
            this.pntType = pntType;
            this.displayName = lex.getText(displayKey);
        }

        MqttClientDriverMgrTypeInfo(BComponent c) {
            BControlPoint cp = (BControlPoint)c;
            this.pntType = cp.getType().getTypeInfo();
            this.displayName = this.pntType.is(BIWritablePoint.TYPE) ? lex.getText("type." + this.pntType.getTypeName()) : lex.getText("type." + this.pntType.getTypeName());
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public BImage getIcon() {
            return null;
        }

        public BComponent newInstance() {
            BControlPoint pnt = (BControlPoint)this.pntType.getInstance();
            BMqttBooleanObjectPublishExt ext = null;
            if (pnt instanceof BBooleanWritable) {
                ext = new BMqttBooleanObjectPublishExt();
            } else if (pnt instanceof BBooleanPoint) {
                ext = new BMqttBooleanObjectSubscribeExt();
            } else if (pnt instanceof BNumericWritable) {
                ext = new BMqttNumericObjectPublishExt();
            } else if (pnt instanceof BNumericPoint) {
                ext = new BMqttNumericObjectSubscribeExt();
            } else if (pnt instanceof BStringWritable) {
                ext = new BMqttStringObjectPublishExt();
            } else if (pnt instanceof BStringPoint) {
                ext = new BMqttStringObjectSubscribeExt();
            } else if (pnt instanceof BEnumWritable) {
                ext = new BMqttEnumObjectPublishExt();
            } else if (pnt instanceof BEnumPoint) {
                ext = new BMqttEnumObjectSubscribeExt();
            }
            pnt.setProxyExt((BAbstractProxyExt)ext);
            return pnt;
        }

        public boolean isMatchable(BComponent db) {
            return false;
        }
    }

    class ExportNode {
        String name;
        String path;
        BValue value;
        public BFoxSession session;
        public BImage icon;
        public BIObject[] cells;

        public ExportNode(BFoxSession session) {
            this.session = session;
        }

        public BImage getIcon() {
            return this.icon;
        }

        public Object get(MgrColumn col) {
            return col.get((Object)this);
        }

        public boolean hasChildren() {
            return false;
        }

        public ExportNode[] getChildren() {
            return new ExportNode[0];
        }

        public void update(BIRandomAccessTable<?> table, int rowIndex) {
            ColumnList cols = table.getColumns();
            this.cells = new BIObject[cols.size() - 1];
            for (int c = 0; c < this.cells.length; ++c) {
                this.cells[c] = table.get(rowIndex).cell(cols.get(c));
            }
            this.icon = BImage.make((String)table.get(rowIndex).cell(cols.get(cols.size() - 1)).toString());
        }

        void loadNode() {
            BMqttClientDriverPointManager.this.loadNodes(new ExportNode[]{this});
        }
    }

    public static class Column
    extends MgrColumn {
        public final String projection;
        int colIndex = -1;

        public Column(String displayName, String projection) {
            this(displayName, projection, 0);
        }

        public Column(String displayName, String projection, int flags) {
            super(displayName, flags);
            this.projection = projection;
        }

        public int getColumnIndex() {
            if (this.colIndex == -1) {
                MgrColumn[] cols = this.getManager().getLearn().getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    if (cols[i] != this) continue;
                    this.colIndex = i;
                    break;
                }
                if (this.colIndex == -1) {
                    throw new IllegalStateException("Column not in manager.getDiscoveryColumns()");
                }
            }
            return this.colIndex;
        }

        public Object get(Object discovery) {
            return ((ExportNode)discovery).cells[this.getColumnIndex()];
        }
    }

    class Learn
    extends NMgrLearn {
        BOrd bqlQuery;
        BComponent target;
        BFoxSession targetSession;
        ExportNode[] lastLearn;

        public Learn(BAbstractManager manager) {
            super(manager);
        }

        public BComponent getTarget() {
            return this.target;
        }

        public BFoxSession getTargetSession() {
            return this.targetSession;
        }

        public void load(BComponent target) {
            super.load(target);
            this.target = target;
            BISession session = target.getSession();
            if (session instanceof BFoxSession) {
                this.targetSession = (BFoxSession)session;
            }
        }

        public void toRow(Object dis, MgrEditRow row) {
            this.toRow(dis, row, row.getEdit());
        }

        public void toRow(Object dis, MgrEditRow row, MgrEdit edit) {
            ExportNode node = (ExportNode)dis;
            node.loadNode();
            row.setDefaultName(node.name);
            BOrd ord = BOrd.make((String)("station:|slot:" + node.path));
            row.setCell(BMqttClientDriverPointManager.this.colLocalPoint, (BValue)ord);
        }

        public boolean isExisting(Object discovery, BComponent component) {
            BMqttClientAbstractProxyExt obj = null;
            if (component instanceof BControlPoint) {
                if (!(((BControlPoint)component).getProxyExt() instanceof BMqttClientAbstractProxyExt)) {
                    return false;
                }
                obj = (BMqttClientAbstractProxyExt)((BControlPoint)component).getProxyExt();
                ExportNode n = (ExportNode)discovery;
                BOrd objOrd = BOrd.make((String)BMqttClientDriverPointManager.toSlotPathString(obj.getLocalPoint().toString()));
                BOrd sp = BOrd.make((String)BMqttClientDriverPointManager.toSlotPathString(n.get(BMqttClientDriverPointManager.this.dcolPath).toString()));
                return objOrd.equals((Object)sp);
            }
            return false;
        }

        public BImage getIcon(Object node) {
            return ((ExportNode)node).getIcon();
        }

        public boolean isGroup(Object node) {
            return this.hasChildren(node);
        }

        public boolean hasChildren(Object node) {
            return ((ExportNode)node).hasChildren();
        }

        public Object[] getChildren(Object node) {
            return ((ExportNode)node).getChildren();
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            Array a = new Array(MgrTypeInfo.class);
            String typeSpec = BMqttClientDriverPointManager.this.dcolType.get(discovery).toString();
            BTypeSpec type = Sys.getRegistry().getType(typeSpec).getTypeSpec();
            BControlPoint instance = (BControlPoint)type.getInstance();
            BStatusValue statusValue = instance.getOutStatusValue();
            if (statusValue instanceof BStatusBoolean) {
                a.add((Object)MQTT_BOOLEAN_PUBLISH_POINT);
                a.add((Object)MQTT_BOOLEAN_SUBSCRIBE_POINT);
            }
            if (statusValue instanceof BStatusNumeric) {
                a.add((Object)MQTT_NUMERIC_PUBLISH_POINT);
                a.add((Object)MQTT_NUMERIC_SUBSCRIBE_POINT);
            }
            if (statusValue instanceof BStatusEnum) {
                a.add((Object)MQTT_ENUM_PUBLISH_POINT);
                a.add((Object)MQTT_ENUM_SUBSCRIBE_POINT);
            }
            if (statusValue instanceof BStatusString) {
                a.add((Object)MQTT_STRING_PUBLISH_POINT);
                a.add((Object)MQTT_STRING_SUBSCRIBE_POINT);
            }
            if (!instance.isWritablePoint()) {
                a.remove(1);
            }
            return (MgrTypeInfo[])a.trim();
        }

        public MgrColumn[] makeColumns() {
            return BMqttClientDriverPointManager.this.dcols;
        }

        public void bqlDiscover(BFoxSession session, BTypeSpec filterType) throws Exception {
            BComponentSpace space;
            BStation station;
            BBqlQueryBuilder builder;
            String bqlBuilderStr;
            BOrd bql;
            if (this.bqlQuery == null) {
                String projection = this.getBqlProjection();
                this.bqlQuery = BOrd.make((String)("station:|slot:/|bql:select " + projection + " from " + filterType));
            }
            if ((bql = BOrd.make((String)((bqlBuilderStr = (builder = new BBqlQueryBuilder((BObject)(station = (BStation)(space = (BComponentSpace)session.getNavChild("station")).getRootComponent()), this.bqlQuery, false)).open((BWidget)this.getManager()).toString()) + this.getProxyExtFilter()))) == null) {
                return;
            }
            if (!bql.relativizeToSession().toString().startsWith("station")) {
                return;
            }
            this.bqlQuery = BOrd.make((String)bqlBuilderStr);
            BITable table = (BITable)bql.get((BObject)station);
            this.updateTable(table, session);
        }

        public String getProxyExtFilter() {
            StringBuffer s = new StringBuffer();
            s.append(" where proxyExt.type != abstractMqttDriver:MqttStringObjectPublishExt");
            s.append(" and proxyExt.type != abstractMqttDriver:MqttNumericObjectPublishExt");
            s.append(" and proxyExt.type != abstractMqttDriver:MqttBooleanObjectPublishExt");
            s.append(" and proxyExt.type != abstractMqttDriver:MqttEnumObjectPublishExt");
            s.append(" and proxyExt.type != abstractMqttDriver:MqttStringObjectSubscribeExt");
            s.append(" and proxyExt.type != abstractMqttDriver:MqttNumericObjectSubscribeExt");
            s.append(" and proxyExt.type != abstractMqttDriver:MqttBooleanObjectSubscribeExt");
            s.append(" and proxyExt.type != abstractMqttDriver:MqttEnumObjectSubscribeExt");
            return s.toString();
        }

        public String getBqlProjection() {
            StringBuffer s = new StringBuffer();
            MgrColumn[] cols = this.getColumns();
            for (int i = 0; i < cols.length; ++i) {
                if (i > 0) {
                    s.append(",");
                }
                Column col = (Column)cols[i];
                s.append(col.projection);
            }
            s.append(",proxyExt.type");
            s.append(",icon");
            return s.toString();
        }

        public void updateTable(BITable<?> table, BFoxSession session) {
            BIRandomAccessTable rtable = Tables.slurp(table);
            ArrayList<ExportNode> exportNodes = new ArrayList<ExportNode>((rtable.size() + 1) / 2);
            ExportNode node = null;
            for (int i = 0; i < rtable.size(); ++i) {
                node = this.makeNode(session);
                node.update(rtable, i);
                exportNodes.add(node);
            }
            Object[] roots = exportNodes.toArray(new ExportNode[exportNodes.size()]);
            this.lastLearn = roots;
            this.updateRoots(roots);
        }

        protected ExportNode makeNode(BFoxSession session) {
            return new ExportNode(session);
        }
    }

    class Controller
    extends FolderController {
        boolean added;

        Controller(BNPointManager mgr) {
            super((BFolderManager)mgr);
        }

        public void updateCommands() {
            super.updateCommands();
            MgrLearn learn = BMqttClientDriverPointManager.this.getLearn();
            BLearnTable table = learn.getTable();
            if (table == null) {
                return;
            }
            Object[] selectedObjects = table.getSelectedObjects();
            if (selectedObjects.length == 0) {
                return;
            }
            this.add.setEnabled(selectedObjects.length > 0);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            Learn learn = (Learn)this.getManager().getLearn();
            BFoxSession session = learn.getTargetSession();
            if (session == null) {
                return null;
            }
            learn.bqlDiscover(session, BTypeSpec.make((String)"control:ControlPoint"));
            return null;
        }

        protected CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            try {
                ExportNode[] nodes = new ExportNode[discovery.length];
                System.arraycopy(discovery, 0, nodes, 0, discovery.length);
                BMqttClientDriverPointManager.this.loadNodes(nodes);
                this.added = false;
                MgrEdit edit = new MgrEdit(this.getManager(), this.add.getLabel()){

                    public boolean prompt() throws Exception {
                        BMgrEditDialog dialog = new BMgrEditDialog((MgrEdit)this, this.getSelectAll());
                        dialog.setScreenSizeToPreferredSize();
                        dialog.setBoundsCenteredOnOwner();
                        dialog.open();
                        Controller.this.added = dialog.getResult() == 1;
                        return Controller.this.added;
                    }
                };
                for (int i = 0; i < discovery.length; ++i) {
                    ExportNode dis = (ExportNode)discovery[i];
                    MgrTypeInfo[] types = this.getManager().getLearn().toTypes((Object)dis);
                    if (types == null || types.length == 0) continue;
                    MgrEditRow row = edit.addRow((Object)dis, types);
                    ((Learn)this.getManager().getLearn()).toRow(dis, row, edit);
                }
                CommandArtifact ret = edit.invoke(cx);
                return ret;
            }
            catch (ActionInvokeException e) {
                e.printStackTrace();
                Throwable t = e.getCause();
                if (t != null) {
                    System.out.println(" AIE caused by " + t);
                    t.printStackTrace();
                }
                throw e;
            }
        }
    }

    class Model
    extends NPointModel {
        Model(BNPointManager manager) {
            super(manager);
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList<MqttClientDriverMgrTypeInfo> list = new ArrayList<MqttClientDriverMgrTypeInfo>();
            list.add(MQTT_BOOLEAN_PUBLISH_POINT);
            list.add(MQTT_BOOLEAN_SUBSCRIBE_POINT);
            list.add(MQTT_NUMERIC_PUBLISH_POINT);
            list.add(MQTT_NUMERIC_SUBSCRIBE_POINT);
            list.add(MQTT_STRING_PUBLISH_POINT);
            list.add(MQTT_STRING_SUBSCRIBE_POINT);
            list.add(MQTT_ENUM_PUBLISH_POINT);
            list.add(MQTT_ENUM_SUBSCRIBE_POINT);
            return list.toArray(new MgrTypeInfo[list.size()]);
        }

        public MgrTypeInfo toType(BComponent c) {
            return new MqttClientDriverMgrTypeInfo(c);
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            MqttClientDriverMgrTypeInfo mqttType = (MqttClientDriverMgrTypeInfo)type;
            BControlPoint pt = (BControlPoint)mqttType.newInstance();
            return pt;
        }

        public MgrColumn[] makeColumns() {
            return BMqttClientDriverPointManager.this.cols;
        }
    }
}

