/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.wizards;

import com.tridium.devkit.codegen.CodeGen;
import com.tridium.devkit.wizards.DriverWizardModel;
import com.tridium.devkit.wizards.NewDriverWizard2;
import com.tridium.workbench.tools.NewModuleWizard;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.workbench.BWbShell;
import javax.baja.xml.XWriter;

public class NewVideoDriverWizard
extends DriverWizardModel {
    static UiLexicon lex = UiLexicon.makeUiLexicon(NewVideoDriverWizard.class);
    static BImage banner = BImage.make((String)"module://icons/x32/newModule.png");
    private static final String codeTemplatesPath = "module://devkit/templates/videoDriver/";
    CodeGen cg = null;
    String basePrefix = null;
    String videoNetworkName = null;
    String dvrName = null;
    String cameraName = null;
    String displayName = null;
    String eventName = null;
    BWidget protocolSelectionStep;
    BCheckBox httpCheckBox = new BCheckBox("HTTP");
    BCheckBox tcpCheckBox = new BCheckBox("TCP/IP");
    BCheckBox udpCheckBox = new BCheckBox("UDP/IP");
    BCheckBox serialCheckBox = new BCheckBox("Serial");
    BWidget dvrSupportStep;
    BGridPane dvrDiscoverySupportChoicePane = new BGridPane(1);
    BGridPane dvrDisplaySupportChoicePane = new BGridPane(1);
    ToggleCommandGroup<ToggleCommand> dvrSupportToggleGroup = new DvrSupportToggleCommandGroup();
    ToggleCommandGroup<ToggleCommand> dvrDiscoverySupportToggleGroup = new ToggleCommandGroup();
    ToggleCommandGroup<ToggleCommand> dvrDisplaySupportToggleGroup = new ToggleCommandGroup();
    BRadioButton dvrSupportRequiredRadioBtn = new BRadioButton(this.dvrSupportToggleGroup, lex.getText("videoDriver.dvrSupportRequired"));
    BRadioButton dvrSupportNotRequiredRadioBtn = new BRadioButton(this.dvrSupportToggleGroup, lex.getText("videoDriver.dvrSupportNotRequired"));
    BRadioButton dvrDiscoverySupportRequiredRadioBtn = new BRadioButton(this.dvrDiscoverySupportToggleGroup, lex.getText("videoDriver.dvrDiscoverySupportedRequired"));
    BRadioButton dvrDiscoverySupportNotRequiredRadioBtn = new BRadioButton(this.dvrDiscoverySupportToggleGroup, lex.getText("videoDriver.dvrDiscoverySupportNotRequired"));
    BRadioButton dvrDisplaySupportRequiredRadioBtn = new BRadioButton(this.dvrDisplaySupportToggleGroup, lex.getText("videoDriver.dvrDisplaySupportedRequired"));
    BRadioButton dvrDisplaySupportNotRequiredRadioBtn = new BRadioButton(this.dvrDisplaySupportToggleGroup, lex.getText("videoDriver.dvrDisplaySupportedNotRequired"));
    BWidget cameraOperationsSupportStep;
    BCheckBox panTiltCheckBox = new BCheckBox("Pan/Tilt");
    BCheckBox zoomCheckBox = new BCheckBox("Zoom");
    BCheckBox focusCheckBox = new BCheckBox("Focus Control");
    BCheckBox irisCheckBox = new BCheckBox("Iris Control");
    BCheckBox storePresetCheckBox = new BCheckBox("Store Presets");
    BCheckBox moveToPresetCheckBox = new BCheckBox("Move to Preset");
    FilePath rtPath;
    FilePath wbPath;

    public NewVideoDriverWizard(BWbShell shell, NewDriverWizard2 eitherDriverWizard) {
        super(shell, eitherDriverWizard);
        this.buildModuleDetailsStep(this.getTitle(), NewDriverWizard2.lexStepXofY(2, 5));
        this.buildProtocolSelectionStep();
        this.buildDvrSupportStep();
        this.buildCameraOperationsStep();
    }

    private void buildProtocolSelectionStep() {
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), NewDriverWizard2.lexStepXofY(3, 5)));
        BGridPane protocolChoicesPane = new BGridPane(1);
        protocolChoicesPane.setHalign(BHalign.left);
        protocolChoicesPane.setValign(BValign.top);
        protocolChoicesPane.add(null, (BValue)new BLabel(lex.getText("driver.selectProtocols")));
        protocolChoicesPane.add(null, (BValue)this.httpCheckBox);
        protocolChoicesPane.add(null, (BValue)this.tcpCheckBox);
        protocolChoicesPane.add(null, (BValue)this.udpCheckBox);
        protocolChoicesPane.add(null, (BValue)this.serialCheckBox);
        edge.setCenter((BWidget)new BBorderPane((BWidget)protocolChoicesPane, 10.0, 10.0, 10.0, 10.0));
        this.protocolSelectionStep = edge;
    }

    private void buildDvrSupportStep() {
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), NewDriverWizard2.lexStepXofY(4, 5)));
        BGridPane dvrSupportChoicePane = new BGridPane(1);
        dvrSupportChoicePane.setHalign(BHalign.left);
        dvrSupportChoicePane.setValign(BValign.top);
        dvrSupportChoicePane.add(null, (BValue)new BLabel(lex.getText("videoDriver.useDvrQuestion")));
        dvrSupportChoicePane.add(null, (BValue)this.dvrSupportRequiredRadioBtn);
        dvrSupportChoicePane.add(null, (BValue)this.dvrSupportNotRequiredRadioBtn);
        this.dvrSupportNotRequiredRadioBtn.setSelected(true);
        this.dvrDiscoverySupportChoicePane.setHalign(BHalign.left);
        this.dvrDiscoverySupportChoicePane.setValign(BValign.top);
        this.dvrDiscoverySupportChoicePane.add(null, (BValue)new BLabel(lex.getText("videoDriver.useDvrDiscoveryQuestion")));
        this.dvrDiscoverySupportChoicePane.add(null, (BValue)this.dvrDiscoverySupportRequiredRadioBtn);
        this.dvrDiscoverySupportChoicePane.add(null, (BValue)this.dvrDiscoverySupportNotRequiredRadioBtn);
        this.dvrDisplaySupportChoicePane.setHalign(BHalign.left);
        this.dvrDisplaySupportChoicePane.setValign(BValign.top);
        this.dvrDisplaySupportChoicePane.add(null, (BValue)new BLabel(lex.getText("videoDriver.useDvrDisplayQuestion")));
        this.dvrDisplaySupportChoicePane.add(null, (BValue)this.dvrDisplaySupportRequiredRadioBtn);
        this.dvrDisplaySupportChoicePane.add(null, (BValue)this.dvrDisplaySupportNotRequiredRadioBtn);
        BGridPane containerPane = new BGridPane(1);
        containerPane.setHalign(BHalign.left);
        containerPane.setValign(BValign.top);
        containerPane.add(null, (BValue)dvrSupportChoicePane);
        containerPane.add(null, (BValue)this.dvrDiscoverySupportChoicePane);
        containerPane.add(null, (BValue)this.dvrDisplaySupportChoicePane);
        edge.setCenter((BWidget)new BBorderPane((BWidget)containerPane, 10.0, 10.0, 10.0, 10.0));
        this.dvrSupportStep = edge;
    }

    private void buildCameraOperationsStep() {
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), NewDriverWizard2.lexStepXofY(5, 5)));
        BGridPane containerPane = new BGridPane(1);
        containerPane.setHalign(BHalign.left);
        containerPane.setValign(BValign.top);
        containerPane.add(null, (BValue)new BLabel("Select the operations supported by the camera"));
        containerPane.add(null, (BValue)this.panTiltCheckBox);
        containerPane.add(null, (BValue)this.zoomCheckBox);
        containerPane.add(null, (BValue)this.irisCheckBox);
        containerPane.add(null, (BValue)this.focusCheckBox);
        containerPane.add(null, (BValue)this.moveToPresetCheckBox);
        containerPane.add(null, (BValue)this.storePresetCheckBox);
        edge.setCenter((BWidget)new BBorderPane((BWidget)containerPane, 10.0, 10.0, 10.0, 10.0));
        this.cameraOperationsSupportStep = edge;
    }

    private void stepToModuleDetailsStep() {
        this.update(this.step0, this.driverWizard == null ? 2 : 3);
        this.getWizard().setNextAsDefault();
        this.moduleDir.requestFocus();
        this.currentStep = 0;
    }

    private void stepToProtocolSelectionStep() {
        this.update(this.protocolSelectionStep, this.driverWizard == null ? 2 : 3);
        this.getWizard().setNextAsDefault();
        this.currentStep = 1;
    }

    private void stepToDvrSupportStep() {
        this.update(this.dvrSupportStep, this.driverWizard == null ? 2 : 3);
        this.getWizard().setNextAsDefault();
        this.currentStep = 2;
    }

    private void stepToCameraOperationsStep() {
        this.update(this.cameraOperationsSupportStep, this.driverWizard == null ? 2 : 5);
        this.currentStep = 3;
    }

    public void init() {
        this.stepToModuleDetailsStep();
    }

    public void back() {
        switch (this.currentStep) {
            case 0: {
                this.stepToSelectStep();
                break;
            }
            case 1: {
                this.stepToModuleDetailsStep();
                break;
            }
            case 2: {
                this.stepToProtocolSelectionStep();
                break;
            }
            case 3: {
                this.stepToDvrSupportStep();
            }
        }
    }

    public void next() {
        switch (this.currentStep) {
            case 0: {
                this.validateModuleDetail();
                this.stepToProtocolSelectionStep();
                break;
            }
            case 1: {
                this.stepToDvrSupportStep();
                break;
            }
            case 2: {
                this.stepToCameraOperationsStep();
            }
        }
    }

    public boolean finish() {
        this.saveOpt();
        this.shell.enterBusy();
        try {
            this.generateFiles();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            BDialog.error((BWidget)this.shell, (String)"Error", (Object)"Cannot create new driver", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.shell.exitBusy();
        }
    }

    private void generateFiles() throws Exception {
        this.initCodeGenerator();
        boolean hasWb = true;
        FilePath path = new FilePath(this.moduleDir.getText()).merge(this.moduleName());
        BFileSystem fs = BFileSystem.INSTANCE;
        fs.makeDir(path, null);
        this.rtPath = path.merge(this.moduleName() + "-rt");
        fs.makeDir(this.rtPath, null);
        if (hasWb) {
            this.wbPath = path.merge(this.moduleName() + "-wb");
        }
        NewModuleWizard.createRootGradleFiles((FilePath)new FilePath(this.moduleDir.getText()), (String)this.vendor.getText(), (String)this.version.getText());
        BIFile build = fs.makeFile(this.rtPath.merge(this.moduleName() + "-rt.gradle"), null);
        this.doGradle(new XWriter(build.getOutputStream()), true, hasWb);
        if (hasWb) {
            build = fs.makeFile(this.wbPath.merge(this.moduleName() + "-wb.gradle"), null);
            this.doGradle(new XWriter(build.getOutputStream()), false, false);
        }
        this.writeFile("module-include.xml", this.rtPath);
        this.writeFile("module.palette", this.rtPath);
        if (hasWb) {
            BIFile include = fs.makeFile(this.wbPath.merge("module-include.xml"), null);
            this.doModuleIncludeWb(new XWriter(include.getOutputStream()));
        }
        BIFile permissions = fs.makeFile(this.rtPath.merge("module-permissions.xml"), null);
        this.doModulePermissions(permissions);
        if (hasWb) {
            permissions = fs.makeFile(this.wbPath.merge("module-permissions.xml"), null);
            this.doModulePermissions(permissions);
        }
        BIFile testInclude = fs.makeFile(this.rtPath.merge("moduleTest-include.xml"), null);
        this.doModuleTestInclude(new XWriter(testInclude.getOutputStream()), true);
        String basePackagePath = this.basePackage.getText();
        this.codegen("BNfooNetwork.template", basePackagePath, "B" + this.videoNetworkName + ".java", this.rtPath);
        String packUnitTest = "test." + this.basePackage.getText();
        this.codegen("BNfooVideoDriverTest.template", packUnitTest, "B" + this.basePrefix + "VideoDriverTest.java", this.rtPath, true);
        if (this.dvrSupportRequiredRadioBtn.isSelected()) {
            String dvrPackage = basePackagePath + ".dvr";
            this.dvrName = this.basePrefix + "Dvr";
            this.codegen("BNfooDvr.template", dvrPackage, "B" + this.dvrName + ".java", this.rtPath);
            this.codegen("BNfooDvrFolder.template", dvrPackage, "B" + this.dvrName + "Folder.java", this.rtPath);
            this.codegen("BNfooDvrId.template", dvrPackage, "B" + this.dvrName + "Id.java", this.rtPath);
            this.codegen("BNfooMultistreamPreferences.template", dvrPackage, "B" + this.basePrefix + "MultistreamPreferences.java", this.rtPath);
        }
        String cameraPackage = basePackagePath + ".camera";
        this.cameraName = this.basePrefix + "Camera";
        this.codegen("BNfooCamera.template", cameraPackage, "B" + this.cameraName + ".java", this.rtPath);
        this.codegen("BNfooCameraDeviceExt.template", cameraPackage, "B" + this.cameraName + "DeviceExt.java", this.rtPath);
        this.codegen("BNfooCameraDeviceId.template", cameraPackage, "B" + this.cameraName + "DeviceId.java", this.rtPath);
        if (this.dvrDiscoverySupportRequiredRadioBtn.isSelected()) {
            this.codegen("BNfooCameraDiscoveryLeaf.template", cameraPackage, "B" + this.cameraName + "DiscoveryLeaf.java", this.rtPath);
            this.codegen("BNfooCameraDiscoveryPreferences.template", cameraPackage, "B" + this.cameraName + "DiscoveryPreferences.java", this.rtPath);
        }
        this.codegen("BNfooCameraFolder.template", cameraPackage, "B" + this.cameraName + "Folder.java", this.rtPath);
        this.codegen("NfooVideoDecoder.template", basePackagePath + ".ui", this.basePrefix + "VideoDecoder.java", this.wbPath);
        this.codegen("BNfooVideoAgent.template", basePackagePath + ".ui", "B" + this.basePrefix + "VideoAgent.java", this.wbPath);
        if (this.dvrDisplaySupportRequiredRadioBtn.isSelected()) {
            String displayPackage = basePackagePath + ".display";
            this.displayName = this.basePrefix + "Display";
            this.codegen("BNfooVideoDisplay.template", displayPackage, "B" + this.displayName + ".java", this.rtPath);
            this.codegen("BNfooVideoDisplayMultistream.template", displayPackage, "B" + this.displayName + "Multistream.java", this.rtPath);
            this.codegen("NfooVideoDisplayController.template", displayPackage, this.displayName + "Controller.java", this.rtPath);
        }
        String eventPackage = basePackagePath + ".event";
        this.eventName = this.basePrefix + "Event";
        this.codegen("BNfooEventCameraExt.template", eventPackage, "B" + this.eventName + "CameraExt.java", this.rtPath);
        this.codegen("BNfooEventDiscoveryLeaf.template", eventPackage, "B" + this.eventName + "DiscoveryLeaf.java", this.rtPath);
        this.codegen("BNfooEventDiscoveryList.template", eventPackage, "B" + this.eventName + "DiscoveryList.java", this.rtPath);
        this.codegen("BNfooEventDiscoveryPreferences.template", eventPackage, "B" + this.eventName + "DiscoveryPreferences.java", this.rtPath);
        this.codegen("BNfooEventFolder.template", eventPackage, "B" + this.eventName + "Folder.java", this.rtPath);
        this.codegen("BNfooEventProxyExt.template", eventPackage, "B" + this.eventName + "ProxyExt.java", this.rtPath);
        this.codegen("BNfooVideoEventRecall.template", eventPackage, "B" + this.basePrefix + "VideoEventRecall.java", this.rtPath);
        String datatypesPackage = basePackagePath + ".datatypes";
        this.codegen("BNfooIpAddress.template", datatypesPackage, "B" + this.basePrefix + "IpAddress.java", this.rtPath);
        this.codegen("BNfooTimeSyncParams.template", datatypesPackage, "B" + this.basePrefix + "TimeSyncParams.java", this.rtPath);
        String enumsPackage = basePackagePath + ".enums";
        this.codegen("BNfooEventTypesEnum.template", enumsPackage, "B" + this.basePrefix + "EventTypesEnum.java", this.rtPath);
        if (this.dvrDisplaySupportRequiredRadioBtn.isSelected()) {
            this.codegen("BNfooDisplayLayoutTypesEnum.template", enumsPackage, "B" + this.basePrefix + "DisplayLayoutTypesEnum.java", this.rtPath);
        }
        if (this.httpCheckBox.isSelected()) {
            String utilPackage = basePackagePath + ".util";
            this.codegen("NfooHttpUtil.template", utilPackage, this.basePrefix + "HttpUtil.java", this.rtPath);
            this.codegen("NfooVideoStreamUtil.template", utilPackage, this.basePrefix + "VideoStreamUtil.java", this.rtPath);
        }
        String messagesPackage = basePackagePath + ".messages";
        if (this.panTiltCheckBox.isSelected()) {
            this.codegen("NfooPanTiltReq.template", messagesPackage, this.basePrefix + "PanTiltReq.java", this.rtPath);
        }
        if (this.focusCheckBox.isSelected()) {
            this.codegen("NfooFocusControlReq.template", messagesPackage, this.basePrefix + "FocusControlReq.java", this.rtPath);
        }
        this.shell.hyperlink(BOrd.make((BOrd)fs.getNavOrd(), (OrdQuery)path));
    }

    private void initCodeGenerator() {
        this.cg = new CodeGen();
        this.basePrefix = TextUtil.capitalize((String)this.moduleName());
        this.videoNetworkName = this.basePrefix + "Network";
        this.cg.put("basePrefix", this.basePrefix);
        this.cg.put("moduleName", this.moduleName());
        this.cg.put("preferredSymbol", this.prefSymbol.getText());
        this.cg.put("description", this.moduleDescription.getText());
        this.cg.put("package", this.basePackage.getText());
        this.cg.put("year", "" + Clock.time().getYear());
        this.cg.put("date", Clock.time().toDateString(null));
        this.cg.put("vendor", this.vendor.getText());
        this.cg.put("author", this.author.getText());
        this.cg.put("copyright", NewModuleWizard.getCopyrightStatement((String)this.vendor.getText()));
        this.cg.put("network.type", this.videoNetworkName);
        this.cg.put("network.class", "B" + this.videoNetworkName);
        this.cg.putif("network.hasHttpCommConfig", this.httpCheckBox.isSelected());
        this.cg.putif("network.hasTcpCommConfig", this.tcpCheckBox.isSelected());
        this.cg.putif("network.hasUdpCommConfig", this.udpCheckBox.isSelected());
        this.cg.putif("network.hasSerialCommConfig", this.serialCheckBox.isSelected());
        this.cg.putif("network.hasDvrSupport", this.dvrSupportRequiredRadioBtn.isSelected());
        this.cg.putif("network.hasCameraSupport", this.dvrSupportNotRequiredRadioBtn.isSelected());
        this.cg.putif("network.hasDvrDeviceFolder", this.dvrSupportRequiredRadioBtn.isSelected());
        this.cg.putif("network.hasCameraDeviceFolder", this.dvrSupportNotRequiredRadioBtn.isSelected());
        this.cg.put("dvr.type", this.dvrName);
        this.cg.put("dvr.class", "B" + this.dvrName);
        this.cg.putif("dvr.hasDisplaySupport", this.hasDisplaySupport());
        this.cg.putif("dvr.hasDiscoverySupport", this.dvrDiscoverySupportRequiredRadioBtn.isSelected());
        this.cg.putif("dvr.noDiscoverySupport", !this.dvrDiscoverySupportRequiredRadioBtn.isSelected());
        this.cg.putif("camera.hasPanTiltSupport", this.panTiltCheckBox.isSelected());
        this.cg.putif("camera.hasZoomSupport", this.zoomCheckBox.isSelected());
        this.cg.putif("camera.hasIrisSupport", this.irisCheckBox.isSelected());
        this.cg.putif("camera.hasFocusSupport", this.focusCheckBox.isSelected());
        this.cg.putif("camera.hasStorePresetsSupport", this.storePresetCheckBox.isSelected());
        this.cg.putif("camera.hasMoveToPresetSupport", this.moveToPresetCheckBox.isSelected());
    }

    private boolean hasDisplaySupport() {
        return this.dvrDisplaySupportRequiredRadioBtn.isSelected();
    }

    @Override
    protected void doGradleDependances(XWriter out, boolean rt) throws Exception {
        out.w((Object)"dependencies {\n");
        if (rt) {
            out.w((Object)"  compile \"Tridium:baja:4.0\" \n");
            out.w((Object)"  compile \"Tridium:nre:4.0\" \n");
            out.w((Object)"  compile \"Tridium:gx-rt:4.0\" \n");
            if (this.httpCheckBox.isSelected()) {
                out.w((Object)"  compile \"Tridium:net-rt:4.0\" \n");
            }
            out.w((Object)"  compile \"Tridium:alarm-rt:4.0\"\n");
            out.w((Object)"  compile \"Tridium:driver-rt:4.0\"\n");
            out.w((Object)"  compile \"Tridium:control-rt:4.0\"\n");
            out.w((Object)"  compile \"Tridium:nvideo-rt:4.0\"\n");
            out.w((Object)"  compile \"Tridium:ndriver-rt:4.0\"\n\n");
            out.w((Object)"  compile \"Tridium:videoDriver-rt:4.0\"\n\n");
        } else {
            out.w((Object)"  compile \"Tridium:baja:4.0\" \n");
            out.w((Object)"  compile \"Tridium:nre:4.0\" \n");
            out.w((Object)"  compile \"Tridium:gx-rt:4.0\" \n");
            out.w((Object)"  compile \"Tridium:gx-wb:4.0\" \n");
            out.w((Object)"  compile \"Tridium:bajaui-wb:4.0\" \n");
            out.w((Object)"  compile \"Tridium:alarm-rt:4.0\"\n");
            out.w((Object)"  compile \"Tridium:driver-wb:4.0\"\n");
            out.w((Object)"  compile \"Tridium:driver-rt:4.0\"\n");
            out.w((Object)"  compile \"Tridium:control-rt:4.0\"\n");
            out.w((Object)"  compile \"Tridium:ndriver-rt:4.0\"\n");
            out.w((Object)"  compile \"Tridium:ndriver-wb:4.0\"\n");
            out.w((Object)"  compile \"Tridium:nvideo-wb:4.0\"\n");
            out.w((Object)"  compile \"Tridium:ffmpeg-wb:4.0\"\n");
            out.w((Object)"  compile \"Tridium:workbench-wb:4.0\"\n");
            out.w((Object)"  compile \"Tridium:videoDriver-rt:4.0\"\n");
            out.w((Object)"  compile \"Tridium:videoDriver-wb:4.0\"\n");
            out.w((Object)("  compile project(\":" + this.moduleName() + "-rt\")\n"));
        }
        out.w((Object)"}\n\n");
    }

    private void doModuleIncludeWb(XWriter out) throws Exception {
        String pack = this.basePackage.getText();
        out.w((Object)"<!-- Types -->\n");
        out.w((Object)"<types>\n");
        String typNam = this.basePrefix + "VideoAgent";
        out.w((Object)"<type name=\"").w((Object)typNam).w((Object)"\" class=\"").w((Object)pack).w((Object)".ui.B").w((Object)typNam).w((Object)"\"/>\n");
        out.w((Object)"\n");
        out.w((Object)"</types>\n");
        out.close();
    }

    private void doModulePermissions(BIFile out) throws IOException {
        BIFile in = (BIFile)BOrd.make((String)"module://wbutil/rc/module-permissions.xml").get();
        try (OutputStream dest = out.getOutputStream();
             InputStream src = in.getInputStream();){
            FileUtil.pipe((InputStream)src, (OutputStream)dest);
        }
    }

    private void doModuleTestInclude(XWriter out, boolean rt) throws Exception {
        String module = this.moduleName() + ":";
        String packUnitTest = "test." + this.basePackage.getText();
        out.w((Object)"<!-- Types -->\n");
        out.w((Object)"<types>\n");
        out.w((Object)"\n");
        out.w((Object)"<!-- ").w((Object)packUnitTest).w((Object)" -->\n");
        out.w((Object)"<type name=\"").w((Object)(this.basePrefix + "VideoDriverTest")).w((Object)"\" class=\"").w((Object)packUnitTest).w((Object)".B").w((Object)(this.basePrefix + "VideoDriverTest")).w((Object)"\" />\n");
        out.w((Object)"\n");
        out.w((Object)"</types>\n");
        out.close();
    }

    private void writeFile(String fileName, FilePath fp) throws Exception {
        BFileSystem fs = BFileSystem.INSTANCE;
        BIFile in = (BIFile)BOrd.make((String)(codeTemplatesPath + fileName)).get();
        BIFile out = fs.makeFile(fp.merge(fileName));
        this.cg.process2(in.getInputStream(), out.getOutputStream());
    }

    public void codegen(String inFileName, String pack, String outFileName, FilePath fp) throws Exception {
        this.codegen(inFileName, pack, outFileName, fp, false);
    }

    public void codegen(String inFileName, String pack, String outFileName, FilePath fp, boolean isTest) throws Exception {
        BFileSystem fs = BFileSystem.INSTANCE;
        BIFile in = (BIFile)BOrd.make((String)(codeTemplatesPath + inFileName)).get();
        BIFile out = fs.makeFile(this.packageToPath(pack, fp, isTest).merge(outFileName));
        this.cg.process2(in.getInputStream(), out.getOutputStream());
    }

    public FilePath packageToPath(String pack, FilePath fp) {
        return this.packageToPath(pack, fp, false);
    }

    public FilePath packageToPath(String pack, FilePath fp, boolean isTest) {
        String[] s;
        FilePath p = !isTest ? fp.merge("src") : fp.merge("srcTest");
        for (String packPart : s = TextUtil.split((String)pack, (char)'.')) {
            p = p.merge(packPart);
        }
        return p;
    }

    public String getTitle() {
        return lex.getText("videoDriver.title");
    }

    class DvrSupportToggleCommandGroup<T extends ToggleCommand>
    extends ToggleCommandGroup<ToggleCommand> {
        DvrSupportToggleCommandGroup() {
        }

        protected void selected(ToggleCommand command) {
            super.selected(command);
            boolean dvrSupported = command.getLabel().equals(lex.getText("videoDriver.dvrSupportRequired"));
            NewVideoDriverWizard.this.dvrDiscoverySupportChoicePane.setVisible(dvrSupported);
            NewVideoDriverWizard.this.dvrDisplaySupportChoicePane.setVisible(dvrSupported);
        }
    }

    class PrefSymbolModel
    extends TextModel {
        PrefSymbolModel() {
        }

        protected void textModified() {
            String text = this.getText();
            String x = "";
            if (text != null) {
                x = text.trim();
            }
            if (x.length() == 0) {
                return;
            }
            boolean capitalize = Character.isUpperCase(x.charAt(0));
            x = TextUtil.fromFriendly((String)x);
            if (capitalize) {
                x = TextUtil.capitalize((String)x);
            }
            if (!x.equals(text)) {
                NewVideoDriverWizard.this.prefSymbol.setText(x);
            }
        }
    }

    class NameModel
    extends TextModel {
        NameModel() {
        }

        protected void textModified() {
            String text = this.getText();
            String x = "";
            if (text != null) {
                x = text.trim();
            }
            if (x.length() == 0) {
                return;
            }
            boolean capitalize = Character.isUpperCase(x.charAt(0));
            x = TextUtil.fromFriendly((String)x);
            if (capitalize) {
                x = TextUtil.capitalize((String)x);
            }
            if (!x.equals(text)) {
                NewVideoDriverWizard.this.moduleName.setText(x);
            }
        }
    }
}

