/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.wizards;

import com.tridium.devkit.codegen.CodeGen;
import com.tridium.devkit.wizards.DriverWizardModel;
import com.tridium.devkit.wizards.NewDriverWizard2;
import com.tridium.workbench.tools.NewModuleWizard;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.Size;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.workbench.BWbShell;
import javax.baja.xml.XWriter;

public class NewNDriverWizard
extends DriverWizardModel {
    CodeGen cg = null;
    BWidget step3ProtocolSelection;
    BCheckBox httpCheckBox = new BCheckBox("HTTP");
    BCheckBox tcpCheckBox = new BCheckBox("TCP/IP");
    BCheckBox udpCheckBox = new BCheckBox("UDP/IP");
    BCheckBox serialCheckBox = new BCheckBox("Serial");
    BCheckBox processUnsolicited = new BCheckBox("Process unsolicited messages");
    BWidget step4Names;
    BTextField classPrefix = new BTextField("", 25);
    BTextField network = new BTextField("", 25);
    BTextField device = new BTextField("", 25);
    BTextField deviceFolder = new BTextField("", 25);
    BCheckBox customDevMgr;
    BLabel deviceManagerLabel = new BLabel("DeviceManager");
    BTextField deviceManager = new BTextField("", 25);
    BCheckBox deviceManagerDiscovery = new BCheckBox("DeviceManager supports discovery");
    BWidget step5Points;
    BCheckBox points;
    BTextField pointDeviceExt = new BTextField("", 25);
    BTextField pointFolder = new BTextField("", 25);
    BTextField proxyExt = new BTextField("", 25);
    BCheckBox customPntMgr;
    BLabel pointManagerLabel = new BLabel("PointManager");
    BTextField pointManager = new BTextField("", 25);
    BCheckBox pointManagerDiscovery = new BCheckBox("PointManager supports discovery");
    FilePath rtPath = null;
    FilePath wbPath = null;
    private String crString;

    public NewNDriverWizard(BWbShell shell, NewDriverWizard2 drvWizard) {
        super(shell, drvWizard);
        this.customDevMgr = new BCheckBox((ToggleCommand)new DevMgrToggle((BWidget)shell, "Custom Device Manager"));
        this.customPntMgr = new BCheckBox((ToggleCommand)new PntMgrToggle((BWidget)shell, "Custom Point Manager"));
        this.points = new BCheckBox((ToggleCommand)new PointToggle((BWidget)shell, "Point Device Ext"));
        this.customDevMgr.setSelected(false);
        this.customPntMgr.setSelected(false);
        this.deviceManagerDiscovery.setSelected(false);
        this.pointManagerDiscovery.setSelected(true);
        this.buildModuleDetailsStep(this.getTitle(), NewDriverWizard2.lexStepXofY(2, 5));
        this.buildProtocolSelectionStep(3, 5);
        this.buildNamesStep(4, 5);
        this.buildPoints(5, 5);
    }

    private void buildProtocolSelectionStep(int tab, int maxTab) {
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), NewDriverWizard2.lexStepXofY(tab, maxTab)));
        BGridPane a = new BGridPane(1);
        a.setHalign(BHalign.left);
        a.setValign(BValign.top);
        a.add(null, (BValue)new BLabel(lex.getText("driver.selectProtocols")));
        a.add(null, (BValue)this.httpCheckBox);
        a.add(null, (BValue)this.tcpCheckBox);
        a.add(null, (BValue)this.udpCheckBox);
        a.add(null, (BValue)this.serialCheckBox);
        a.add(null, (BValue)new BLabel(" "));
        a.add(null, (BValue)this.processUnsolicited);
        edge.setCenter((BWidget)new BBorderPane((BWidget)a, 10.0, 10.0, 10.0, 10.0));
        this.step3ProtocolSelection = edge;
    }

    private void buildNamesStep(int tab, int maxTab) {
        this.classPrefix.setModel((TextModel)new MasterModel());
        BGridPane a = new BGridPane(2);
        a.setHalign(BHalign.left);
        a.setValign(BValign.top);
        a.add(null, (BValue)new BLabel("Class Prefix"));
        a.add(null, (BValue)this.classPrefix);
        a.add(null, (BValue)new BLabel("DeviceNetwork"));
        a.add(null, (BValue)this.network);
        a.add(null, (BValue)new BLabel("Device"));
        a.add(null, (BValue)this.device);
        a.add(null, (BValue)new BLabel("DeviceFolder"));
        a.add(null, (BValue)this.deviceFolder);
        a.add(null, (BValue)new BLabel(" "));
        a.add(null, (BValue)new BLabel(""));
        a.add(null, (BValue)this.customDevMgr);
        a.add(null, (BValue)new BLabel(""));
        a.add(null, (BValue)this.deviceManagerLabel);
        a.add(null, (BValue)this.deviceManager);
        a.add(null, (BValue)new BLabel(" "));
        a.add(null, (BValue)new BLabel(""));
        a.add(null, (BValue)this.deviceManagerDiscovery);
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), NewDriverWizard2.lexStepXofY(tab, maxTab)));
        edge.setCenter((BWidget)new BBorderPane((BWidget)a, 10.0, 10.0, 10.0, 10.0));
        this.step4Names = edge;
    }

    public void setInitialTypes() {
        this.initTypes("testNDriver");
    }

    private void initTypes(String x) {
        x = TextUtil.capitalize((String)x);
        this.classPrefix.setText(x);
        this.network.setText(x + "Network");
        this.device.setText(x + "Device");
        this.deviceFolder.setText(x + "DeviceFolder");
        this.deviceManager.setText(x + "DeviceManager");
        this.pointDeviceExt.setText(x + "PointDeviceExt");
        this.pointFolder.setText(x + "PointFolder");
        this.proxyExt.setText(x + "ProxyExt");
        this.pointManager.setText(x + "PointManager");
    }

    private void buildPoints(int tab, int maxTab) {
        BGridPane a = new BGridPane(2);
        a.setHalign(BHalign.left);
        a.setValign(BValign.top);
        a.add(null, (BValue)this.points);
        a.add(null, (BValue)new BLabel(""));
        a.add(null, (BValue)new BLabel("PointDeviceExt"));
        a.add(null, (BValue)this.pointDeviceExt);
        a.add(null, (BValue)new BLabel("PointFolder"));
        a.add(null, (BValue)this.pointFolder);
        a.add(null, (BValue)new BLabel("ProxyExt"));
        a.add(null, (BValue)this.proxyExt);
        a.add(null, (BValue)new BLabel(" "));
        a.add(null, (BValue)new BLabel(""));
        a.add(null, (BValue)this.customPntMgr);
        a.add(null, (BValue)new BLabel(""));
        a.add(null, (BValue)this.pointManagerLabel);
        a.add(null, (BValue)this.pointManager);
        a.add(null, (BValue)new BLabel(" "));
        a.add(null, (BValue)new BLabel(""));
        a.add(null, (BValue)this.pointManagerDiscovery);
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), NewDriverWizard2.lexStepXofY(tab, maxTab)));
        edge.setCenter((BWidget)new BBorderPane((BWidget)a, 10.0, 10.0, 10.0, 10.0));
        this.step5Points = edge;
    }

    public String getTitle() {
        return lex.getText("ndriver.title");
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(490.0, 320.0);
    }

    public void init() {
        this.stepToTab0();
    }

    public void back() {
        switch (this.currentStep) {
            case 0: {
                this.stepToSelectStep();
                break;
            }
            case 1: {
                this.stepToTab0();
                break;
            }
            case 2: {
                this.stepToTab1();
                break;
            }
            case 3: {
                this.stepToTab2();
            }
        }
    }

    public void next() {
        switch (this.currentStep) {
            case 0: {
                this.validateModuleDetail();
                this.initTypes(this.moduleName());
                this.stepToTab1();
                break;
            }
            case 1: {
                this.stepToTab2();
                break;
            }
            case 2: {
                this.stepToTab3();
            }
        }
    }

    public boolean finish() {
        this.saveOpt();
        this.shell.enterBusy();
        try {
            this.generateFiles();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            BDialog.error((BWidget)this.shell, (String)"Error", (Object)"Cannot create new driver", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.shell.exitBusy();
        }
    }

    private void stepToTab0() {
        this.update(this.step0, this.driverWizard == null ? 2 : 3);
        this.getWizard().setNextAsDefault();
        this.moduleDir.requestFocus();
        this.currentStep = 0;
    }

    private void stepToTab1() {
        this.update(this.step3ProtocolSelection, 3);
        this.serialCheckBox.requestFocus();
        this.currentStep = 1;
    }

    private void stepToTab2() {
        this.update(this.step4Names, 3);
        this.points.requestFocus();
        this.currentStep = 2;
    }

    private void stepToTab3() {
        this.update(this.step5Points, 5);
        this.points.requestFocus();
        this.currentStep = 3;
    }

    private String defaultPrefix() {
        return TextUtil.capitalize((String)NewNDriverWizard.formatString(this.classPrefix.getText(), "foo"));
    }

    private void generateFiles() throws Exception {
        this.initCodeGen();
        boolean hasWb = this.customDevMgr.isSelected() || this.points.isSelected() && this.customPntMgr.isSelected();
        FilePath path = new FilePath(this.moduleDir.getText()).merge(this.moduleName());
        BFileSystem fs = BFileSystem.INSTANCE;
        fs.makeDir(path, null);
        this.rtPath = path.merge(this.moduleName() + "-rt");
        fs.makeDir(this.rtPath, null);
        if (hasWb) {
            this.wbPath = path.merge(this.moduleName() + "-wb");
        }
        this.crString = NewModuleWizard.getCopyrightStatement((String)this.vendor.getText());
        NewModuleWizard.createRootGradleFiles((FilePath)new FilePath(this.moduleDir.getText()), (String)this.vendor.getText(), (String)this.version.getText());
        BIFile build = fs.makeFile(this.rtPath.merge(this.moduleName() + "-rt.gradle"), null);
        this.doGradle(new XWriter(build.getOutputStream()), true, hasWb);
        if (hasWb) {
            build = fs.makeFile(this.wbPath.merge(this.moduleName() + "-wb.gradle"), null);
            this.doGradle(new XWriter(build.getOutputStream()), false, false);
        }
        BIFile include = fs.makeFile(this.rtPath.merge("module-include.xml"), null);
        this.doModuleInclude(new XWriter(include.getOutputStream()), true);
        if (hasWb) {
            include = fs.makeFile(this.wbPath.merge("module-include.xml"), null);
            this.doModuleInclude(new XWriter(include.getOutputStream()), false);
        }
        BIFile palette = fs.makeFile(this.rtPath.merge("module.palette"), null);
        this.doPalette(new XWriter(palette.getOutputStream()));
        BIFile permissions = fs.makeFile(this.rtPath.merge("module-permissions.xml"), null);
        this.doModulePermissions(permissions);
        if (hasWb) {
            permissions = fs.makeFile(this.wbPath.merge("module-permissions.xml"), null);
            this.doModulePermissions(permissions);
        }
        BIFile testInclude = fs.makeFile(this.rtPath.merge("moduleTest-include.xml"), null);
        this.doModuleTestInclude(new XWriter(testInclude.getOutputStream()), true);
        String pack = this.basePackage.getText();
        String packUi = pack + ".ui";
        this.codegen("BNfooNetwork.template", pack, this.toClassName(this.network), this.rtPath);
        this.codegen("BNfooDevice.template", pack, this.toClassName(this.device), this.rtPath);
        this.codegen("BNfooDeviceFolder.template", pack, this.toClassName(this.deviceFolder), this.rtPath);
        if (this.customDevMgr.isSelected()) {
            this.codegen("BNfooDeviceManager.template", packUi, this.toClassName(this.deviceManager), this.wbPath);
        }
        pack = this.basePackage.getText() + ".message";
        this.codegen("NfooMessage.template", pack, this.defaultPrefix() + "Message.java", this.rtPath);
        this.codegen("NfooMessageFactory.template", pack, this.defaultPrefix() + "MessageFactory.java", this.rtPath);
        pack = this.basePackage.getText() + ".comm";
        if (this.serialCheckBox.isSelected()) {
            this.codegen("BNfooSerialCommConfig.template", pack, "B" + this.defaultPrefix() + "SerialCommConfig.java", this.rtPath);
            this.codegen("NfooSerialLinkMessage.template", pack, this.serialLinkMsg() + ".java", this.rtPath);
        }
        if (this.tcpCheckBox.isSelected()) {
            this.codegen("BNfooTcpCommConfig.template", pack, "B" + this.defaultPrefix() + "TcpCommConfig.java", this.rtPath);
            this.codegen("NfooTcpLinkMessage.template", pack, this.tcpLinkMsg() + ".java", this.rtPath);
        }
        if (this.processUnsolicited.isSelected()) {
            this.codegen("NfooListener.template", pack, this.defaultPrefix() + "Listener.java", this.rtPath);
        }
        if (this.deviceManagerDiscovery.isSelected()) {
            pack = this.basePackage.getText() + ".learn";
            if (this.customDevMgr.isSelected()) {
                this.codegen("BNfooLearnDeviceEntry.template", pack, "B" + this.defaultPrefix() + "LearnDeviceEntry.java", this.rtPath);
                this.codegen("BNfooLearnDevicesJob.template", pack, "B" + this.defaultPrefix() + "LearnDevicesJob.java", this.rtPath);
            } else {
                this.codegen("BNfooDeviceDiscoveryPreferences.template", pack, "B" + this.defaultPrefix() + "DeviceDiscoveryPreferences.java", this.rtPath);
                this.codegen("BNfooDeviceDiscoveryLeaf.template", pack, "B" + this.defaultPrefix() + "DeviceDiscoveryLeaf.java", this.rtPath);
            }
        }
        if (this.points.isSelected()) {
            pack = this.basePackage.getText() + ".point";
            this.codegen("BNfooPointDeviceExt.template", pack, this.toClassName(this.pointDeviceExt), this.rtPath);
            this.codegen("BNfooPointFolder.template", pack, this.toClassName(this.pointFolder), this.rtPath);
            this.codegen("BNfooProxyExt.template", pack, this.toClassName(this.proxyExt), this.rtPath);
            if (this.customPntMgr.isSelected()) {
                this.codegen("BNfooPointManager.template", packUi, this.toClassName(this.pointManager), this.wbPath);
            }
            if (this.isAutoPointDiscover()) {
                this.codegen("BNfooPointDiscoveryPreferences.template", pack, "B" + this.defaultPrefix() + "PointDiscoveryPreferences.java", this.rtPath);
                this.codegen("BNfooPointDiscoveryLeaf.template", pack, "B" + this.defaultPrefix() + "PointDiscoveryLeaf.java", this.rtPath);
            }
        }
        String packUnitTest = "test." + this.basePackage.getText();
        String className = "B" + this.defaultPrefix() + "NMessageTest";
        this.codegen("BNfooDeviceTest.template", packUnitTest, className, className + ".java", this.rtPath, true);
        if (this.pointManagerDiscovery.isSelected()) {
            className = "B" + this.defaultPrefix() + "PointDiscoveryExtTest";
            this.codegen("BNfooDeviceTest.template", packUnitTest, className, className + ".java", this.rtPath, true);
        }
        if (this.deviceManagerDiscovery.isSelected()) {
            className = "B" + this.defaultPrefix() + "NetworkTest";
            this.codegen("BNfooDeviceTest.template", packUnitTest, className, className + ".java", this.rtPath, true);
        }
        this.shell.hyperlink(BOrd.make((BOrd)fs.getNavOrd(), (OrdQuery)path));
    }

    private String toClassName(BTextField f) {
        return "B" + f.getText() + ".java";
    }

    @Override
    protected void doGradleDependances(XWriter out, boolean rt) throws Exception {
        out.w((Object)"dependencies {\n");
        if (rt) {
            out.w((Object)"  compile \"Tridium:baja:4.0\" \n  compile \"Tridium:nre:4.0\" \n  compile \"Tridium:alarm-rt:4.0\"\n  compile \"Tridium:driver-rt:4.0\"\n  compile \"Tridium:control-rt:4.0\"\n  compile \"Tridium:ndriver-rt:4.0\"\n\n");
        } else {
            out.w((Object)("  compile \"Tridium:baja:4.0\" \n  compile \"Tridium:nre:4.0\" \n  compile \"Tridium:gx-rt:4.0\" \n  compile \"Tridium:gx-wb:4.0\" \n  compile \"Tridium:bajaui-wb:4.0\" \n  compile \"Tridium:alarm-rt:4.0\"\n  compile \"Tridium:driver-wb:4.0\"\n  compile \"Tridium:driver-rt:4.0\"\n  compile \"Tridium:control-rt:4.0\"\n  compile \"Tridium:ndriver-rt:4.0\"\n  compile \"Tridium:ndriver-wb:4.0\"\n  compile \"Tridium:workbench-wb:4.0\"\n  compile project(\":" + this.moduleName() + "-rt\")\n"));
        }
        out.w((Object)"}\n\n");
    }

    private void doModuleInclude(XWriter out, boolean rt) throws Exception {
        String module = this.moduleName() + ":";
        String pack = this.basePackage.getText();
        out.w((Object)"<!--\n");
        out.w((Object)("  " + this.crString + "\n"));
        out.w((Object)" -->\n");
        out.w((Object)"<!-- Types -->\n");
        out.w((Object)"<types>\n");
        out.w((Object)"\n");
        out.w((Object)"<!-- ").w((Object)pack).w((Object)" -->\n");
        if (rt) {
            out.w((Object)"<type name=\"").w((Object)this.network.getText()).w((Object)"\" class=\"").w((Object)pack).w((Object)".B").w((Object)this.network.getText()).w((Object)"\" />\n");
            out.w((Object)"<type name=\"").w((Object)this.device.getText()).w((Object)"\" class=\"").w((Object)pack).w((Object)".B").w((Object)this.device.getText()).w((Object)"\" />\n");
            out.w((Object)"<type name=\"").w((Object)this.deviceFolder.getText()).w((Object)"\" class=\"").w((Object)pack).w((Object)".B").w((Object)this.deviceFolder.getText()).w((Object)"\" />\n");
            if (this.serialCheckBox.isSelected()) {
                out.w((Object)"\n");
                out.w((Object)"<!-- ").w((Object)pack).w((Object)".comm -->\n");
                out.w((Object)"<type name=\"").w((Object)this.defaultPrefix()).w((Object)"SerialCommConfig").w((Object)"\" class=\"").w((Object)pack).w((Object)".comm.B").w((Object)this.defaultPrefix()).w((Object)"SerialCommConfig").w((Object)"\" />\n");
            }
            if (this.deviceManagerDiscovery.isSelected()) {
                out.w((Object)"\n");
                out.w((Object)"<!-- ").w((Object)pack).w((Object)".learn -->\n");
                if (this.customDevMgr.isSelected()) {
                    out.w((Object)"<type name=\"").w((Object)this.defaultPrefix()).w((Object)"LearnDeviceEntry").w((Object)"\" class=\"").w((Object)pack).w((Object)".learn.B").w((Object)this.defaultPrefix()).w((Object)"LearnDeviceEntry").w((Object)"\" />\n");
                    out.w((Object)"<type name=\"").w((Object)this.defaultPrefix()).w((Object)"LearnDevicesJob").w((Object)"\" class=\"").w((Object)pack).w((Object)".learn.B").w((Object)this.defaultPrefix()).w((Object)"LearnDevicesJob").w((Object)"\" />\n");
                } else {
                    out.w((Object)"<type name=\"").w((Object)this.defaultPrefix()).w((Object)"DeviceDiscoveryPreferences").w((Object)"\" class=\"").w((Object)pack).w((Object)".learn.B").w((Object)this.defaultPrefix()).w((Object)"DeviceDiscoveryPreferences").w((Object)"\" />\n");
                    out.w((Object)"<type name=\"").w((Object)this.defaultPrefix()).w((Object)"DeviceDiscoveryLeaf").w((Object)"\" class=\"").w((Object)pack).w((Object)".learn.B").w((Object)this.defaultPrefix()).w((Object)"DeviceDiscoveryLeaf").w((Object)"\" />\n");
                }
            }
            if (this.points.isSelected()) {
                out.w((Object)"\n");
                out.w((Object)"<!-- ").w((Object)pack).w((Object)".point -->\n");
                out.w((Object)"<type name=\"").w((Object)this.pointDeviceExt.getText()).w((Object)"\" class=\"").w((Object)pack).w((Object)".point.B").w((Object)this.pointDeviceExt.getText()).w((Object)"\" />\n");
                out.w((Object)"<type name=\"").w((Object)this.pointFolder.getText()).w((Object)"\" class=\"").w((Object)pack).w((Object)".point.B").w((Object)this.pointFolder.getText()).w((Object)"\" />\n");
                out.w((Object)"<type name=\"").w((Object)this.proxyExt.getText()).w((Object)"\" class=\"").w((Object)pack).w((Object)".point.B").w((Object)this.proxyExt.getText()).w((Object)"\" />\n");
                if (this.isAutoPointDiscover()) {
                    out.w((Object)"<type name=\"").w((Object)this.defaultPrefix()).w((Object)"PointDiscoveryPreferences").w((Object)"\" class=\"").w((Object)pack).w((Object)".point.B").w((Object)this.defaultPrefix()).w((Object)"PointDiscoveryPreferences").w((Object)"\" />\n");
                    out.w((Object)"<type name=\"").w((Object)this.defaultPrefix()).w((Object)"PointDiscoveryLeaf").w((Object)"\" class=\"").w((Object)pack).w((Object)".point.B").w((Object)this.defaultPrefix()).w((Object)"PointDiscoveryLeaf").w((Object)"\" />\n");
                }
            }
        } else {
            boolean custPnt;
            boolean custDev = this.customDevMgr.isSelected();
            boolean bl = custPnt = this.points.isSelected() && this.customPntMgr.isSelected();
            if (custDev || custPnt) {
                out.w((Object)"\n");
                out.w((Object)"<!-- ").w((Object)pack).w((Object)".ui -->\n");
                if (custDev) {
                    out.w((Object)"<type name=\"").w((Object)this.deviceManager.getText()).w((Object)"\" class=\"").w((Object)pack).w((Object)".ui.B").w((Object)this.deviceManager.getText()).w((Object)"\" >\n").w((Object)"  <agent>\n").w((Object)"    <on type=\"").w((Object)module).w((Object)this.network.getText()).w((Object)"\"/>\n").w((Object)"    <on type=\"").w((Object)module).w((Object)this.deviceFolder.getText()).w((Object)"\"/>\n").w((Object)"  </agent>\n").w((Object)"</type>\n");
                }
                if (custPnt) {
                    out.w((Object)"<type name=\"").w((Object)this.pointManager.getText()).w((Object)"\" class=\"").w((Object)pack).w((Object)".ui.B").w((Object)this.pointManager.getText()).w((Object)"\" >\n").w((Object)"  <agent>\n").w((Object)"    <on type=\"").w((Object)module).w((Object)this.pointDeviceExt.getText()).w((Object)"\"/>\n").w((Object)"    <on type=\"").w((Object)module).w((Object)this.pointFolder.getText()).w((Object)"\"/>\n").w((Object)"  </agent>\n").w((Object)"</type>\n");
                }
            }
        }
        out.w((Object)"\n");
        out.w((Object)"</types>\n");
        out.close();
    }

    private void doModuleTestInclude(XWriter out, boolean rt) throws Exception {
        String module = this.moduleName() + ":";
        String packUnitTest = "test." + this.basePackage.getText();
        out.w((Object)"<!--\n");
        out.w((Object)("  " + this.crString + "\n"));
        out.w((Object)" -->\n");
        out.w((Object)"<!-- Types -->\n");
        out.w((Object)"<types>\n");
        out.w((Object)"\n");
        out.w((Object)"<!-- ").w((Object)packUnitTest).w((Object)" -->\n");
        out.w((Object)"<type name=\"").w((Object)(this.classPrefix.getText() + "NMessageTest")).w((Object)"\" class=\"").w((Object)packUnitTest).w((Object)".B").w((Object)(this.classPrefix.getText() + "NMessageTest")).w((Object)"\" />\n");
        if (this.pointManagerDiscovery.isSelected()) {
            out.w((Object)"<type name=\"").w((Object)(this.classPrefix.getText() + "PointDiscoveryExtTest")).w((Object)"\" class=\"").w((Object)packUnitTest).w((Object)".B").w((Object)(this.classPrefix.getText() + "PointDiscoveryExtTest")).w((Object)"\" />\n");
        }
        if (this.deviceManagerDiscovery.isSelected()) {
            out.w((Object)"<type name=\"").w((Object)(this.classPrefix.getText() + "NetworkTest")).w((Object)"\" class=\"").w((Object)packUnitTest).w((Object)".B").w((Object)(this.classPrefix.getText() + "NetworkTest")).w((Object)"\" />\n");
        }
        out.w((Object)"\n");
        out.w((Object)"</types>\n");
        out.close();
    }

    private void doModulePermissions(BIFile out) throws IOException {
        BIFile in = (BIFile)BOrd.make((String)"module://wbutil/rc/module-permissions.xml").get();
        try (OutputStream dest = out.getOutputStream();
             InputStream src = in.getInputStream();){
            dest.write("<!--\n".getBytes());
            dest.write(("  " + this.crString + "\n").getBytes());
            dest.write(" -->\n".getBytes());
            FileUtil.pipe((InputStream)src, (OutputStream)dest);
        }
    }

    private void doPalette(XWriter out) throws Exception {
        out.w((Object)"<!--\n");
        out.w((Object)("  " + this.crString + "\n"));
        out.w((Object)" -->\n");
        out.w((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.w((Object)"<bajaObjectGraph version=\"1.0\">\n");
        out.w((Object)"<p m=\"b=baja\" t=\"b:UnrestrictedFolder\">\n");
        out.w((Object)"\n");
        out.w((Object)" <p n=\"").w((Object)this.network.getText()).w((Object)"\" m=\"x=").w((Object)this.moduleName()).w((Object)"\" t=\"x:").w((Object)this.network.getText()).w((Object)"\"/>\n");
        out.w((Object)" <p n=\"").w((Object)this.device.getText()).w((Object)"\" t=\"x:").w((Object)this.device.getText()).w((Object)"\"/>\n");
        out.w((Object)" <p n=\"").w((Object)this.deviceFolder.getText()).w((Object)"\" t=\"x:").w((Object)this.deviceFolder.getText()).w((Object)"\"/>\n");
        if (this.points.isSelected()) {
            out.w((Object)"\n");
            out.w((Object)" <p n=\"").w((Object)this.pointFolder.getText()).w((Object)"\" t=\"x:").w((Object)this.pointFolder.getText()).w((Object)"\"/>\n");
        }
        out.w((Object)"\n");
        out.w((Object)"</p>\n");
        out.w((Object)"</bajaObjectGraph>\n");
        out.close();
    }

    private void initCodeGen() {
        this.cg = new CodeGen();
        this.cg.put("moduleName", this.moduleName());
        this.cg.put("basePrefix", this.defaultPrefix());
        this.cg.put("package", this.basePackage.getText());
        this.cg.put("year", "" + Clock.time().getYear());
        this.cg.put("date", Clock.time().toDateString(null));
        this.cg.put("vendor", this.vendor.getText());
        this.cg.put("author", this.author.getText());
        this.cg.put("network.type", this.network.getText());
        this.cg.put("network.class", "B" + this.network.getText());
        this.cg.put("device.type", this.device.getText());
        this.cg.put("device.class", "B" + this.device.getText());
        this.cg.put("deviceFolder.type", this.deviceFolder.getText());
        this.cg.put("deviceFolder.class", "B" + this.deviceFolder.getText());
        this.cg.put("deviceManager.type", this.deviceManager.getText());
        this.cg.put("deviceManager.class", "B" + this.deviceManager.getText());
        this.cg.put("copyright", NewModuleWizard.getCopyrightStatement((String)this.vendor.getText()));
        this.cg.putif("network.hasHttpCommConfig", this.httpCheckBox.isSelected());
        this.cg.putif("network.hasTcpCommConfig", this.tcpCheckBox.isSelected());
        this.cg.putif("network.hasUdpCommConfig", this.udpCheckBox.isSelected());
        this.cg.putif("network.hasSerialCommConfig", this.serialCheckBox.isSelected());
        this.cg.putif("noSerial", !this.serialCheckBox.isSelected());
        this.cg.put("serialLinkMsg", this.serialLinkMsg());
        this.cg.put("tcpLinkMsg", this.tcpLinkMsg());
        this.cg.putif("processUnsolicited", this.processUnsolicited.isSelected());
        this.cg.putif("httpListner", this.processUnsolicited.isSelected() && this.httpCheckBox.isSelected());
        this.cg.putif("tcpListner", this.processUnsolicited.isSelected() && this.tcpCheckBox.isSelected());
        this.cg.putif("udpListner", this.processUnsolicited.isSelected() && this.udpCheckBox.isSelected());
        this.cg.putif("serialListner", this.processUnsolicited.isSelected() && this.serialCheckBox.isSelected());
        this.cg.put("learnDeviceEntry.type", this.defaultPrefix() + "LearnDeviceEntry");
        this.cg.put("learnDeviceEntry.class", "B" + this.defaultPrefix() + "LearnDeviceEntry");
        this.cg.put("learnDevicesJob.class", "B" + this.defaultPrefix() + "LearnDevicesJob");
        this.cg.putif("deviceManagerLearn", this.customDevMgr.isSelected() && this.deviceManagerDiscovery.isSelected());
        this.cg.putif("autoDeviceLearn", !this.customDevMgr.isSelected() && this.deviceManagerDiscovery.isSelected());
        this.cg.putif("points", this.points.isSelected());
        this.cg.put("pointDeviceExt.type", this.pointDeviceExt.getText());
        this.cg.put("pointDeviceExt.class", "B" + this.pointDeviceExt.getText());
        this.cg.put("pointFolder.type", this.pointFolder.getText());
        this.cg.put("pointFolder.class", "B" + this.pointFolder.getText());
        this.cg.put("proxyExt.type", this.proxyExt.getText());
        this.cg.put("proxyExt.class", "B" + this.proxyExt.getText());
        this.cg.put("pointManager.type", this.pointManager.getText());
        this.cg.put("pointManager.class", "B" + this.pointManager.getText());
        this.cg.putif("pointManager.custom", this.customPntMgr.isSelected());
        this.cg.putif("autoPointDiscover", this.isAutoPointDiscover());
        this.cg.putif("usePntDevExt", !this.isAutoPointDiscover());
        this.cg.putif("addNPntMgr", !this.customPntMgr.isSelected() && !this.pointManagerDiscovery.isSelected());
    }

    private boolean isAutoPointDiscover() {
        return this.points.isSelected() && !this.customPntMgr.isSelected() && this.pointManagerDiscovery.isSelected();
    }

    private String serialLinkMsg() {
        return this.defaultPrefix() + (this.tcpCheckBox.isSelected() ? "SerialLinkMessage" : "LinkMessage");
    }

    private String tcpLinkMsg() {
        return this.defaultPrefix() + (this.serialCheckBox.isSelected() ? "TcpLinkMessage" : "LinkMessage");
    }

    private void codegen(String inFileName, String pack, String outFileName, FilePath fp) throws Exception {
        this.codegen(inFileName, pack, outFileName, fp, false);
    }

    private void codegen(String inFileName, String pack, String className, String outFileName, FilePath fp, boolean isTest) throws Exception {
        this.cg.put("className", className);
        this.codegen(inFileName, pack, outFileName, fp, isTest);
    }

    private void codegen(String inFileName, String pack, String outFileName, FilePath fp, boolean isTest) throws Exception {
        BFileSystem fs = BFileSystem.INSTANCE;
        BIFile in = (BIFile)BOrd.make((String)("module://devkit/templates/ndriver/" + inFileName)).get();
        BIFile out = fs.makeFile(this.packageToPath(pack, fp, isTest).merge(outFileName));
        this.cg.process(in.getInputStream(), out.getOutputStream());
    }

    public FilePath packageToPath(String pack, FilePath fpath) {
        return this.packageToPath(pack, fpath, false);
    }

    public FilePath packageToPath(String pack, FilePath fpath, boolean isTest) {
        FilePath p = !isTest ? fpath.merge("src") : fpath.merge("srcTest");
        String[] s = TextUtil.split((String)pack, (char)'.');
        for (int j = 0; j < s.length; ++j) {
            p = p.merge(s[j]);
        }
        return p;
    }

    class PntMgrToggle
    extends ToggleCommand {
        PntMgrToggle(BWidget owner, String label) {
            super(owner, label);
            this.setSelected(true);
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
            NewNDriverWizard.this.pointManager.setVisible(selected);
            NewNDriverWizard.this.pointManagerLabel.setVisible(selected);
            BWidget p = (BWidget)NewNDriverWizard.this.pointManager.getParent();
            if (p != null) {
                p.relayoutSync();
            }
        }
    }

    class PointToggle
    extends ToggleCommand {
        PointToggle(BWidget owner, String label) {
            super(owner, label);
            this.setSelected(true);
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
            NewNDriverWizard.this.pointDeviceExt.setEnabled(selected);
            NewNDriverWizard.this.pointFolder.setEnabled(selected);
            NewNDriverWizard.this.proxyExt.setEnabled(selected);
            NewNDriverWizard.this.pointManager.setEnabled(selected);
            NewNDriverWizard.this.customPntMgr.setEnabled(selected);
            NewNDriverWizard.this.pointManagerDiscovery.setEnabled(selected);
        }
    }

    class DevMgrToggle
    extends ToggleCommand {
        DevMgrToggle(BWidget owner, String label) {
            super(owner, label);
            this.setSelected(true);
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
            NewNDriverWizard.this.deviceManager.setVisible(selected);
            NewNDriverWizard.this.deviceManagerLabel.setVisible(selected);
            BWidget p = (BWidget)NewNDriverWizard.this.deviceManager.getParent();
            if (p != null) {
                p.relayoutSync();
            }
        }
    }

    class MasterModel
    extends TextModel {
        MasterModel() {
        }

        protected void textModified() {
            String x = TextUtil.capitalize((String)this.getText());
            NewNDriverWizard.this.network.setText(x + "Network");
            NewNDriverWizard.this.device.setText(x + "Device");
            NewNDriverWizard.this.deviceFolder.setText(x + "DeviceFolder");
            NewNDriverWizard.this.deviceManager.setText(x + "DeviceManager");
            NewNDriverWizard.this.pointDeviceExt.setText(x + "PointDeviceExt");
            NewNDriverWizard.this.pointFolder.setText(x + "PointFolder");
            NewNDriverWizard.this.proxyExt.setText(x + "ProxyExt");
            NewNDriverWizard.this.pointManager.setText(x + "PointManager");
        }
    }
}

