/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.util.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class NumberCompressor {
    public static int readInt(DataInput in) throws IOException {
        int n = 7;
        byte b = in.readByte();
        int result = b & 0x7F;
        while ((b & 0x80) != 0) {
            b = in.readByte();
            result |= (b & 0x7F) << n;
            n += 7;
        }
        return result;
    }

    public static long readLong(DataInput in) throws IOException {
        int n = 7;
        byte b = in.readByte();
        long result = b & 0x7F;
        while ((b & 0x80) != 0) {
            b = in.readByte();
            long v = (long)(b & 0x7F) << n;
            result |= v;
            n += 7;
        }
        return result;
    }

    public static void writeInt(DataOutput out, int value) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException(value + " is less than zero.");
        }
        while (value > 127) {
            out.writeByte(value & 0x7F | 0x80);
            value >>= 7;
        }
        out.writeByte(value);
    }

    public static void writeLong(DataOutput out, long value) throws IOException {
        if (value < 0L) {
            throw new IllegalArgumentException(value + " is less than zero.");
        }
        while (value > 127L) {
            out.writeByte((int)(value & 0x7FL | 0x80L));
            value >>= 7;
        }
        out.writeByte((int)value);
    }
}

