/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.util;

import com.tridium.util.CommandLineArguments;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TimeZone;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Sys;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;
import javax.baja.timezone.TimeZoneException;
import javax.baja.xml.XWriter;

public class ImportJRETimezones {
    public static void usage() {
        System.out.println("tzimport [-file:filepath] [-q] [-codegen:filepath] ");
        System.out.println("  -file   : The file that will be created containing the XML timezone definitions.");
        System.out.println("            If this option is omitted, <baja_home>\\rel\\lib\\timezones.xml is used.");
        System.out.println("            If the file already exists the command will fail.  To overwrite the");
        System.out.println("            file automatically, the -q option should be used.");
        System.out.println("  -o      : Overwrite the existing timezone xml file if it exists.");
        System.out.println("  -codegen: The file that will be created containing C timezone definitions.  If");
        System.out.println("            the file already exists, it will be overwritten.");
    }

    public static void main(String[] rawArgs) {
        File f;
        CommandLineArguments args = new CommandLineArguments(rawArgs);
        if (args.hasHelpOption()) {
            ImportJRETimezones.usage();
            return;
        }
        String[] ids = TimeZone.getAvailableIDs();
        TimeZone[] jreZones = new TimeZone[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            jreZones[i] = TimeZone.getTimeZone(ids[i]);
        }
        ArrayList<BTimeZone> temp = new ArrayList<BTimeZone>(jreZones.length);
        for (int i = 0; i < ids.length; ++i) {
            try {
                BTimeZone axZone = ImportJRETimezones.toAx(jreZones[i]);
                if (axZone == null) continue;
                temp.add(axZone);
                continue;
            }
            catch (TimeZoneException axZone) {
                // empty catch block
            }
        }
        Object[] zones = temp.toArray(new BTimeZone[temp.size()]);
        System.out.println(zones.length + " zones");
        SortUtil.sort((Object[])zones, (Object[])zones, (Comparator)new ZoneIdComparator());
        String tzfile = args.getOption("file", null);
        if (tzfile == null) {
            tzfile = Sys.getNiagaraHome() + "/lib/timezones.xml";
        }
        if ((f = new File(tzfile)).exists()) {
            if (args.hasOption("o")) {
                f.delete();
            } else {
                System.out.print("ERROR: The output file already exists (" + f.getAbsolutePath() + "). To overwrite");
                System.out.println(" automatically, use the -o option.");
                System.exit(0);
            }
        }
        try (XWriter out = new XWriter((OutputStream)new FileOutputStream(f));){
            ImportJRETimezones.writeXml(out, (BTimeZone[])zones);
            out.flush();
        }
        catch (IOException ioe) {
            System.err.println("Failed to write timezones to xml: " + ioe);
            ioe.printStackTrace();
            return;
        }
        System.out.println("Created " + f.getAbsolutePath());
        String codeFile = args.getOption("codegen", null);
        if (codeFile != null) {
            f = new File(codeFile);
            if (f.exists()) {
                f.delete();
            }
            try (PrintWriter pOut = new PrintWriter(new FileOutputStream(f));){
                ImportJRETimezones.writeC(pOut, (BTimeZone[])zones);
                pOut.flush();
            }
            catch (IOException ioe) {
                System.err.println("Failed to write C timezone definitions: " + ioe);
                ioe.printStackTrace();
                return;
            }
            System.out.println("Created " + f.getAbsolutePath());
        }
    }

    public static void writeXml(XWriter out, BTimeZone[] zones) throws IOException {
        out.w((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>").nl();
        out.nl();
        out.w((Object)"<!--").nl();
        out.w((Object)"\n  Time Zone Database\n").nl();
        out.w((Object)"  ");
        out.w((Object)new SimpleDateFormat("dd MMMMMMM yyyy").format(new Date()));
        out.w((Object)("   Auto-generated from " + System.getProperty("java.version") + " JRE")).nl();
        out.w((Object)"\n-->\n").nl();
        out.w((Object)"<timezonedb>").nl();
        HashSet<String> usedIds = new HashSet<String>();
        for (int i = 0; i < zones.length; ++i) {
            if (usedIds.contains(zones[i].getId())) continue;
            ImportJRETimezones.writeXml(out, zones[i], 2);
            usedIds.add(zones[i].getId());
        }
        out.w((Object)"</timezonedb>").nl();
    }

    public static void writeXml(XWriter out, BTimeZone zone, int indent) throws IOException {
        out.indent(indent);
        out.w((Object)"<zone ");
        out.w((Object)"id=\"");
        out.w((Object)zone.getId());
        out.w((Object)"\" utcOffset=\"");
        out.w((Object)ImportJRETimezones.formatRelTime(zone.getUtcOffset()));
        out.w((Object)"\"");
        out.w((Object)">").nl();
        String id = zone.getId();
        String stdName = zone.getDisplayName(false, null);
        String stdShort = zone.getShortDisplayName(false, null);
        String dstName = zone.getDisplayName(true, null);
        String dstShort = zone.getShortDisplayName(true, null);
        if (!(stdName.equals(id) && stdShort.equals(id) && (zone.getDaylightAdjustment() == 0 || dstName.equals(id) && dstShort.equals(id)))) {
            out.indent(indent += 2);
            out.w((Object)"<display");
            if (!stdName.equals(id)) {
                out.w(' ').attr("name", zone.getDisplayName(false, null));
            }
            if (!stdShort.equals(id)) {
                out.w(' ').attr("short", zone.getShortDisplayName(false, null));
            }
            if (zone.getDaylightAdjustment() != 0) {
                if (!dstName.equals(id)) {
                    out.w(' ').attr("dstName", zone.getDisplayName(true, null));
                }
                if (!dstShort.equals(id)) {
                    out.w(' ').attr("dstShort", zone.getShortDisplayName(true, null));
                }
            }
            out.w((Object)"/>").nl();
            indent -= 2;
        }
        if (zone.getDaylightAdjustment() != 0) {
            out.indent(indent += 2);
            out.w((Object)"<dst savings=\"");
            out.w((Object)ImportJRETimezones.formatRelTime(zone.getDaylightAdjustment()));
            out.w((Object)"\">").nl();
            ImportJRETimezones.writeDstRule(out, "start", zone.getDaylightStartRule(), indent + 2);
            ImportJRETimezones.writeDstRule(out, "end", zone.getDaylightEndRule(), indent + 2);
            out.indent(indent);
            out.w((Object)"</dst>").nl();
            indent -= 2;
        }
        out.indent(indent);
        out.w((Object)"</zone>").nl();
    }

    public static void writeDstRule(XWriter out, String elemName, DstRule rule, int indent) throws IOException {
        out.indent(indent);
        out.w((Object)"<");
        out.w((Object)elemName);
        out.w((Object)" ");
        out.attr("time", ImportJRETimezones.formatTime(rule.getTime(), rule.getTimeMode()));
        if (rule.getWeek() != -1) {
            out.w((Object)" ");
            out.attr("week", DstRule.encodeWeek((int)rule.getWeek()));
        }
        if (rule.getWeekday() != null) {
            out.w((Object)" ");
            out.attr("weekday", rule.getWeekday().encodeToString());
        }
        out.w((Object)" ");
        out.attr("month", rule.getMonth().encodeToString());
        int dayMode = rule.getDayMode();
        if (dayMode != -1) {
            out.w((Object)" ");
            if (dayMode == 0) {
                out.attr("day", Integer.toString(rule.getDay()));
            } else if (dayMode == 2) {
                out.attr("day", "..." + rule.getDay());
            } else if (dayMode == 1) {
                switch (rule.getDay()) {
                    case 8: {
                        out.attr("week", DstRule.encodeWeek((int)1));
                        break;
                    }
                    case 15: {
                        out.attr("week", DstRule.encodeWeek((int)2));
                        break;
                    }
                    case 22: {
                        out.attr("week", DstRule.encodeWeek((int)3));
                        break;
                    }
                    default: {
                        out.attr("day", rule.getDay() + "...");
                    }
                }
            }
        }
        out.w((Object)"/>").nl();
    }

    private static String formatTime(BTime time, int timeMode) {
        StringBuffer s = new StringBuffer(16);
        int hour = time.getHour();
        int minute = time.getMinute();
        s.append(hour);
        s.append(':');
        if (minute < 10) {
            s.append('0');
        }
        s.append(minute);
        if (timeMode == 1) {
            s.append(" standard");
        } else if (timeMode == 2) {
            s.append(" utc");
        } else if (timeMode != 0) {
            throw new IllegalArgumentException("Invalid time mode: " + timeMode);
        }
        return s.toString();
    }

    private static String formatRelTime(int relTime) {
        if (relTime % 3600000 == 0) {
            return relTime / 3600000 + "h";
        }
        if (relTime % 1800000 == 0) {
            return Float.toString((float)relTime / 3600000.0f) + "h";
        }
        if (relTime % 900000 == 0) {
            return Float.toString((float)relTime / 3600000.0f) + "h";
        }
        return Integer.toString(relTime);
    }

    public static BTimeZone toAx(TimeZone tz) {
        String txt = tz.toString();
        String spec = txt.substring(txt.indexOf(91) + 1, txt.length() - 1);
        HashMap<String, String> fields = ImportJRETimezones.toTable(spec, null);
        String id = fields.get("id");
        int utcOffset = ImportJRETimezones.getInt(fields, "offset", 0);
        boolean useDaylight = ImportJRETimezones.getBoolean(fields, "useDaylight", false);
        String stdName = tz.getDisplayName(false, 1);
        String stdShort = tz.getDisplayName(false, 0);
        String dstName = tz.getDisplayName(true, 1);
        String dstShort = tz.getDisplayName(true, 0);
        if (!useDaylight) {
            return BTimeZone.makeIgnoringCache((String)id, (String)stdName, (String)stdShort, (String)dstName, (String)dstShort, (int)utcOffset, (int)0, null, null);
        }
        int savings = ImportJRETimezones.getInt(fields, "dstSavings", 0);
        DstRule startRule = ImportJRETimezones.getRule("start", fields);
        DstRule endRule = ImportJRETimezones.getRule("end", fields);
        return BTimeZone.makeIgnoringCache((String)id, (String)stdName, (String)stdShort, (String)dstName, (String)dstShort, (int)utcOffset, (int)savings, (DstRule)startRule, (DstRule)endRule);
    }

    public static DstRule getRule(String base, HashMap<String, String> fields) {
        BTime time = ImportJRETimezones.getTime(fields, base + "Time");
        int timeMode = ImportJRETimezones.getInt(fields, base + "TimeMode", 0);
        int month = ImportJRETimezones.getInt(fields, base + "Month", 0);
        int day = ImportJRETimezones.getInt(fields, base + "Day", 0);
        int dayOfWeek = ImportJRETimezones.getInt(fields, base + "DayOfWeek", 0);
        if (dayOfWeek != 0) {
            if (day > 0) {
                if (day == 1) {
                    return DstRule.makeWeekday((BTime)time, (int)ImportJRETimezones.toTimeMode(timeMode), (int)0, (BWeekday)ImportJRETimezones.toWeekday(dayOfWeek), (BMonth)ImportJRETimezones.toMonth(month));
                }
                return DstRule.makeOnOrAfter((BTime)time, (int)ImportJRETimezones.toTimeMode(timeMode), (BMonth)ImportJRETimezones.toMonth(month), (int)day, (BWeekday)ImportJRETimezones.toWeekday(dayOfWeek));
            }
            if (dayOfWeek < 0) {
                return DstRule.makeOnOrBefore((BTime)time, (int)ImportJRETimezones.toTimeMode(timeMode), (BMonth)ImportJRETimezones.toMonth(month), (int)Math.abs(day), (BWeekday)ImportJRETimezones.toWeekday(dayOfWeek));
            }
            if (day == -1) {
                return DstRule.makeWeekday((BTime)time, (int)ImportJRETimezones.toTimeMode(timeMode), (int)5, (BWeekday)ImportJRETimezones.toWeekday(dayOfWeek), (BMonth)ImportJRETimezones.toMonth(month));
            }
            throw new IllegalArgumentException("Invalid " + base + "DayOfWeek: " + dayOfWeek);
        }
        return DstRule.makeExact((BTime)time, (int)ImportJRETimezones.toTimeMode(timeMode), (BMonth)ImportJRETimezones.toMonth(month), (int)day);
    }

    public static HashMap<String, String> toTable(String spec, HashMap<String, String> map) {
        String token;
        if (map == null) {
            map = new HashMap();
        }
        SpecTokenizer tokens = new SpecTokenizer(spec);
        while ((token = tokens.next()) != null) {
            int eq = token.indexOf(61);
            String name = token.substring(0, eq);
            String val = token.substring(eq + 1);
            if (val.charAt(0) == '\"') {
                val = val.substring(1);
            }
            if (val.charAt(val.length() - 1) == '\"') {
                val = val.substring(0, val.length() - 1);
            }
            if (!name.equals("lastRule")) {
                map.put(name, val);
                continue;
            }
            if (val.equals("null")) continue;
            ImportJRETimezones.toTable(val.substring(val.indexOf(91) + 1, val.length() - 1), map);
        }
        return map;
    }

    public static BTime getTime(HashMap<String, String> map, String key) {
        String valTxt = map.get(key);
        if (valTxt == null) {
            throw new IllegalArgumentException("Missing time zone attribute: " + key);
        }
        int millis = Integer.parseInt(valTxt);
        int hour = millis / 3600000;
        int minute = (millis -= hour * 3600000) / 60000;
        int second = (millis -= minute * 60000) / 1000;
        return BTime.make((int)hour, (int)minute, (int)second, (int)(millis -= second * 1000));
    }

    public static int toTimeMode(int jTimeMode) {
        if (jTimeMode == 0) {
            return 0;
        }
        if (jTimeMode == 1) {
            return 1;
        }
        if (jTimeMode == 2) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid time mode specification: " + jTimeMode);
    }

    public static BMonth toMonth(int jMonth) {
        if (jMonth == 0) {
            return BMonth.january;
        }
        if (jMonth == 1) {
            return BMonth.february;
        }
        if (jMonth == 2) {
            return BMonth.march;
        }
        if (jMonth == 3) {
            return BMonth.april;
        }
        if (jMonth == 4) {
            return BMonth.may;
        }
        if (jMonth == 5) {
            return BMonth.june;
        }
        if (jMonth == 6) {
            return BMonth.july;
        }
        if (jMonth == 7) {
            return BMonth.august;
        }
        if (jMonth == 8) {
            return BMonth.september;
        }
        if (jMonth == 9) {
            return BMonth.october;
        }
        if (jMonth == 10) {
            return BMonth.november;
        }
        if (jMonth == 11) {
            return BMonth.december;
        }
        throw new IllegalArgumentException("Invalid month specification: " + jMonth);
    }

    public static int toWeek(int w) {
        if (w == 1) {
            return 0;
        }
        if (w == 2) {
            return 1;
        }
        if (w == 3) {
            return 2;
        }
        if (w == 4) {
            return 3;
        }
        if (w == 5) {
            return 4;
        }
        if (w == -1) {
            return 5;
        }
        throw new IllegalArgumentException("Invalid week specification: " + w);
    }

    public static BWeekday toWeekday(int jWeekday) {
        if ((jWeekday = Math.abs(jWeekday)) == 1) {
            return BWeekday.sunday;
        }
        if (jWeekday == 2) {
            return BWeekday.monday;
        }
        if (jWeekday == 3) {
            return BWeekday.tuesday;
        }
        if (jWeekday == 4) {
            return BWeekday.wednesday;
        }
        if (jWeekday == 5) {
            return BWeekday.thursday;
        }
        if (jWeekday == 6) {
            return BWeekday.friday;
        }
        if (jWeekday == 7) {
            return BWeekday.saturday;
        }
        throw new IllegalArgumentException("Invalid day of week specification: " + jWeekday);
    }

    public static int getInt(HashMap<String, String> map, String key, int def) {
        String val = map.get(key);
        if (val == null) {
            return def;
        }
        return Integer.parseInt(val);
    }

    public static boolean getBoolean(HashMap<String, String> map, String key, boolean def) {
        String val = map.get(key);
        if (val == null) {
            return def;
        }
        if (val.equals("true")) {
            return true;
        }
        if (val.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException("Invalid boolean value: " + val);
    }

    public static DstRule toNormal(DstRule rule, int boundary, BTimeZone tz) {
        BAbsTime time;
        if (rule == null) {
            return null;
        }
        if (rule.getTimeMode() == 0) {
            return rule;
        }
        int day = rule.getDayMode() == -1 ? 2 : rule.getDay();
        if (rule.getTimeMode() == 2) {
            time = BAbsTime.make((int)BAbsTime.now().getYear(), (BMonth)rule.getMonth(), (int)day, (int)rule.getTime().getHour(), (int)rule.getTime().getMinute(), (int)0, (int)0, (BTimeZone)BTimeZone.UTC);
            time = BAbsTime.make((long)time.getMillis(), (BTimeZone)tz);
            if (rule.getDayMode() == -1 && time.getDay() != day) {
                return null;
            }
        } else {
            time = BAbsTime.make((int)BAbsTime.now().getYear(), (BMonth)rule.getMonth(), (int)day, (int)rule.getTime().getHour(), (int)rule.getTime().getMinute(), (int)0, (int)0, (BTimeZone)BTimeZone.make((String)(tz.getId() + "-std"), (int)tz.getUtcOffset()));
            time = BAbsTime.make((long)time.getMillis(), (BTimeZone)tz);
            if (rule.getDayMode() == -1 && time.getDay() != day) {
                return null;
            }
        }
        if (rule.getDayMode() == -1) {
            return DstRule.makeWeekday((BTime)BTime.make((BAbsTime)time), (int)0, (int)rule.getWeek(), (BWeekday)rule.getWeekday(), (BMonth)time.getMonth());
        }
        if (rule.getDayMode() == 0) {
            return DstRule.makeExact((BTime)BTime.make((BAbsTime)time), (int)0, (BMonth)time.getMonth(), (int)time.getDay());
        }
        if (rule.getDayMode() == 2) {
            return DstRule.makeOnOrBefore((BTime)BTime.make((BAbsTime)time), (int)0, (BMonth)time.getMonth(), (int)time.getDay(), (BWeekday)time.getWeekday());
        }
        return DstRule.makeOnOrAfter((BTime)BTime.make((BAbsTime)time), (int)0, (BMonth)time.getMonth(), (int)time.getDay(), (BWeekday)time.getWeekday());
    }

    public static void writeC(PrintWriter out, BTimeZone[] zones) throws IOException {
        int j = 0;
        for (int i = 0; i < zones.length; ++i) {
            BTimeZone tz = zones[i];
            DstRule s = tz.getDaylightStartRule();
            DstRule e = tz.getDaylightEndRule();
            if (s == null || e == null) {
                out.println("tz[" + j + "] = TimeZone::make(\"" + tz.getId() + "\"," + tz.getUtcOffset() / 60000 + ",0," + -1 + "," + -1 + "," + -1 + "," + -1 + "," + -1 + "," + -1 + "," + -1 + "," + -1 + "," + -1 + "," + -1 + "," + -1 + "," + -1 + "," + -1 + "," + -1 + ");");
            } else {
                DstRule startRule = ImportJRETimezones.toNormal(tz.getDaylightStartRule(), 0, tz);
                DstRule endRule = ImportJRETimezones.toNormal(tz.getDaylightEndRule(), 1, tz);
                if (startRule == null || endRule == null) {
                    System.out.println("Can't normalize, skipping " + tz);
                    continue;
                }
                int startWeekday = startRule.getWeekday() == null ? -1 : startRule.getWeekday().getOrdinal();
                int endWeekday = endRule.getWeekday() == null ? -1 : endRule.getWeekday().getOrdinal();
                out.println("tz[" + j + "] = TimeZone::make(\"" + tz.getId() + "\"," + tz.getUtcOffset() / 60000 + "," + tz.getDaylightAdjustment() / 60000 + "," + startRule.getTime().getHour() + "," + startRule.getTime().getMinute() + "," + startRule.getMonth().getOrdinal() + "," + startRule.getDay() + "," + startRule.getDayMode() + "," + startRule.getWeek() + "," + startWeekday + "," + endRule.getTime().getHour() + "," + endRule.getTime().getMinute() + "," + endRule.getMonth().getOrdinal() + "," + endRule.getDay() + "," + endRule.getDayMode() + "," + endRule.getWeek() + "," + endWeekday + ");");
            }
            ++j;
        }
    }

    private static class ZoneIdComparator
    implements Comparator<BTimeZone> {
        private ZoneIdComparator() {
        }

        @Override
        public int compare(BTimeZone tz1, BTimeZone tz2) {
            String id1 = tz1.getId();
            String id2 = tz2.getId();
            return id1.compareTo(id2);
        }
    }

    public static class SpecTokenizer {
        String spec;
        int len;
        int i;

        public SpecTokenizer(String spec) {
            this.spec = spec;
            this.i = 0;
            this.len = spec.length();
        }

        public String next() {
            String token;
            int start = this.i;
            while (this.i < this.len && this.spec.charAt(this.i) != ',') {
                ++this.i;
                if (this.i == this.len) break;
                if (this.spec.charAt(this.i) != '[') continue;
                while (this.i < this.len && this.spec.charAt(this.i) != ']') {
                    ++this.i;
                }
                if (this.i >= this.len) continue;
                ++this.i;
            }
            String string = token = start == this.i ? null : this.spec.substring(start, this.i);
            if (token != null) {
                ++this.i;
            }
            return token;
        }
    }
}

