/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.util;

import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.file.FilePath;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.Sys;

public class HrefCheck {
    static int errorCount;

    public static void process(NModule module) throws Exception {
        String name = module.getModuleName();
        ZipFile zip = module.getZipFile();
        if (name.startsWith("lon") && !name.equals("lonworks")) {
            return;
        }
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String path = entry.getName();
            if (!path.endsWith(".html") && !path.endsWith(".css")) continue;
            InputStream in = zip.getInputStream(entry);
            try {
                HrefCheck.process(name + ":" + path, in);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            in.close();
        }
    }

    public static void process(String name, InputStream in) throws Exception {
        String line;
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        int lineno = 0;
        while ((line = r.readLine()) != null) {
            try {
                HrefCheck.checkAttr(name, ++lineno, line, "href", 0);
                HrefCheck.checkAttr(name, lineno, line, "src", 0);
                HrefCheck.checkCss(name, lineno, line, 0);
            }
            catch (Exception e) {
                System.out.println("ERROR line[" + lineno + "] " + line);
                e.printStackTrace();
            }
        }
    }

    static void checkAttr(String name, int lineno, String line, String attr, int start) {
        int a = line.indexOf(attr, start);
        if (a < 0) {
            return;
        }
        try {
            if (line.charAt(a + attr.length()) != '=' && line.charAt(a + attr.length() + 1) != '=') {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        int quote = 34;
        int q0 = line.indexOf(quote, a + 1);
        if (q0 < 0) {
            quote = 39;
            q0 = line.indexOf(quote, a + 1);
        }
        int q1 = line.indexOf(quote, q0 + 1);
        String uri = line.substring(q0 + 1, q1);
        HrefCheck.checkUri(name, lineno, line, uri);
        HrefCheck.checkAttr(name, lineno, line, attr, q1 + 1);
    }

    static void checkCss(String name, int lineno, String line, int start) {
        int x = line.indexOf("url(", start);
        if (x < 0) {
            return;
        }
        int open = x + 4;
        int close = line.indexOf(41, open + 1);
        String uri = line.substring(open, close);
        HrefCheck.checkUri(name, lineno, line, uri);
        HrefCheck.checkCss(name, lineno, line, close + 1);
    }

    static void checkUri(String name, int lineno, String line, String uri) {
        String file;
        if (uri.startsWith("local:")) {
            return;
        }
        if (uri.startsWith("module:")) {
            return;
        }
        if (uri.startsWith("file:")) {
            return;
        }
        if (uri.startsWith("workbench:")) {
            return;
        }
        if (uri.startsWith("$(")) {
            return;
        }
        if (uri.startsWith("#")) {
            return;
        }
        if (FilePath.isValidName((String)uri)) {
            return;
        }
        int pound = uri.indexOf(35);
        if (pound > 0 && FilePath.isValidName((String)(file = uri.substring(0, pound)))) {
            return;
        }
        try {
            FilePath path = new FilePath(uri);
            if (path.isRelative()) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++errorCount;
        line = line.trim();
        if (line.length() > 79) {
            line = line.substring(0, 78) + "...";
        }
        System.out.println(name + " line[" + lineno + "] " + line);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage: HrefCheck <module | all>");
            return;
        }
        ModuleInfo[] modules = args[0].equals("all") ? Sys.getRegistry().getModules() : Sys.getRegistry().getModules(args[0]);
        for (ModuleInfo info : modules) {
            try {
                HrefCheck.process(AccessController.doPrivileged(() -> Nre.getModuleManager()).loadModule(info.getModuleName(), info.getRuntimeProfile()));
            }
            catch (Exception e) {
                System.err.println("Failed to process " + info.getModulePartName() + ": " + e);
                e.printStackTrace();
            }
        }
        System.out.println("Found " + errorCount + " errors");
    }
}

