/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.ui.lexicon;

import com.tridium.devkit.ui.lexicon.BLexiconTool;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.sys.module.BModuleFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.sys.Action;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

@NiagaraSlots(actions={@NiagaraAction(name="migrateModule", flags=4)})
public class BLexiconModuleMigrator
extends BWbView {
    public static final Action migrateModule = BLexiconModuleMigrator.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BLexiconModuleMigrator.class);
    BLexiconTool tool;
    BTextField moduleDestinationField;
    BTextField versionField;
    File destinationFolder = Sys.getNiagaraUserHome();
    Command changeDestinationCommand;
    Command selectModulesCommand;
    Command migrateCommand;
    BTable table;
    DefaultTableModel tableModel;
    public static final int MIG_EMPTY_COL = 0;
    public static final int MIG_SOURCE_COL = 1;
    public static final int MIG_PATH_COL = 2;
    public static final int MIG_COL_COUNT = 3;
    private static final IFileFilter MODULE_FILTER = new ExtFileFilter("Niagara Jar File", "jar");

    public void migrateModule() {
        this.invoke(migrateModule, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.tool = (BLexiconTool)value;
        BGridPane moduleDestinationPane = new BGridPane(3);
        String defaultDestination = this.destinationFolder == null ? "" : this.destinationFolder.getAbsolutePath();
        this.moduleDestinationField = new BTextField(defaultDestination, 40, true);
        moduleDestinationPane.add(null, (BValue)new BLabel(Lexicon.make((String)"devkit").getText("lexiconModuleMigrator.view.destination") + ": "));
        moduleDestinationPane.add(null, (BValue)this.moduleDestinationField);
        this.changeDestinationCommand = new Command((BWidget)this, Lexicon.make((String)"devkit").module, "commands.changeDestination"){

            public CommandArtifact doInvoke() {
                BLexiconModuleMigrator.this.doChangeDestination();
                return null;
            }
        };
        BButton changeDestinationButton = new BButton(this.changeDestinationCommand, true, true);
        moduleDestinationPane.add(null, (BValue)changeDestinationButton);
        this.versionField = new BTextField("", 15, true);
        moduleDestinationPane.add(null, (BValue)new BLabel(Lexicon.make((String)"devkit").getText("lexiconModuleMigrator.view.version") + ": "));
        moduleDestinationPane.add(null, (BValue)this.versionField);
        this.selectModulesCommand = new Command((BWidget)this, Lexicon.make((String)"devkit").module, "commands.selectModuleMigrate"){

            public CommandArtifact doInvoke() {
                BLexiconModuleMigrator.this.doSelectModules();
                return null;
            }
        };
        BButton selectionButton = new BButton(this.selectModulesCommand, true, true);
        BFlowPane selectionPane = new BFlowPane();
        selectionPane.setAlign(BHalign.center);
        selectionPane.add(null, (BValue)selectionButton);
        String[] cols = new String[]{"", Lexicon.make((String)"devkit").getText("lexiconModuleMigrator.source"), Lexicon.make((String)"devkit").getText("lexiconModuleMigrator.path")};
        this.tableModel = new DefaultTableModel(cols);
        this.table = new BTable((TableModel)new DynamicTableModel((TableModel)this.tableModel, new int[]{0, 1, 2}));
        this.table.setMultipleSelection(true);
        this.migrateCommand = new Command((BWidget)this, Lexicon.make((String)"devkit").module, "commands.migrate"){

            public CommandArtifact doInvoke() {
                BLexiconModuleMigrator.this.doMigrateModule();
                return null;
            }
        };
        BButton buildButton = new BButton(this.migrateCommand, true, true);
        BFlowPane buttonPane = new BFlowPane();
        buttonPane.setAlign(BHalign.center);
        buttonPane.add(null, (BValue)buildButton);
        BGridPane topPane = new BGridPane(1);
        topPane.setRowGap(30.0);
        topPane.setHalign(BHalign.left);
        topPane.add(null, (BValue)moduleDestinationPane);
        topPane.add(null, (BValue)selectionPane);
        BEdgePane mainPane = new BEdgePane();
        mainPane.setTop((BWidget)new BBorderPane((BWidget)topPane));
        mainPane.setCenter((BWidget)this.table);
        mainPane.setBottom((BWidget)new BBorderPane((BWidget)buttonPane));
        if (this.tool.migrateModuleDestination != null && this.tool.migrateModuleDestination.length() > 0) {
            this.moduleDestinationField.setText(this.tool.migrateModuleDestination);
        }
        if (this.tool.migrateModuleVersion != null && this.tool.migrateModuleVersion.length() > 0) {
            this.versionField.setText(this.tool.migrateModuleVersion);
        }
        for (File source : this.tool.selectedFiles) {
            Object[] row = new String[]{"", source.getName(), source.getAbsolutePath()};
            this.tableModel.addRow(row);
        }
        this.setContent((BWidget)mainPane);
    }

    public void doChangeDestination() {
        File destination;
        BIFile file;
        try {
            file = BFileChooserDialog.chooseFile((BWidget)this, null, (String)Lexicon.make((String)"devkit").getText("lexiconModuleMigrator.destinationChooser.browser.title"), (String)Lexicon.make((String)"devkit").getText("lexiconModuleMigrator.destinationChooser.browser.message"), (BIFile)BFileSystem.INSTANCE.makeDir(BFileSystem.INSTANCE.localFileToPath(this.destinationFolder), null), (IFileFilter)IFileFilter.directory, (IFileFilter)IFileFilter.directory);
        }
        catch (IOException e) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleMigrator.destinationChooser.error.io"));
            return;
        }
        if (file == null) {
            return;
        }
        FilePath fp = file.getFilePath();
        this.destinationFolder = destination = BFileSystem.INSTANCE.pathToLocalFile(fp);
        this.moduleDestinationField.setText(destination.getAbsolutePath());
    }

    public void doSelectModules() {
        BIFile[] files;
        try {
            if (this.tool.migrateModuleSourceFolder == null) {
                this.tool.migrateModuleSourceFolder = new File(Sys.getNiagaraHome(), "modules");
            }
            files = BFileChooserDialog.chooseFiles((BWidget)this, null, (String)Lexicon.make((String)"devkit").getText("lexiconModuleMigrator.moduleChooser.browser.title"), (String)Lexicon.make((String)"devkit").getText("lexiconModuleMigrator.moduleChooser.browser.message"), (BIFile)BFileSystem.INSTANCE.makeDir(BFileSystem.INSTANCE.localFileToPath(this.tool.migrateModuleSourceFolder), null), (IFileFilter)MODULE_FILTER, (IFileFilter)MODULE_FILTER);
        }
        catch (IOException e) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleMigrator.moduleChooser.error.io"));
            return;
        }
        for (BIFile file : files) {
            File destination;
            if (file == null) {
                return;
            }
            if (!(file instanceof BModuleFile)) {
                Object[] sa = new Object[]{file.getFileName()};
                BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleMigrator.moduleChooser.error.jar", sa));
                return;
            }
            String moduleName = file.getFileName();
            int end = moduleName.indexOf(".jar");
            moduleName = moduleName.substring(0, end);
            FilePath fp = file.getFilePath();
            File source = BFileSystem.INSTANCE.pathToLocalFile(fp);
            if (fp.isAbsolute() && fp.getScheme().equalsIgnoreCase("file") && (destination = new File(this.destinationFolder, moduleName + ".jar")).exists()) {
                Object[] sa = new Object[]{destination.getName()};
                BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleMigrator.destinationChooser.error.exists", sa));
                return;
            }
            if (!this.isExistingModuleValid(file)) {
                return;
            }
            if (this.tableModel == null) {
                BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleMigrator.destinationChooser.error.table"));
                return;
            }
            if (this.tool.selectedFiles.add(source)) {
                Object[] row = new String[]{"", source.getName(), source.getAbsolutePath()};
                this.tableModel.addRow(row);
            }
            this.tool.migrateModuleSourceFolder = new File(source.getParent());
        }
        this.tableModel.updateTable(true);
    }

    private void writeToDestinationZip(ZipOutputStream zos, ZipFile sourceModule, ZipEntry sourceEntry) {
        try {
            if (sourceEntry.getName().equalsIgnoreCase("meta-inf/module.xml")) {
                XElem moduleXml = this.generateModuleXml(sourceModule, sourceEntry);
                zos.putNextEntry(new ZipEntry("META-INF/module.xml"));
                XWriter xwriter = new XWriter((OutputStream)zos);
                xwriter.write("<?xml version='1.0'?>\n");
                moduleXml.write(xwriter);
                xwriter.flush();
                zos.closeEntry();
            } else {
                if (sourceEntry.getName().equalsIgnoreCase("meta-inf/manifest.mf")) {
                    zos.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                } else {
                    zos.putNextEntry(new ZipEntry(sourceEntry));
                }
                InputStream in = sourceModule.getInputStream(sourceEntry);
                byte[] buffer = new byte[512];
                while (0 < in.available()) {
                    int read = in.read(buffer);
                    zos.write(buffer, 0, read);
                }
                in.close();
                zos.closeEntry();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private XElem generateModuleXml(ZipFile moduleJar, ZipEntry zipEntry) {
        XElem rootElem = new XElem("module");
        try (InputStream inputStream = moduleJar.getInputStream(zipEntry);){
            XElem lexicons;
            XElem def;
            XElem dependElem;
            XElem manifest = XParser.make((InputStream)inputStream).parse();
            rootElem.addAttr("name", manifest.attrValue(manifest.attrIndex("name")));
            rootElem.addAttr("bajaVersion", "0");
            rootElem.addAttr("vendor", manifest.attrValue(manifest.attrIndex("vendor")));
            String newVersion = this.versionField.getText();
            if (newVersion.length() > 0) {
                rootElem.addAttr("vendorVersion", this.versionField.getText());
            } else {
                rootElem.addAttr("vendorVersion", manifest.attrValue(manifest.attrIndex("vendorVersion")));
            }
            rootElem.addAttr("description", manifest.attrValue(manifest.attrIndex("description")));
            rootElem.addAttr("preferredSymbol", manifest.attrValue(manifest.attrIndex("preferredSymbol")));
            rootElem.addAttr("nre", "true");
            rootElem.addAttr("installable", "true");
            rootElem.addAttr("autoload", "true");
            rootElem.addAttr("buildMillis", String.valueOf(System.currentTimeMillis()));
            rootElem.addAttr("buildHost", Sys.getHostName());
            rootElem.addAttr("moduleName", manifest.attrValue(manifest.attrIndex("name")));
            rootElem.addAttr("runtimeProfile", "rt");
            XElem dependencies = manifest.elem("dependencies");
            if (dependencies != null) {
                XElem[] dependencyElems;
                dependElem = dependencies.copy();
                boolean bajaDependencyFound = false;
                for (XElem dependency : dependencyElems = dependencies.elems()) {
                    if (dependency.attrIndex("name") < 0 || !dependency.attrValue(dependency.attrIndex("name")).equalsIgnoreCase("baja")) continue;
                    bajaDependencyFound = true;
                    break;
                }
                if (!bajaDependencyFound) {
                    XElem bajaDependency = new XElem("dependency");
                    bajaDependency.addAttr("name", "baja");
                    bajaDependency.addAttr("vendor", "Tridium");
                    bajaDependency.addAttr("vendorVersion", "4.0");
                    dependElem.addContent((XContent)bajaDependency);
                }
                rootElem.addContent((XContent)dependElem);
            } else {
                dependElem = new XElem("dependencies");
                XElem bajaDependency = new XElem("dependency");
                bajaDependency.addAttr("name", "baja");
                bajaDependency.addAttr("vendor", "Tridium");
                bajaDependency.addAttr("vendorVersion", "4.0");
                dependElem.addContent((XContent)bajaDependency);
                rootElem.addContent((XContent)dependElem);
            }
            XElem dirs = manifest.elem("dirs");
            if (dirs != null) {
                rootElem.addContent((XContent)dirs.copy());
            }
            if ((def = manifest.elem("def")) != null) {
                rootElem.addContent((XContent)def.copy());
            }
            if ((lexicons = manifest.elem("lexicons")) != null) {
                rootElem.addContent((XContent)lexicons.copy());
            }
        }
        catch (Exception e) {
            Object[] sa = new Object[]{e.getMessage()};
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.build.errorMessage", sa));
        }
        return rootElem;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isExistingModuleValid(BIFile moduleBIFile) {
        boolean valid = true;
        FilePath fp = moduleBIFile.getFilePath();
        File moduleFile = BFileSystem.INSTANCE.pathToLocalFile(fp);
        try (ZipFile moduleJar = new ZipFile(moduleFile);){
            ZipEntry zipFile;
            ZipEntry zipEntry = moduleJar.getEntry("META-INF/module.xml");
            if (zipEntry == null) {
                zipEntry = moduleJar.getEntry("meta-inf/module.xml");
            }
            if (zipEntry == null) {
                throw new BajaRuntimeException("Module does not include manifest.");
            }
            XElem manifest = XParser.make((InputStream)moduleJar.getInputStream(zipEntry)).parse();
            Enumeration<? extends ZipEntry> entries = moduleJar.entries();
            do {
                if (!entries.hasMoreElements()) return valid;
            } while (!(zipFile = entries.nextElement()).getName().endsWith(".class"));
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleChooser.error.class"));
            boolean bl = false;
            return bl;
        }
        catch (ModuleNotFoundException e) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleChooser.error.load"));
            return false;
        }
        catch (ModuleException e) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.build.module.exception"));
            return false;
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleChooser.error.contents"));
            return false;
        }
    }

    public void deactivated() {
        this.tool.migrateModuleDestination = this.moduleDestinationField.getText();
        this.tool.migrateModuleVersion = this.versionField.getText();
        super.deactivated();
    }

    public void doMigrateModule() {
        int rowCount = this.tableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            int confirm;
            String moduleName = (String)this.tableModel.getValueAt(i, 1);
            String modulePath = (String)this.tableModel.getValueAt(i, 2);
            File file = new File(this.destinationFolder, moduleName);
            if (file.exists() && (confirm = BDialog.confirm((BWidget)this, (String)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.confirm.overwrite.title"), (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.confirm.overwrite.message"), (int)3)) == 2) continue;
            try (ZipFile sourceFile = new ZipFile(modulePath);
                 ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file));){
                sourceFile.stream().forEach(sourceEntry -> this.writeToDestinationZip(zos, sourceFile, (ZipEntry)sourceEntry));
                continue;
            }
            catch (Exception e) {
                if (e.getMessage().length() > 0) {
                    Object[] sa = new Object[]{e.getMessage()};
                    BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.build.errorMessage", sa));
                    continue;
                }
                BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.build.error"));
            }
        }
        Object[] sa = new Object[]{this.destinationFolder.getAbsolutePath()};
        BDialog.info((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleMigrator.build.success", sa));
    }
}

