/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.ux;

import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.util.Lexicon;

@NiagaraSingleton
@NiagaraType
public class BTaggingRpcUtil
extends BSingleton {
    public static final BTaggingRpcUtil INSTANCE = new BTaggingRpcUtil();
    public static final Type TYPE = Sys.loadType(BTaggingRpcUtil.class);
    public static final String TAG_NAME_KEY = "n";
    public static final String DICTIONARY_KEY = "d";
    public static final String TAG_TYPE_KEY = "t";
    public static final String TAG_B_TYPE_KEY = "b";
    public static final String DEFAULT_VALUE_KEY = "v";
    public static final String IS_IDEAL_KEY = "ii";
    public static final String IS_VALID_KEY = "iv";
    private static final Lexicon lex = Lexicon.make(BTaggingRpcUtil.class);
    private static final Logger LOG = Logger.getLogger("tagdictionary.ux");

    public Type getType() {
        return TYPE;
    }

    private BTaggingRpcUtil() {
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<Object> getTagInfos(String selectedDictionary, String targetComponentOrd, Context cx) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getTagInfos, for: dictionary: " + selectedDictionary + ", targetComponentOrd: " + targetComponentOrd);
        }
        BComponent targetComponent = null;
        try {
            targetComponent = (BComponent)BOrd.make((String)targetComponentOrd).get(null, cx);
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            Iterator itr = BTaggingRpcUtil.getTagDictionary(selectedDictionary, cx).getTags();
            while (itr.hasNext()) {
                TagInfo ti = (TagInfo)itr.next();
                if (!BTaggingRpcUtil.hasReadPermission(ti, cx)) continue;
                result.add(BTaggingRpcUtil.createTagInfoJson(ti, targetComponent));
            }
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
        return result;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<Object> getTagGroupInfos(String selectedDictionary, String targetComponentOrd, Context cx) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getTagGroupInfos, for: " + selectedDictionary + ", targetComponentOrd: " + targetComponentOrd);
        }
        BComponent targetComponent = null;
        try {
            targetComponent = (BComponent)BOrd.make((String)targetComponentOrd).get(null, cx);
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            Iterator itr = BTaggingRpcUtil.getTagDictionary(selectedDictionary, cx).getTagGroups();
            while (itr.hasNext()) {
                TagGroupInfo tgi = (TagGroupInfo)itr.next();
                if (!BTaggingRpcUtil.hasReadPermission(tgi, cx)) continue;
                result.add(BTaggingRpcUtil.createTagGroupInfoJson(tgi, targetComponent));
            }
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
        return result;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getTagDictionaryServiceOrd(Context cx) {
        TagDictionaryService tagDictionaryService = BTaggingRpcUtil.getTagDictionaryService(cx);
        if (null != tagDictionaryService) {
            return ((BComponent)tagDictionaryService).getNavOrd().toString();
        }
        return "";
    }

    private static JSONObject createTagInfoJson(TagInfo tagInfo, BComponent targetComp) throws IOException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(TAG_NAME_KEY, (Object)tagInfo.getTagId().getName());
        jsonObj.put(DICTIONARY_KEY, (Object)tagInfo.getTagId().getDictionary());
        jsonObj.put(TAG_TYPE_KEY, (Object)tagInfo.getTagType().getTypeSpec().toString());
        jsonObj.put(DEFAULT_VALUE_KEY, (Object)BsonEncoderPlugin.marshal((BValue)((BValue)tagInfo.getDefaultValue())));
        jsonObj.put(TAG_B_TYPE_KEY, (Object)((BObject)tagInfo).getType().getTypeSpec().toString());
        jsonObj.put(IS_IDEAL_KEY, tagInfo.isIdealFor(targetComp.getType()));
        jsonObj.put(IS_VALID_KEY, tagInfo.isValidFor((Entity)targetComp));
        return jsonObj;
    }

    private static JSONObject createTagGroupInfoJson(TagGroupInfo tagGroupInfo, BComponent targetComp) throws IOException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(TAG_NAME_KEY, (Object)tagGroupInfo.getGroupId().getName());
        jsonObj.put(DICTIONARY_KEY, (Object)tagGroupInfo.getGroupId().getDictionary());
        BOrd slotPathOrd = BOrd.DEFAULT;
        if (tagGroupInfo instanceof BTagGroupInfo) {
            slotPathOrd = ((BTagGroupInfo)tagGroupInfo).getSlotPathOrd();
        } else if (tagGroupInfo instanceof BComponent) {
            slotPathOrd = ((Entity)tagGroupInfo).getOrdToEntity().orElse(BOrd.DEFAULT);
        }
        jsonObj.put(DEFAULT_VALUE_KEY, (Object)BsonEncoderPlugin.marshal((BValue)slotPathOrd));
        jsonObj.put(TAG_B_TYPE_KEY, (Object)((BObject)tagGroupInfo).getType().getTypeSpec().toString());
        jsonObj.put(IS_IDEAL_KEY, tagGroupInfo.isIdealFor(targetComp.getType()));
        jsonObj.put(IS_VALID_KEY, tagGroupInfo.isValidFor((Entity)targetComp));
        return jsonObj;
    }

    private static TagDictionary getTagDictionary(String namespace, Context cx) {
        TagDictionary tagDictionary;
        TagDictionaryService tagDictionaryService = BTaggingRpcUtil.getTagDictionaryService(cx);
        if (null != tagDictionaryService && BTaggingRpcUtil.hasReadPermission(tagDictionary = (TagDictionary)tagDictionaryService.getTagDictionary(namespace).orElse(null), cx)) {
            return tagDictionary;
        }
        return null;
    }

    private static TagDictionaryService getTagDictionaryService(Context cx) {
        TagDictionaryService tagDictionaryService;
        BStation station = Sys.getStation();
        if (null != station && BTaggingRpcUtil.hasReadPermission(tagDictionaryService = station.getTagDictionaryService(), cx)) {
            return tagDictionaryService;
        }
        return null;
    }

    private static boolean hasReadPermission(Object obj, Context cx) {
        if (obj instanceof BIProtected) {
            return ((BIProtected)obj).getPermissions(cx).hasOperatorRead();
        }
        return true;
    }
}

