/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProTransform.ui;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.seriestransform.BTransformQuery;
import com.tridium.seriestransform.NQueryParameters;
import com.tridium.seriestransform.binding.ui.BTransformChartBindingCollection;
import com.tridium.seriestransform.binding.ui.BTransformTableBinding;
import com.tridium.seriestransform.graph.BTransformGraph;
import com.tridium.seriestransform.graph.ParameterSlot;
import com.tridium.util.CompUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.chart.BChartPane;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.binding.BBoundTable;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

public class BTransformChartPane
extends BEdgePane {
    public static final Property defaultTimeRange = BTransformChartPane.newProperty((int)0, (BValue)BDynamicTimeRange.TODAY, null);
    public static final Action fieldEditorModified = BTransformChartPane.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BTransformChartPane.class);
    private BDynamicTimeRange range = this.getDefaultTimeRange();
    private BWbFieldEditor fe = null;
    public static final Lexicon lex = Lexicon.make(BTransformChartPane.class);
    private static final Logger logger = Logger.getLogger("transformChartPane");

    public BDynamicTimeRange getDefaultTimeRange() {
        return (BDynamicTimeRange)this.get(defaultTimeRange);
    }

    public void setDefaultTimeRange(BDynamicTimeRange v) {
        this.set(defaultTimeRange, (BValue)v, null);
    }

    public void fieldEditorModified() {
        this.invoke(fieldEditorModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTransformChartPane() {
        this.setFlags(this.getSlot("right"), 4);
        this.setFlags(this.getSlot("left"), 4);
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot.equals((Object)top)) {
            return "ToolBar";
        }
        if (slot.equals((Object)center)) {
            return "Charts";
        }
        if (slot.equals((Object)bottom)) {
            return "Table";
        }
        return super.getDisplayName(slot, cx);
    }

    public void started() throws Exception {
        if (CompUtil.closestAncestor((BComplex)this, BStation.class).isPresent()) {
            return;
        }
        BGridPane pane = new BGridPane();
        this.fe = BWbFieldEditor.makeFor((BObject)BDynamicTimeRange.TODAY);
        this.range = this.getDefaultTimeRange();
        this.fe.loadValue((BObject)this.range);
        this.linkTo("link0", (BComponent)this.fe, (Slot)BWbFieldEditor.setModified, (Slot)fieldEditorModified);
        BInsets insets = BInsets.make((double)4.0, (double)2.0, (double)4.0, (double)2.0);
        pane.add(null, (BValue)new BBorderPane((BWidget)this.fe, insets));
        this.setTop((BWidget)pane);
        BWbShell shell = (BWbShell)this.getShell();
        if (shell != null) {
            BObject base = shell.getActiveOrdTarget().get();
            BTransformChartBindingCollection[] bindings = this.findBindings();
            for (int i = 0; i < bindings.length; ++i) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Found this binding: " + bindings[0].getOrd());
                }
                BTransformQuery query = bindings[0].getQuery();
                BOrd graphOrd = query.getGraphOrd();
                String queryParams = "";
                if (graphOrd == null || graphOrd == BOrd.NULL) {
                    return;
                }
                BTransformGraph graph = (BTransformGraph)graphOrd.resolve(base).get();
                graph.lease(3);
                ParameterSlot[] paramSlots = graph.getParameterSlots();
                for (int k = 0; k < paramSlots.length; ++k) {
                    ParameterSlot param = paramSlots[k];
                    SlotPath path = param.getSlotPath();
                    SlotPath parent = path.getParent();
                    String[] pathNames = path.getNames();
                    String property = pathNames[pathNames.length - 1];
                    BOrd paramOrd = BOrd.make((BOrd)graph.getAbsoluteOrd(), (OrdQuery)parent);
                    BObject object = paramOrd.get((BObject)graph);
                    if (null == object || !(object instanceof BComponent)) continue;
                    BComponent complex = (BComponent)object;
                    complex.lease();
                    Property p = complex.getProperty(property);
                    BValue defaultValue = complex.get(p);
                    if (!(defaultValue instanceof BDynamicTimeRange)) continue;
                    queryParams = queryParams + "?" + path.getBody() + "=" + this.range.encodeToString();
                }
                query.setQueryParams(queryParams);
            }
            BBoundTable table = this.getBoundTable(this.getBottom());
            if (table != null) {
                BTransformTableBinding[] tableBindings = this.findTableBindings();
                if (tableBindings.length > 0) {
                    for (int i = 0; i < tableBindings.length; ++i) {
                        BTransformQuery query = tableBindings[0].getQuery();
                        BOrd graphOrd = query.getGraphOrd();
                        String queryParams = "";
                        if (graphOrd == null || graphOrd == BOrd.NULL) {
                            return;
                        }
                        BTransformGraph graph = (BTransformGraph)graphOrd.resolve(base).get();
                        graph.lease(3);
                        ParameterSlot[] paramSlots = graph.getParameterSlots();
                        for (int k = 0; k < paramSlots.length; ++k) {
                            ParameterSlot param = paramSlots[k];
                            SlotPath path = param.getSlotPath();
                            SlotPath parent = path.getParent();
                            String[] pathNames = path.getNames();
                            String property = pathNames[pathNames.length - 1];
                            BOrd paramOrd = BOrd.make((BOrd)graph.getAbsoluteOrd(), (OrdQuery)parent);
                            BObject object = paramOrd.get((BObject)graph);
                            if (null == object || !(object instanceof BComponent)) continue;
                            BComponent complex = (BComponent)object;
                            complex.lease();
                            Property p = complex.getProperty(property);
                            BValue defaultValue = complex.get(p);
                            if (!(defaultValue instanceof BDynamicTimeRange)) continue;
                            queryParams = queryParams + "?" + path.getBody() + "=" + this.range.encodeToString();
                        }
                        query.setQueryParams(queryParams);
                    }
                }
                BBoundTable newTable = new BBoundTable();
                for (int i = 0; i < tableBindings.length; ++i) {
                    newTable.add(null, (BValue)((BTransformTableBinding)tableBindings[i].newCopy()));
                }
                newTable.setLayout(table.getLayout());
                BWidget parentWidget = table.getParentWidget();
                if (parentWidget != null) {
                    parentWidget.set(table.getName(), (BValue)newTable);
                }
            }
        }
    }

    public void stopped() {
        this.setTop((BWidget)new BNullWidget());
    }

    public void doFieldEditorModified() {
        this.saveChart(this.isViewModified());
    }

    private BTransformChartBindingCollection[] findBindings() {
        Array a = new Array(BTransformChartBindingCollection.class);
        this.findTransformChartBindings((BWidget)this.getParent(), a);
        return (BTransformChartBindingCollection[])a.trim();
    }

    private void findTransformChartBindings(BWidget w, Array a) {
        BWidget[] kids = (BWidget[])w.getChildren(BWidget.class);
        BBinding[] bindings = null;
        for (int i = 0; i < kids.length; ++i) {
            bindings = kids[i].getBindings();
            for (int x = 0; x < bindings.length; ++x) {
                if (!(bindings[x] instanceof BTransformChartBindingCollection)) continue;
                a.add((Object)bindings[x]);
            }
            this.findTransformChartBindings(kids[i], a);
        }
    }

    private BTransformTableBinding[] findTableBindings() {
        Array a = new Array(BTransformTableBinding.class);
        this.findTransformTableBindings((BWidget)this, a);
        return (BTransformTableBinding[])a.trim();
    }

    private void findTransformTableBindings(BWidget w, Array a) {
        BWidget[] kids = (BWidget[])w.getChildren(BWidget.class);
        BBinding[] bindings = null;
        for (int i = 0; i < kids.length; ++i) {
            bindings = kids[i].getBindings();
            for (int x = 0; x < bindings.length; ++x) {
                if (!(bindings[x] instanceof BTransformTableBinding)) continue;
                a.add((Object)bindings[x]);
            }
            this.findTransformTableBindings(kids[i], a);
        }
    }

    private BBoundTable getBoundTable(BWidget widget) throws Exception {
        BBoundTable table = null;
        if (widget instanceof BBoundTable) {
            return (BBoundTable)widget;
        }
        BWidget[] kids = widget.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            if (kids[i] instanceof BBoundTable) {
                table = (BBoundTable)kids[i];
                return table;
            }
            this.getBoundTable(kids[i]);
        }
        return table;
    }

    private BChartPane getChartPane() throws Exception {
        BChartPane chartPane = null;
        if (!this.getCenter().getType().is(BChartPane.TYPE)) {
            throw new Exception("Could not find chart pane!");
        }
        chartPane = (BChartPane)this.getCenter();
        return chartPane;
    }

    private boolean isViewModified() {
        BWbShell shell = BWbShell.getWbShell((BWidget)this);
        if (shell != null) {
            BWbView activeView = BWbShell.getWbShell((BWidget)this).getActiveView();
            return activeView.isModified();
        }
        return false;
    }

    private void saveChart(boolean alreadyModified) {
        if (this.fe != null) {
            try {
                this.range = (BDynamicTimeRange)this.fe.saveValue();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Got this time range: " + this.range);
                }
                BTransformTableBinding[] tableBindings = this.findTableBindings();
                BBoundTable table = this.getBoundTable(this.getBottom());
                for (int m = 0; m < tableBindings.length; ++m) {
                    BTransformQuery query = tableBindings[m].getQuery();
                    BOrd graphOrd = query.getGraphOrd();
                    if (graphOrd == null || graphOrd == BOrd.NULL) {
                        return;
                    }
                    BWbShell shell = (BWbShell)this.getShell();
                    if (shell == null) continue;
                    BObject base = shell.getActiveOrdTarget().get();
                    BTransformGraph graph = (BTransformGraph)graphOrd.resolve(base).get();
                    graph.lease(3);
                    NQueryParameters pMap = query.decodeQueryParameters(graph);
                    String queryParams = "";
                    SlotPath[] paths = pMap.getSlotPaths();
                    for (int j = 0; j < paths.length; ++j) {
                        queryParams = queryParams + "?" + paths[j].getBody() + "=" + this.range.encodeToString();
                    }
                    query.setQueryParams(queryParams);
                }
                BTransformChartBindingCollection[] bindings = this.findBindings();
                BChartPane chartPane = this.getChartPane();
                for (int i = 0; i < bindings.length; ++i) {
                    BTransformQuery query;
                    BOrd graphOrd;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Found this binding: " + bindings[i].getOrd());
                    }
                    if ((graphOrd = (query = bindings[i].getQuery()).getGraphOrd()) == null || graphOrd == BOrd.NULL) {
                        return;
                    }
                    BWbShell shell = (BWbShell)this.getShell();
                    if (shell == null) continue;
                    BObject base = shell.getActiveOrdTarget().get();
                    BTransformGraph graph = (BTransformGraph)graphOrd.resolve(base).get();
                    graph.lease(3);
                    NQueryParameters pMap = query.decodeQueryParameters(graph);
                    String queryParams = "";
                    SlotPath[] paths = pMap.getSlotPaths();
                    for (int j = 0; j < paths.length; ++j) {
                        queryParams = queryParams + "?" + paths[j].getBody() + "=" + this.range.encodeToString();
                    }
                    query.setQueryParams(queryParams);
                }
                if (chartPane != null) {
                    BChartPane newPane = (BChartPane)chartPane.newCopy();
                    this.setCenter((BWidget)newPane);
                    if (alreadyModified) {
                        BWbView activeView = BWbShell.getWbShell((BWidget)this).getActiveView();
                        activeView.clearModified();
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Cleared the modified view");
                    }
                }
                if (table != null) {
                    BBoundTable newTable = new BBoundTable();
                    for (int i = 0; i < tableBindings.length; ++i) {
                        newTable.add(null, (BValue)((BTransformTableBinding)tableBindings[i].newCopy()));
                    }
                    newTable.setLayout(table.getLayout());
                    BWidget parentWidget = table.getParentWidget();
                    if (parentWidget != null) {
                        parentWidget.set(table.getName(), (BValue)newTable);
                    }
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Error attempting to save chart");
                }
                e.printStackTrace();
            }
        }
    }
}

