/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.ws;

import com.tridiumeurope.httpClient.util.BIHttpConsumer;
import com.tridiumeurope.httpClient.util.BMetrics;
import com.tridiumeurope.httpClient.util.HttpConsumable;
import com.tridiumeurope.httpClient.ws.WsMessageEvent;
import java.nio.charset.StandardCharsets;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="connections", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="connectionsFailed", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="normalDisconnects", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="unexpectedDisconnects", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="messagesSentTotal", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="messagesFailed", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="incomingMessagesNotQueued", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="outgoingMessagesNotQueued", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="messagesReceivedTotal", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="errorsReceived", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="sentMessageSize", type="long", defaultValue="BLong.DEFAULT", flags=73729, facets={@Facet(value="createByteUnitFacet()"), @Facet(value="createPrecisionFacet(2)")}), @NiagaraProperty(name="sentMessageSizeAvg", type="double", defaultValue="BDouble.DEFAULT", flags=73729, facets={@Facet(value="createByteUnitFacet()"), @Facet(value="createPrecisionFacet(2)")}), @NiagaraProperty(name="receivedMessageSize", type="long", defaultValue="BLong.DEFAULT", flags=73729, facets={@Facet(value="createByteUnitFacet()"), @Facet(value="createPrecisionFacet(2)")}), @NiagaraProperty(name="receivedMessageSizeAvg", type="double", defaultValue="BDouble.DEFAULT", flags=73729, facets={@Facet(value="createByteUnitFacet()"), @Facet(value="createPrecisionFacet(2)")})})
public class BWebsocketMetrics
extends BMetrics
implements BIHttpConsumer {
    public static final Property connections = BWebsocketMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    public static final Property connectionsFailed = BWebsocketMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    public static final Property normalDisconnects = BWebsocketMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    public static final Property unexpectedDisconnects = BWebsocketMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    public static final Property messagesSentTotal = BWebsocketMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    public static final Property messagesFailed = BWebsocketMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    public static final Property incomingMessagesNotQueued = BWebsocketMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    public static final Property outgoingMessagesNotQueued = BWebsocketMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    public static final Property messagesReceivedTotal = BWebsocketMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    public static final Property errorsReceived = BWebsocketMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    public static final Property sentMessageSize = BWebsocketMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, (BFacets)BFacets.make((BFacets)BWebsocketMetrics.createByteUnitFacet(), (BFacets)BWebsocketMetrics.createPrecisionFacet(2)));
    public static final Property sentMessageSizeAvg = BWebsocketMetrics.newProperty((int)73729, (BValue)BDouble.DEFAULT, (BFacets)BFacets.make((BFacets)BWebsocketMetrics.createByteUnitFacet(), (BFacets)BWebsocketMetrics.createPrecisionFacet(2)));
    public static final Property receivedMessageSize = BWebsocketMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, (BFacets)BFacets.make((BFacets)BWebsocketMetrics.createByteUnitFacet(), (BFacets)BWebsocketMetrics.createPrecisionFacet(2)));
    public static final Property receivedMessageSizeAvg = BWebsocketMetrics.newProperty((int)73729, (BValue)BDouble.DEFAULT, (BFacets)BFacets.make((BFacets)BWebsocketMetrics.createByteUnitFacet(), (BFacets)BWebsocketMetrics.createPrecisionFacet(2)));
    public static final Type TYPE = Sys.loadType(BWebsocketMetrics.class);

    public long getConnections() {
        return this.getLong(connections);
    }

    public void setConnections(long v) {
        this.setLong(connections, v, null);
    }

    public long getConnectionsFailed() {
        return this.getLong(connectionsFailed);
    }

    public void setConnectionsFailed(long v) {
        this.setLong(connectionsFailed, v, null);
    }

    public long getNormalDisconnects() {
        return this.getLong(normalDisconnects);
    }

    public void setNormalDisconnects(long v) {
        this.setLong(normalDisconnects, v, null);
    }

    public long getUnexpectedDisconnects() {
        return this.getLong(unexpectedDisconnects);
    }

    public void setUnexpectedDisconnects(long v) {
        this.setLong(unexpectedDisconnects, v, null);
    }

    public long getMessagesSentTotal() {
        return this.getLong(messagesSentTotal);
    }

    public void setMessagesSentTotal(long v) {
        this.setLong(messagesSentTotal, v, null);
    }

    public long getMessagesFailed() {
        return this.getLong(messagesFailed);
    }

    public void setMessagesFailed(long v) {
        this.setLong(messagesFailed, v, null);
    }

    public long getIncomingMessagesNotQueued() {
        return this.getLong(incomingMessagesNotQueued);
    }

    public void setIncomingMessagesNotQueued(long v) {
        this.setLong(incomingMessagesNotQueued, v, null);
    }

    public long getOutgoingMessagesNotQueued() {
        return this.getLong(outgoingMessagesNotQueued);
    }

    public void setOutgoingMessagesNotQueued(long v) {
        this.setLong(outgoingMessagesNotQueued, v, null);
    }

    public long getMessagesReceivedTotal() {
        return this.getLong(messagesReceivedTotal);
    }

    public void setMessagesReceivedTotal(long v) {
        this.setLong(messagesReceivedTotal, v, null);
    }

    public long getErrorsReceived() {
        return this.getLong(errorsReceived);
    }

    public void setErrorsReceived(long v) {
        this.setLong(errorsReceived, v, null);
    }

    public long getSentMessageSize() {
        return this.getLong(sentMessageSize);
    }

    public void setSentMessageSize(long v) {
        this.setLong(sentMessageSize, v, null);
    }

    public double getSentMessageSizeAvg() {
        return this.getDouble(sentMessageSizeAvg);
    }

    public void setSentMessageSizeAvg(double v) {
        this.setDouble(sentMessageSizeAvg, v, null);
    }

    public long getReceivedMessageSize() {
        return this.getLong(receivedMessageSize);
    }

    public void setReceivedMessageSize(long v) {
        this.setLong(receivedMessageSize, v, null);
    }

    public double getReceivedMessageSizeAvg() {
        return this.getDouble(receivedMessageSizeAvg);
    }

    public void setReceivedMessageSizeAvg(double v) {
        this.setDouble(receivedMessageSizeAvg, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void consume(HttpConsumable consumable) {
        if (consumable instanceof WsMessageEvent) {
            WsMessageEvent messageEvent = (WsMessageEvent)consumable;
            if (messageEvent.isOutbound()) {
                if (messageEvent.isSuccess()) {
                    this.messageSent(messageEvent.getTotalLength());
                } else {
                    this.messageFailed();
                }
            } else {
                this.messageReceived(messageEvent.getMessageContent());
            }
        }
    }

    public void connectionResult(boolean success) {
        this.incrementMetric(success ? connections : connectionsFailed);
    }

    public void disconnected(boolean normal) {
        if (normal) {
            this.incrementMetric(normalDisconnects);
        } else {
            this.incrementMetric(unexpectedDisconnects);
        }
    }

    public void messageNotQueued(boolean incoming) {
        this.incrementMetric(incoming ? incomingMessagesNotQueued : outgoingMessagesNotQueued);
    }

    public void error() {
        this.incrementMetric(errorsReceived);
    }

    private void messageSent(long messageBytesLength) {
        this.setLastSentTime(BAbsTime.now());
        this.incrementMetric(messagesSentTotal);
        this.increaseMetric(sentMessageSize, messageBytesLength);
        this.calculateAverage(sentMessageSizeAvg, sentMessageSize, messagesSentTotal);
    }

    private void messageReceived(String message) {
        if (message != null) {
            this.incrementMetric(messagesReceivedTotal);
            this.increaseMetric(receivedMessageSize, message.getBytes(StandardCharsets.UTF_8).length);
            this.calculateAverage(receivedMessageSizeAvg, receivedMessageSize, messagesReceivedTotal);
        }
    }

    private void messageFailed() {
        this.incrementMetric(messagesFailed);
    }
}

