/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.ws;

import com.tridiumeurope.httpClient.BHttpClientGlobalCapacityExt;
import com.tridiumeurope.httpClient.BHttpClientService;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClient;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClientTransport;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClientWrite;
import com.tridiumeurope.httpClient.comm.transport.BHttpTransport;
import com.tridiumeurope.httpClient.datatypes.BHttpAddress;
import com.tridiumeurope.httpClient.datatypes.BHttpResponseHealth;
import com.tridiumeurope.httpClient.datatypes.BHttpTuningPolicy;
import com.tridiumeurope.httpClient.datatypes.auth.BHttpAuthenticator;
import com.tridiumeurope.httpClient.datatypes.auth.SessionBasedAuth;
import com.tridiumeurope.httpClient.datatypes.enums.BHttpRequestMethod;
import com.tridiumeurope.httpClient.datatypes.exception.HttpCommException;
import com.tridiumeurope.httpClient.datatypes.options.BHttpHeaders;
import com.tridiumeurope.httpClient.datatypes.options.BHttpParameters;
import com.tridiumeurope.httpClient.datatypes.payload.BRequestBody;
import com.tridiumeurope.httpClient.util.HttpClientRegister;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.InputStreamUtil;
import com.tridiumeurope.httpClient.util.LicenseUtil;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import com.tridiumeurope.httpClient.util.queue.EngineCycleQueue;
import com.tridiumeurope.httpClient.ws.BWebsocketConfig;
import com.tridiumeurope.httpClient.ws.BWebsocketHealth;
import com.tridiumeurope.httpClient.ws.BWebsocketMetrics;
import com.tridiumeurope.httpClient.ws.WebsocketCallbacks;
import com.tridiumeurope.httpClient.ws.WebsocketClientSession;
import com.tridiumeurope.httpClient.ws.WsMessageEvent;
import com.tridiumeurope.httpClient.ws.jetty.JettyWebsocketClientSession;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="proxy", type="BHttpClientGlobalCapacityExt", defaultValue="new BHttpClientGlobalCapacityExt()", flags=4), @NiagaraProperty(name="health", type="BHttpResponseHealth", defaultValue="new BWebsocketHealth()"), @NiagaraProperty(name="address", type="BHttpAddress", defaultValue="new BHttpAddress()"), @NiagaraProperty(name="headers", type="BHttpHeaders", defaultValue="new BHttpHeaders()"), @NiagaraProperty(name="config", type="BWebsocketConfig", defaultValue="new BWebsocketConfig()"), @NiagaraProperty(name="authenticator", type="BHttpAuthenticator", defaultValue="new BHttpAuthenticator()"), @NiagaraProperty(name="requestBody", type="BRequestBody", defaultValue="new BRequestBody()"), @NiagaraProperty(name="connected", type="boolean", defaultValue="false", flags=11), @NiagaraProperty(name="lastConnected", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65601), @NiagaraProperty(name="lastSentMessage", type="String", defaultValue="BString.DEFAULT", flags=65547, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="lastSentTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65601), @NiagaraProperty(name="lastReceivedMessage", type="String", defaultValue="BString.DEFAULT", flags=65547, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="lastReceivedTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65601), @NiagaraProperty(name="outgoingQueueSize", type="int", defaultValue="0", flags=65551), @NiagaraProperty(name="incomingQueueSize", type="int", defaultValue="0", flags=65551), @NiagaraProperty(name="transport", type="BHttpTransport", defaultValue="new BHttpTransport()", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="connect", flags=16), @NiagaraAction(name="disconnect", flags=16), @NiagaraAction(name="send", flags=16)})
@NiagaraTopics(value={@NiagaraTopic(name="messageSent", eventType="BString"), @NiagaraTopic(name="messageReceived", eventType="BString")})
public class BWebsocketClient
extends BComponent
implements BIHttpCommClient,
BIHttpCommClientTransport,
BIHttpCommClientWrite,
WebsocketCallbacks {
    public static final Property enabled = BWebsocketClient.newProperty((int)0, (boolean)true, null);
    public static final Property proxy = BWebsocketClient.newProperty((int)4, (BValue)new BHttpClientGlobalCapacityExt(), null);
    public static final Property health = BWebsocketClient.newProperty((int)0, (BValue)new BWebsocketHealth(), null);
    public static final Property address = BWebsocketClient.newProperty((int)0, (BValue)new BHttpAddress(), null);
    public static final Property headers = BWebsocketClient.newProperty((int)0, (BValue)new BHttpHeaders(), null);
    public static final Property config = BWebsocketClient.newProperty((int)0, (BValue)new BWebsocketConfig(), null);
    public static final Property authenticator = BWebsocketClient.newProperty((int)0, (BValue)new BHttpAuthenticator(), null);
    public static final Property requestBody = BWebsocketClient.newProperty((int)0, (BValue)new BRequestBody(), null);
    public static final Property connected = BWebsocketClient.newProperty((int)11, (boolean)false, null);
    public static final Property lastConnected = BWebsocketClient.newProperty((int)65601, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastSentMessage = BWebsocketClient.newProperty((int)65547, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property lastSentTime = BWebsocketClient.newProperty((int)65601, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastReceivedMessage = BWebsocketClient.newProperty((int)65547, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property lastReceivedTime = BWebsocketClient.newProperty((int)65601, (BValue)BAbsTime.DEFAULT, null);
    public static final Property outgoingQueueSize = BWebsocketClient.newProperty((int)65551, (int)0, null);
    public static final Property incomingQueueSize = BWebsocketClient.newProperty((int)65551, (int)0, null);
    public static final Property transport = BWebsocketClient.newProperty((int)4, (BValue)new BHttpTransport(), null);
    public static final Action connect = BWebsocketClient.newAction((int)16, null);
    public static final Action disconnect = BWebsocketClient.newAction((int)16, null);
    public static final Action send = BWebsocketClient.newAction((int)16, null);
    public static final Topic messageSent = BWebsocketClient.newTopic((int)0, null);
    public static final Topic messageReceived = BWebsocketClient.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BWebsocketClient.class);
    public static final long MAX_QUEUE_ITEM_LENGTH = 0x100000L;
    public static final String DEFAULT_CLOSE_REASON = "NiagaraDisconnect";
    public static final Logger WS_LOGGER = Logger.getLogger("httpClient.ws");
    private final Object sessionMutex = new Object();
    private EngineCycleQueue<String> outgoingQueue;
    private EngineCycleQueue<String> incomingQueue;
    private WebsocketClientSession session;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BHttpClientGlobalCapacityExt getProxy() {
        return (BHttpClientGlobalCapacityExt)this.get(proxy);
    }

    public void setProxy(BHttpClientGlobalCapacityExt v) {
        this.set(proxy, (BValue)v, null);
    }

    @Override
    public BHttpResponseHealth getHealth() {
        return (BHttpResponseHealth)this.get(health);
    }

    @Override
    public void setHealth(BHttpResponseHealth v) {
        this.set(health, (BValue)v, null);
    }

    @Override
    public BHttpAddress getAddress() {
        return (BHttpAddress)this.get(address);
    }

    @Override
    public void setAddress(BHttpAddress v) {
        this.set(address, (BValue)v, null);
    }

    @Override
    public BHttpHeaders getHeaders() {
        return (BHttpHeaders)this.get(headers);
    }

    @Override
    public void setHeaders(BHttpHeaders v) {
        this.set(headers, (BValue)v, null);
    }

    public BWebsocketConfig getConfig() {
        return (BWebsocketConfig)this.get(config);
    }

    public void setConfig(BWebsocketConfig v) {
        this.set(config, (BValue)v, null);
    }

    @Override
    public BHttpAuthenticator getAuthenticator() {
        return (BHttpAuthenticator)this.get(authenticator);
    }

    @Override
    public void setAuthenticator(BHttpAuthenticator v) {
        this.set(authenticator, (BValue)v, null);
    }

    @Override
    public BRequestBody getRequestBody() {
        return (BRequestBody)this.get(requestBody);
    }

    public void setRequestBody(BRequestBody v) {
        this.set(requestBody, (BValue)v, null);
    }

    public boolean getConnected() {
        return this.getBoolean(connected);
    }

    public void setConnected(boolean v) {
        this.setBoolean(connected, v, null);
    }

    public BAbsTime getLastConnected() {
        return (BAbsTime)this.get(lastConnected);
    }

    public void setLastConnected(BAbsTime v) {
        this.set(lastConnected, (BValue)v, null);
    }

    public String getLastSentMessage() {
        return this.getString(lastSentMessage);
    }

    public void setLastSentMessage(String v) {
        this.setString(lastSentMessage, v, null);
    }

    public BAbsTime getLastSentTime() {
        return (BAbsTime)this.get(lastSentTime);
    }

    public void setLastSentTime(BAbsTime v) {
        this.set(lastSentTime, (BValue)v, null);
    }

    public String getLastReceivedMessage() {
        return this.getString(lastReceivedMessage);
    }

    public void setLastReceivedMessage(String v) {
        this.setString(lastReceivedMessage, v, null);
    }

    public BAbsTime getLastReceivedTime() {
        return (BAbsTime)this.get(lastReceivedTime);
    }

    public void setLastReceivedTime(BAbsTime v) {
        this.set(lastReceivedTime, (BValue)v, null);
    }

    public int getOutgoingQueueSize() {
        return this.getInt(outgoingQueueSize);
    }

    public void setOutgoingQueueSize(int v) {
        this.setInt(outgoingQueueSize, v, null);
    }

    public int getIncomingQueueSize() {
        return this.getInt(incomingQueueSize);
    }

    public void setIncomingQueueSize(int v) {
        this.setInt(incomingQueueSize, v, null);
    }

    @Override
    public BHttpTransport getTransport() {
        return (BHttpTransport)this.get(transport);
    }

    @Override
    public void setTransport(BHttpTransport v) {
        this.set(transport, (BValue)v, null);
    }

    public void connect() {
        this.invoke(connect, null, null);
    }

    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    @Override
    public void send() {
        this.invoke(send, null, null);
    }

    public void fireMessageSent(BString event) {
        this.fire(messageSent, (BValue)event, null);
    }

    public void fireMessageReceived(BString event) {
        this.fire(messageReceived, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (Sys.isStation()) {
            this.incomingQueue = new EngineCycleQueue<String>(this.getSlotPath().toString() + "/incomingQueue", this::handleIncomingMessage, this.getConfig().getSleepMillisBetweenDequeues(), this.getConfig().getIncomingMessageQueueSize());
            this.outgoingQueue = new EngineCycleQueue<String>(this.getSlotPath().toString() + "/outgoingQueue", this::sendOutgoingMessage, this.getConfig().getSleepMillisBetweenDequeues(), this.getConfig().getOutgoingMessageQueueSize());
            HttpClientRegister.registerClient(this);
        }
    }

    public void atSteadyState() {
        if (this.getEnabled() && this.getConfig().getWriteOnStart()) {
            this.send();
        }
    }

    public void stopped() {
        if (Sys.isStation()) {
            this.disconnectSession(true);
            if (this.incomingQueue != null) {
                this.incomingQueue.stop();
            }
            if (this.outgoingQueue != null) {
                this.outgoingQueue.stop();
            }
            HttpClientRegister.unregisterClient(this);
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning()) {
            if (property.equals(enabled)) {
                if (this.getEnabled() && this.getConfig().getWriteOnEnabled()) {
                    this.send();
                } else if (!this.getEnabled()) {
                    this.disconnectSession(false);
                }
            }
            if (property.equals(address)) {
                HttpClientUtils.auditAddressChange(this.getAddress(), context);
            }
            if (property.equals(connected) && !this.getConnected() && this.getAuthenticator().getConfig() instanceof SessionBasedAuth) {
                ((SessionBasedAuth)((Object)this.getAuthenticator().getConfig())).endSession();
            }
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        return BHttpClientService.post(this, action, argument, cx);
    }

    @Override
    public void writeRequested() {
        this.send();
    }

    public void doConnect(Context cx) {
        if (this.getEnabled() && BHttpClientService.permittedByService((BIHttpCommClient)this, cx)) {
            this.connectSession();
        }
    }

    public void doDisconnect() {
        this.disconnectSession(false);
    }

    public void doSend(Context cx) {
        this.connectAndSend(cx);
    }

    private void connectAndSend(Context cx) {
        if (!this.getEnabled() || !BHttpClientService.permittedByService((BIHttpCommClient)this, cx)) {
            return;
        }
        this.connectSession();
        try {
            if (this.getPayloadSource().length() <= 0x100000L) {
                this.queueOutgoingMessage(InputStreamUtil.streamToString(this.getPayloadSource().getStream()));
            } else {
                this.sendOutgoingMessage(this.getPayloadSource().getStream(), this.getPayloadSource().length());
            }
        }
        catch (Exception e) {
            this.getHealth().updateHealth(BStatus.fault, "Failed to queue outgoing message", e);
            this.getWsMetrics().messageNotQueued(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectSession(boolean stopping) {
        Object object = this.sessionMutex;
        synchronized (object) {
            if (this.session != null && this.session.isConnected()) {
                PrefixLogUtil.logWithPrefix(WS_LOGGER, Level.FINE, () -> "Disconnecting ws session (stopping:" + stopping + ')', (Object)this);
                try {
                    this.session.disconnect(stopping);
                    this.session = null;
                    this.setConnected(false);
                }
                catch (HttpCommException e) {
                    PrefixLogUtil.logWithPrefix(WS_LOGGER, Level.WARNING, "Failed to disconnect", (Throwable)((Object)e), (Object)this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectSession() {
        if (!this.isRunning()) {
            return;
        }
        this.checkPermissions();
        try {
            LicenseUtil.licenseCheck();
        }
        catch (Exception e) {
            this.getHealth().updateHealth(BStatus.fault, "Licensed check fail", e);
            return;
        }
        Object object = this.sessionMutex;
        synchronized (object) {
            if (this.session == null) {
                PrefixLogUtil.logWithPrefix(WS_LOGGER, Level.FINE, "Creating ws session", (Object)this);
                this.session = new JettyWebsocketClientSession();
                this.session.init(this, this.getConfig());
            }
            if (!this.session.isConnected()) {
                try {
                    int responseCode = this.session.connect(this.getAddress(), this.getHeaders(), this.getAuthenticator().getConfig(), this.getConfig().getConnectionAttemptTimeout().getMillis());
                    this.getHealth().setLastResponseCode(responseCode);
                }
                catch (HttpCommException e) {
                    this.connectionDown("Session connection failed", -1, (Exception)((Object)e));
                    this.getWsMetrics().connectionResult(false);
                }
            }
        }
    }

    @Override
    public void messageReceived(String sessionId, String incomingMessage) {
        PrefixLogUtil.logWithPrefix(WS_LOGGER, Level.FINE, () -> String.format("Received %d bytes message from: %s", incomingMessage.getBytes(StandardCharsets.UTF_8).length, sessionId), (Object)this);
        this.incomingQueue.setMaxQueueSize(this.getConfig().getIncomingMessageQueueSize());
        try {
            this.incomingQueue.performEnqueue(incomingMessage);
        }
        catch (Exception e) {
            this.getHealth().updateHealth(BStatus.fault, "Failed to queue incoming message", e);
            this.getWsMetrics().messageNotQueued(true);
        }
        this.setIncomingQueueSize(this.incomingQueue.size());
    }

    @Override
    public void onError(Exception cause) {
        PrefixLogUtil.logWithPrefix(WS_LOGGER, Level.SEVERE, "WebSocket Error", (Throwable)cause, (Object)this);
        this.getWsMetrics().error();
        this.getHealth().updateHealth(BStatus.fault, "Ws error received", cause);
    }

    @Override
    public void sessionConnected(String sessionId) {
        PrefixLogUtil.logWithPrefix(WS_LOGGER, Level.FINE, () -> String.format("Connected to ws session: %s", sessionId), (Object)this);
        this.setConnected(true);
        this.setLastConnected(BAbsTime.now());
        this.getWsMetrics().connectionResult(true);
        this.getHealth().clearFault();
    }

    @Override
    public void sessionDisconnected(String sessionId, int statusCode, String fault, Exception exception) {
        PrefixLogUtil.logWithPrefix(WS_LOGGER, Level.FINE, () -> String.format("Connection to ws session closed: %s code: %d", sessionId, statusCode), (Object)this);
        this.connectionDown(fault, statusCode, exception);
    }

    private void connectionDown(String fault, int statusCode, Exception exception) {
        boolean expectedDisconnect;
        this.setConnected(false);
        BStatus status = BStatus.down;
        this.getHealth().setStatus(BStatus.make((int)(this.getHealth().getStatus().getBits() | 4)));
        if (statusCode == -1 && exception instanceof HttpCommException) {
            statusCode = ((HttpCommException)((Object)exception)).getResponseCode();
        }
        this.getHealth().setLastResponseCode(statusCode);
        boolean bl = expectedDisconnect = fault.equals(DEFAULT_CLOSE_REASON) || statusCode == 1000;
        if (!expectedDisconnect) {
            status = BStatus.make((int)(status.getBits() | 2));
        }
        this.getWsMetrics().disconnected(expectedDisconnect);
        this.getHealth().updateHealth(status, fault, exception);
    }

    private void queueOutgoingMessage(String message) {
        if (this.outgoingQueue == null) {
            throw new IllegalStateException("Illegal state: no outgoing message queue available");
        }
        if (!this.getConnected()) {
            throw new IllegalStateException("Illegal state: socket not connected, cannot queue message");
        }
        this.outgoingQueue.setMaxQueueSize(this.getConfig().getOutgoingMessageQueueSize());
        this.outgoingQueue.performEnqueue(message);
        this.setOutgoingQueueSize(this.outgoingQueue.size());
    }

    private void sendOutgoingMessage(String message) {
        this.sendOutgoingMessage(new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)), message.getBytes(StandardCharsets.UTF_8).length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOutgoingMessage(InputStream messageBytes, long length) {
        HttpCommException exception = null;
        WsMessageEvent messageEvent = WsMessageEvent.outbound(0x100000L, messageBytes, length);
        Object object = this.sessionMutex;
        synchronized (object) {
            if (this.session != null && this.session.isConnected()) {
                try {
                    messageEvent = this.session.sendBytes(messageEvent, this.getConfig().getSendMessageTimeout().getMillis());
                    this.setLastSentMessage(messageEvent.getMessageContent());
                    this.setLastSentTime(BAbsTime.now());
                    this.fireMessageSent(BString.make((String)messageEvent.getMessageContent()));
                    this.getHealth().clearFault();
                    messageEvent.succeeded();
                }
                catch (HttpCommException e) {
                    exception = e;
                }
            } else {
                exception = new HttpCommException("Bad state, no connected websocket session");
            }
        }
        if (exception != null) {
            PrefixLogUtil.logWithPrefix(WS_LOGGER, Level.SEVERE, "Failed to send ws message", (Throwable)((Object)exception), (Object)this);
            this.getHealth().updateHealth(BStatus.fault, "Failed to send ws message", (Exception)((Object)exception));
        } else {
            this.getHealth().clearFault();
        }
        HttpClientUtils.updateConsumers(this, messageEvent);
    }

    private void handleIncomingMessage(String incomingMessage) {
        WsMessageEvent messageEvent = WsMessageEvent.inbound(incomingMessage);
        this.setLastReceivedMessage(incomingMessage);
        this.setLastReceivedTime(BAbsTime.now());
        this.fireMessageReceived(BString.make((String)incomingMessage));
        HttpClientUtils.updateConsumers(this, messageEvent);
        this.getHealth().clearFault();
    }

    public BWebsocketMetrics getWsMetrics() {
        return ((BWebsocketHealth)this.getHealth().as(BWebsocketHealth.class)).getWsMetrics();
    }

    @Override
    public String identifierForLogs() {
        return this.getName();
    }

    public BIcon getIcon() {
        return HttpClientUtils.HTTP_EXPORT_ICON;
    }

    @Override
    public BHttpRequestMethod getMethod() {
        return BHttpRequestMethod.get;
    }

    @Override
    public void setMethod(BHttpRequestMethod x) {
    }

    @Override
    public BHttpParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(BHttpParameters x) {
    }

    @Override
    public BHttpTuningPolicy getHttpTuningPolicy() {
        return new BHttpTuningPolicy();
    }

    @Override
    public String sendSync() {
        throw new BajaRuntimeException("sendSync on websocket unsupported");
    }

    @Override
    public final boolean isDriverBasedClient() {
        return false;
    }

    private void checkPermissions() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(this.getAddress().getHostAddress(), this.getAddress().getPort());
        }
    }
}

