/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.util.sec;

import com.tridiumeurope.httpClient.BHttpClientService;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClient;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClientTransport;
import com.tridiumeurope.httpClient.comm.transport.okHttp.BOkHttpTransport;
import com.tridiumeurope.httpClient.datatypes.auth.BBasicHttpAuth;
import com.tridiumeurope.httpClient.datatypes.auth.BHttpAuthenticator;
import com.tridiumeurope.httpClient.datatypes.enums.BHttpMode;
import com.tridiumeurope.httpClient.datatypes.exception.HttpClientException;
import com.tridiumeurope.httpClient.driver.ping.BHttpClientPingAddress;
import com.tridiumeurope.httpClient.driver.point.BHttpClientProxyExt;
import com.tridiumeurope.httpClient.util.HttpClientRegister;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.LicenseUtil;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"httpClient:HttpClientService"})})
public final class BHttpClientSecurityDashboardAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    public static final Type TYPE = Sys.loadType(BHttpClientSecurityDashboardAgent.class);
    private SecurityDashboardItemBuilder builder;
    private BHttpClientService httpClientService;
    private static final String SECTION_HEADER = "securityDashboard.httpClient.sectionHeader";
    private static final int SECURITY_DASHBOARD_ITEMS_VERSION = 1;
    public static final String OK_SUFFIX = ".ok";
    public static final String INSECURE_SUMMARY = "securityDashboard.httpClient.tls.enabled.summary";
    public static final String INSECURE_DESCRIPTION = "securityDashboard.httpClient.tls.enabled.desc";
    public static final String BASIC_SUMMARY = "securityDashboard.httpClient.basic.summary";
    public static final String BASIC_DESCRIPTION = "securityDashboard.httpClient.basic.desc";
    public static final String COMPAT_TLS_SUMMARY = "securityDashboard.httpClient.compatible.tls.summary";
    public static final String COMPAT_TLS_DESCRIPTION = "securityDashboard.httpClient.compatible.tls.desc";
    public static final String NON_DRIVER_CLIENTS_SUMMARY = "securityDashboard.httpClient.nondriver.summary";
    public static final String NON_DRIVER_CLIENTS_DESCRIPTION = "securityDashboard.httpClient.nondriver.desc";
    public static final String SMA_EXPIRED_SUMMARY = "securityDashboard.httpClient.sma.expired.summary";
    public static final String SMA_EXPIRED_DESCRIPTION = "securityDashboard.httpClient.sma.expired.desc";
    public static final String SMA_EXPIRING_SUMMARY = "securityDashboard.httpClient.sma.expiring.summary";
    public static final String SMA_EXPIRING_DESCRIPTION = "securityDashboard.httpClient.sma.expiring.desc";
    public static final String SMA_OK_SUMMARY = "securityDashboard.httpClient.sma.ok.summary";
    public static final String SMA_OK_DESCRIPTION = "securityDashboard.httpClient.sma.ok.desc";

    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.httpClientService = (BHttpClientService)object.as(BHttpClientService.class);
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)SECTION_HEADER);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.httpClientService.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        this.checkClientsForWarning(items, INSECURE_SUMMARY, INSECURE_DESCRIPTION, BHttpClientService.enableInsecureHttp, BHttpClientSecurityDashboardAgent::isInsecure, cx);
        this.checkClientsForWarning(items, BASIC_SUMMARY, BASIC_DESCRIPTION, BHttpClientSecurityDashboardAgent::isUsingBasicAuth, cx);
        this.checkClientsForWarning(items, COMPAT_TLS_SUMMARY, COMPAT_TLS_DESCRIPTION, BHttpClientSecurityDashboardAgent::isUsingCompatibleTls, cx);
        this.checkClientsForWarning(items, NON_DRIVER_CLIENTS_SUMMARY, NON_DRIVER_CLIENTS_DESCRIPTION, BHttpClientService.enableNonDriverClients, BHttpClientSecurityDashboardAgent::isNonDriverClient, cx);
        if (!LicenseUtil.isSmaExempt()) {
            this.checkSmaExpiry(items);
        }
        return Collections.unmodifiableList(items);
    }

    private void checkClientsForWarning(List<SecurityDashboardItem> items, String summaryKey, String descriptionKey, Property svcProperty, Predicate<BIHttpCommClient> secCheck, Context cx) {
        try {
            BHttpClientService service = BHttpClientService.service();
            if (service != null && service.get(svcProperty).equals((Object)BBoolean.TRUE)) {
                this.checkClientsForWarning(items, summaryKey, descriptionKey, secCheck, cx);
            } else {
                items.add(this.builder.makeOk().withSummary(summaryKey + OK_SUFFIX, new Object[0]).withDescription(descriptionKey, new Object[0]));
            }
        }
        catch (HttpClientException e) {
            PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINE, () -> "Skipped http client service check: " + svcProperty.getName(), (Object)this);
        }
    }

    private void checkClientsForWarning(List<SecurityDashboardItem> items, String summaryKey, String descriptionKey, Predicate<BIHttpCommClient> secCheck, Context cx) {
        List<String> warningClients = HttpClientRegister.getClients().stream().filter(secCheck).map(commClient -> BHttpClientSecurityDashboardAgent.getClientName(commClient, cx)).sorted().collect(Collectors.toList());
        this.createWarning(items, summaryKey, descriptionKey, warningClients);
    }

    private void createWarning(List<SecurityDashboardItem> items, String summaryKey, String descriptionKey, List<String> warningClients) {
        if (!warningClients.isEmpty()) {
            items.add(this.builder.makeWarning().withSummary(summaryKey, new Object[]{String.join((CharSequence)", ", warningClients)}).withDescription(descriptionKey, new Object[0]));
        } else {
            items.add(this.builder.makeOk().withSummary(summaryKey + OK_SUFFIX, new Object[0]).withDescription(descriptionKey, new Object[0]));
        }
    }

    private static boolean isInsecure(BIHttpCommClient client) {
        return client.getAddress().isConfigured() && client.getAddress().getMode() == BHttpMode.insecure;
    }

    private static boolean isUsingBasicAuth(BIHttpCommClient client) {
        if (!(client instanceof BHttpClientProxyExt)) {
            BIHttpCommClientTransport transport = BHttpClientSecurityDashboardAgent.getTransport(client);
            BHttpAuthenticator authenticator = transport.getAuthenticator();
            return authenticator.getAuthType().equals((Object)BBasicHttpAuth.TYPE.getTypeSpec());
        }
        return false;
    }

    private static boolean isUsingCompatibleTls(BIHttpCommClient client) {
        if (!(client instanceof BHttpClientProxyExt)) {
            BIHttpCommClientTransport transport = BHttpClientSecurityDashboardAgent.getTransport(client);
            return transport.getTransport().getComm() instanceof BOkHttpTransport && ((BOkHttpTransport)transport.getTransport().getComm()).isCompatibleTls();
        }
        return false;
    }

    private static BIHttpCommClientTransport getTransport(BIHttpCommClient client) {
        if (client instanceof BIHttpCommClientTransport) {
            return (BIHttpCommClientTransport)client.as(BIHttpCommClientTransport.class);
        }
        return HttpClientUtils.getParent((BComplex)client, BIHttpCommClientTransport.class);
    }

    private void checkSmaExpiry(List<SecurityDashboardItem> items) {
        Optional<Long> smaExpirationMillis = LicenseUtil.getSmaExpiration();
        if (smaExpirationMillis.isPresent()) {
            BAbsTime expiration = BAbsTime.make((long)smaExpirationMillis.get());
            if (BAbsTime.now().isAfter(expiration)) {
                items.add(this.builder.makeAlert().withSummary(SMA_EXPIRED_SUMMARY, new Object[0]).withDescription(SMA_EXPIRED_DESCRIPTION, new Object[0]));
            } else {
                int daysRemaining = Math.abs(expiration.delta(BAbsTime.now()).getDays());
                if (daysRemaining <= 15) {
                    items.add(this.builder.makeAlert().withSummary(SMA_EXPIRING_SUMMARY, new Object[0]).withDescription(SMA_EXPIRING_DESCRIPTION, new Object[]{daysRemaining}));
                } else if (daysRemaining <= 30) {
                    items.add(this.builder.makeWarning().withSummary(SMA_EXPIRING_SUMMARY, new Object[0]).withDescription(SMA_EXPIRING_DESCRIPTION, new Object[]{daysRemaining}));
                } else {
                    items.add(this.builder.makeOk().withSummary(SMA_OK_SUMMARY, new Object[0]).withDescription(SMA_OK_DESCRIPTION, new Object[]{daysRemaining}));
                }
            }
        }
    }

    private static boolean isNonDriverClient(BIHttpCommClient client) {
        return !client.isDriverBasedClient();
    }

    private static String getClientName(Object client, Context cx) {
        if (client instanceof BHttpClientProxyExt) {
            return ((BHttpClientProxyExt)client).getParentPoint().getName();
        }
        if (client instanceof BHttpClientPingAddress) {
            return ((BHttpClientPingAddress)client).getParent().getName();
        }
        if (client instanceof BComplex) {
            return ((BComplex)client).getDisplayName(cx);
        }
        return "Unknown";
    }
}

