/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.util.queue;

import com.tridium.sys.Nre;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.IPrefixLoggable;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.security.AccessController;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.util.QueueFullException;

public class EngineCycleQueue<T>
implements IPrefixLoggable {
    private final Runnable emptier = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PrefixLogUtil.logWithPrefix(log, Level.FINE, "init emptier", (Object)EngineCycleQueue.this);
            try {
                int lastCycle = EngineCycleQueue.getCurrentCycles();
                PrefixLogUtil.logWithPrefix(log, Level.FINE, "lastCycle:" + lastCycle, (Object)EngineCycleQueue.this);
                while (!EngineCycleQueue.this.stopping) {
                    int currentCycle = EngineCycleQueue.getCurrentCycles();
                    int logLastCycle = lastCycle;
                    PrefixLogUtil.logWithPrefix(log, Level.FINEST, () -> String.format("CUR:%s LAST:%s >? %s", currentCycle, logLastCycle, currentCycle > logLastCycle), (Object)EngineCycleQueue.this);
                    if (currentCycle > lastCycle) {
                        Object next = EngineCycleQueue.this.getQueue().take();
                        lastCycle = EngineCycleQueue.getCurrentCycles();
                        PrefixLogUtil.logWithPrefix(log, Level.FINE, () -> currentCycle + " De-queueing: " + next, (Object)EngineCycleQueue.this);
                        EngineCycleQueue.this.messageConsumer.accept(next);
                    } else {
                        PrefixLogUtil.logWithPrefix(log, Level.FINEST, () -> String.format("waitingForNextCycle: %s/%s", logLastCycle, currentCycle), (Object)EngineCycleQueue.this);
                    }
                    try {
                        Thread.sleep(EngineCycleQueue.this.sleepBetweenDequeues);
                    }
                    catch (InterruptedException e) {
                        PrefixLogUtil.logWithPrefix(log, Level.FINE, "Sleep interrupted", (Throwable)e, (Object)EngineCycleQueue.this);
                        throw e;
                    }
                    PrefixLogUtil.logWithPrefix(log, Level.FINE, () -> "queueSize:" + EngineCycleQueue.this.getQueue().size(), (Object)EngineCycleQueue.this);
                }
            }
            catch (InterruptedException ie) {
                if (!EngineCycleQueue.this.stopping) {
                    PrefixLogUtil.logWithPrefix(log, Level.WARNING, "IException whilst emptying ", (Throwable)ie, (Object)EngineCycleQueue.this);
                }
            }
            catch (Exception e) {
                PrefixLogUtil.logWithPrefix(log, Level.WARNING, "Exception whilst emptying ", (Throwable)e, (Object)EngineCycleQueue.this);
            }
            finally {
                PrefixLogUtil.logWithPrefix(log, Level.FINE, "Finished emptying queue", (Object)EngineCycleQueue.this);
            }
        }
    };
    private long sleepBetweenDequeues;
    private int maxQueueSize;
    private boolean stopping;
    private Thread thread;
    private LinkedBlockingQueue<T> queue;
    private final String queueId;
    private final Consumer<T> messageConsumer;
    private static final Object QUEUE_SYNC = new Object();
    private static final Logger log = HttpClientUtils.child("messageQueue");

    public EngineCycleQueue(String queueId, Consumer<T> messageConsumer, long sleepBetweenDequeues, int maxQueueSize) {
        this.queueId = queueId;
        this.messageConsumer = messageConsumer;
        this.sleepBetweenDequeues = sleepBetweenDequeues;
        this.maxQueueSize = maxQueueSize;
    }

    public void setSleepBetweenDequeues(long sleepBetweenDequeues) {
        this.sleepBetweenDequeues = sleepBetweenDequeues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxQueueSize(int maxQueueSize) {
        Object object = QUEUE_SYNC;
        synchronized (object) {
            if (maxQueueSize == this.maxQueueSize) {
                return;
            }
            this.maxQueueSize = maxQueueSize;
            LinkedBlockingQueue temp = this.queue;
            this.queue = new LinkedBlockingQueue(maxQueueSize);
            if (temp != null) {
                temp.drainTo(this.queue, maxQueueSize);
                if (!temp.isEmpty()) {
                    PrefixLogUtil.logWithPrefix(log, Level.WARNING, () -> String.format("Queue dropping %s messages as max size reduced", temp.size()), (Object)this);
                    temp.clear();
                }
            }
        }
    }

    public void stop() {
        this.stopping = true;
        try {
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, String.format("Stopping Queue, %s items discarded", this.getQueue().size()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedBlockingQueue<T> getQueue() {
        Object object = QUEUE_SYNC;
        synchronized (object) {
            if (this.queue == null) {
                this.queue = new LinkedBlockingQueue(this.maxQueueSize);
            }
            return this.queue;
        }
    }

    public int size() {
        return this.getQueue().size();
    }

    public void performEnqueue(T message) {
        PrefixLogUtil.logWithPrefix(log, Level.FINE, () -> "enqueueing: " + message, (Object)this);
        if (!this.getQueue().offer(message)) {
            throw new QueueFullException();
        }
        if (this.thread == null || this.thread.getState() == Thread.State.TERMINATED) {
            this.thread = this.getThread();
        }
        if (this.thread.getState() == Thread.State.NEW) {
            PrefixLogUtil.logWithPrefix(log, Level.FINE, "Starting emptier thread", (Object)this);
            this.thread.start();
        }
    }

    private Thread getThread() {
        return new Thread(this.emptier, log.getName());
    }

    private static int getCurrentCycles() {
        return AccessController.doPrivileged(Nre::getEngineManager).getCycles();
    }

    @Override
    public String identifierForLogs() {
        return "queue@" + this.queueId;
    }
}

