/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.util;

import com.tridium.json.JSONObject;
import com.tridiumeurope.httpClient.datatypes.options.BMultiAddOptions;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.io.IOException;
import java.security.AccessController;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.CannotValidateException;

public final class MultiAddUtil {
    private static final int ADD_MORE_COORD_SPACING = 4;

    private MultiAddUtil() {
    }

    public static void addMulti(BComponent sourceComponent, BMultiAddOptions options) {
        options.validateOutput();
        JSONObject toCreateJson = new JSONObject(options.getToCreate());
        boolean includeParent = options.getIncludeParent();
        BComponent componentToAddto = includeParent ? sourceComponent.getParent().getParent().asComponent() : sourceComponent.getParent().asComponent();
        AtomicInteger index = new AtomicInteger();
        Iterator jsonKeys = toCreateJson.keys();
        new Thread(() -> {
            while (jsonKeys.hasNext()) {
                try {
                    String newName = (String)jsonKeys.next();
                    JSONObject propertiesToPopulate = toCreateJson.getJSONObject(newName);
                    BComplex newInstance = MultiAddUtil.addNewInstance(newName, componentToAddto, sourceComponent, options, propertiesToPopulate);
                    MultiAddUtil.updateCoords(includeParent ? newInstance.getParent() : newInstance, index.incrementAndGet());
                }
                catch (Exception e) {
                    PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.SEVERE, "Failed to add copy", (Throwable)e, (Object)sourceComponent);
                }
            }
        }, "addMoreThread").start();
    }

    private static BComplex addNewInstance(String name, BComponent componentToAddto, BComponent sourceComponent, BMultiAddOptions options, JSONObject propertiesToPopulate) throws IOException {
        BComplex newInstance = AccessController.doPrivileged(() -> sourceComponent.newCopy().asComplex());
        Iterator properties = propertiesToPopulate.keys();
        while (properties.hasNext()) {
            String propertyPath = (String)properties.next();
            MultiAddUtil.setValueAtDottedPath(newInstance, propertyPath, propertiesToPopulate.getString(propertyPath));
        }
        MultiAddUtil.disable(newInstance);
        if (options.getIncludeParent()) {
            BComponent parentCopy = sourceComponent.getParent().asComponent().newCopy().asComponent();
            parentCopy.set(sourceComponent.getPropertyInParent(), (BValue)newInstance);
            componentToAddto.add(name, (BValue)parentCopy);
        } else {
            componentToAddto.add(name, (BValue)newInstance);
        }
        return newInstance;
    }

    public static BSimple getSimpleAtDottedPath(BComplex complex, String propPath) {
        while (propPath.contains(".")) {
            int firstDot = propPath.indexOf(46);
            String childName = propPath.substring(0, firstDot);
            propPath = propPath.substring(firstDot + 1);
            complex = complex.get(childName).asComplex().loadSlots();
        }
        complex.loadSlots();
        return complex.get(propPath).asSimple();
    }

    private static void setValueAtDottedPath(BComplex complex, String propPath, String encodedValue) throws IOException {
        if (propPath.contains(".")) {
            int firstDot = propPath.indexOf(46);
            String childName = propPath.substring(0, firstDot);
            MultiAddUtil.setValueAtDottedPath(complex.get(childName).asComplex(), propPath.substring(firstDot + 1), encodedValue);
        } else {
            Property property = complex.getProperty(propPath);
            BObject obj = property.getType().getInstance();
            if (obj.isSimple()) {
                complex.set(propPath, (BValue)obj.asSimple().decodeFromString(encodedValue).asSimple());
            } else {
                throw new CannotValidateException("Only Simple types supported by addMore");
            }
        }
    }

    private static void disable(BComplex newInstance) {
        if (newInstance.get("enabled") != null) {
            newInstance.set("enabled", (BValue)BBoolean.FALSE);
        }
    }

    private static void updateCoords(BComplex newInstance, int multiplier) {
        BValue value = newInstance.get("wsAnnotation");
        if (value instanceof BWsAnnotation) {
            BWsAnnotation annotation = (BWsAnnotation)value.as(BWsAnnotation.class);
            int newP = annotation.p + multiplier * 4;
            int newQ = annotation.q + multiplier * 4;
            newInstance.set("wsAnnotation", (BValue)BWsAnnotation.make((int)newP, (int)newQ, (int)annotation.wixelWidth, (int)annotation.wixelHeight));
        }
    }
}

