/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class ModuleThreadPool {
    private static final String THREAD_COUNT_PROPERTY = "com.tridium.moduleThreadPool.threads.default";
    private static final String MAX_THREADS_PROPERTY = "com.tridium.moduleThreadPool.threads.max";
    private static final int DEFAULT_THREAD_COUNT = System.getProperty("com.tridium.moduleThreadPool.threads.default") != null ? Integer.parseInt(System.getProperty("com.tridium.moduleThreadPool.threads.default")) : 10;
    private static final int MAX_ALLOWED_THREADS = System.getProperty("com.tridium.moduleThreadPool.threads.max") != null ? Integer.parseInt(System.getProperty("com.tridium.moduleThreadPool.threads.max")) : 500;
    private static final ModuleThreadPool INSTANCE = new ModuleThreadPool();
    private static final Logger LOG = Logger.getLogger("baja");
    private static BAbsTime lastDebugDump = BAbsTime.DEFAULT;
    private final Object sync = new Object();
    private final String moduleName = "httpClient";
    private final AtomicInteger threadNumber = new AtomicInteger(0);
    private ThreadPoolExecutor executorService;
    private Integer threadPoolSize = DEFAULT_THREAD_COUNT;

    private ModuleThreadPool() {
    }

    public static ModuleThreadPool getInstance() {
        return INSTANCE;
    }

    public IFuture post(BComponent instance, Action action, BValue argument, Context cx) {
        this.getPool().execute((Runnable)new Invocation(instance, action, argument, cx));
        return null;
    }

    public <T> Future<T> submit(Callable<T> callable) {
        return this.getPool().submit(callable);
    }

    public Future<?> submit(Runnable runnable) {
        return this.getPool().submit(runnable);
    }

    public void setMaxThreadPoolSize(int maxThreadPoolSize) {
        if (maxThreadPoolSize < 1) {
            throw new IllegalArgumentException("Positive value required for thread pool size");
        }
        if (maxThreadPoolSize > MAX_ALLOWED_THREADS) {
            throw new IllegalArgumentException("Maximum module thread pool size is " + MAX_ALLOWED_THREADS);
        }
        this.threadPoolSize = maxThreadPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getPool() {
        Object object = this.sync;
        synchronized (object) {
            if (this.executorService == null) {
                this.executorService = this.createExecutor();
            } else if (this.executorService.getMaximumPoolSize() != this.threadPoolSize.intValue()) {
                this.changePoolSize();
            }
            ModuleThreadPool.dumpDebug();
            return this.executorService;
        }
    }

    private ThreadPoolExecutor createExecutor() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
        }));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Module Thread Pool created for module: httpClient");
        }
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(this.threadPoolSize, runnable -> new Thread(runnable, "httpClient-MTP-" + this.threadNumber.getAndIncrement()));
    }

    private void changePoolSize() {
        this.executorService.setCorePoolSize(this.threadPoolSize);
        this.executorService.setMaximumPoolSize(this.threadPoolSize);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("Module Thread Pool size changed to: %s, for module: %s", this.threadPoolSize, "httpClient"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = ModuleThreadPool.INSTANCE.sync;
        synchronized (object) {
            ThreadPoolExecutor executorService;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Shutting down Module Thread Pool for module: " + ModuleThreadPool.INSTANCE.moduleName);
            }
            if ((executorService = ModuleThreadPool.INSTANCE.executorService) != null) {
                executorService.shutdown();
                ModuleThreadPool.INSTANCE.executorService = null;
            }
        }
    }

    private static void dumpDebug() {
        if (LOG.isLoggable(Level.FINE) && lastDebugDump.isBefore(BAbsTime.now().subtract(BRelTime.makeMinutes((int)5)))) {
            if (ModuleThreadPool.INSTANCE.executorService != null) {
                LOG.fine(String.format("Module Thread Pool [%s], size [%s], max [%s], largest [%s], active [%s]", ModuleThreadPool.INSTANCE.moduleName, ModuleThreadPool.INSTANCE.executorService.getPoolSize(), ModuleThreadPool.INSTANCE.executorService.getMaximumPoolSize(), ModuleThreadPool.INSTANCE.executorService.getLargestPoolSize(), ModuleThreadPool.INSTANCE.executorService.getActiveCount()));
            }
            lastDebugDump = BAbsTime.now();
        }
    }
}

