/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.util;

import com.tridiumeurope.httpClient.BHttpClientService;
import com.tridiumeurope.httpClient.util.BSMAExpirationMonitorMode;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.LicenseUtil;
import com.tridiumeurope.httpClient.util.ModuleThreadPool;
import com.tridiumeurope.httpClient.util.ParentLegal;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="exempt", type="boolean", defaultValue="false", flags=7), @NiagaraProperty(name="mode", type="BSMAExpirationMonitorMode", defaultValue="BSMAExpirationMonitorMode.DEFAULT", flags=264), @NiagaraProperty(name="warnBelow", type="int", defaultValue="30", flags=264, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"day\")"), @Facet(name="BFacets.MIN", value="BInteger.make(1)"), @Facet(name="BFacets.MAX", value="BInteger.make(180)")}), @NiagaraProperty(name="checkInterval", type="BRelTime", defaultValue="BRelTime.DAY", flags=261), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="remaining", type="BStatusNumeric", defaultValue="new BStatusNumeric(-1, BStatus.stale)", flags=9, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"day\")"), @Facet(name="BFacets.PRECISION", value="BInteger.make(0)")})})
@NiagaraActions(value={@NiagaraAction(name="checkMaintenanceExpiration", flags=16), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
public class BSMAExpirationMonitor
extends BComponent
implements BIAlarmSource {
    public static final Property exempt = BSMAExpirationMonitor.newProperty((int)7, (boolean)false, null);
    public static final Property mode = BSMAExpirationMonitor.newProperty((int)264, (BValue)BSMAExpirationMonitorMode.DEFAULT, null);
    public static final Property warnBelow = BSMAExpirationMonitor.newProperty((int)264, (int)30, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"day")), (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1))), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)180))));
    public static final Property checkInterval = BSMAExpirationMonitor.newProperty((int)261, (BValue)BRelTime.DAY, null);
    public static final Property alarmSourceInfo = BSMAExpirationMonitor.newProperty((int)0, (BValue)BSMAExpirationMonitor.initAlarmSourceInfo(), null);
    public static final Property remaining = BSMAExpirationMonitor.newProperty((int)9, (BValue)new BStatusNumeric(-1.0, BStatus.stale), (BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"day")), (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0))));
    public static final Action checkMaintenanceExpiration = BSMAExpirationMonitor.newAction((int)16, null);
    public static final Action ackAlarm = BSMAExpirationMonitor.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BSMAExpirationMonitor.class);
    private static final BIcon icon = BIcon.std((String)"monitor.png");
    private Clock.Ticket smaSchedule = Clock.expiredTicket;
    private AlarmSupport alarmSupport;
    private Long testExpiration;
    static final Logger log = HttpClientUtils.child("smaMonitor");
    private static final String LOG_WARNING = "HttpClient requires active Software Maintenance. Remaining  days: ";
    private static final String LOG_NO_SMA = "HttpClient requires active Software Maintenance.  No active maintenance found in license";
    private final Object checkLock = new Object();

    public boolean getExempt() {
        return this.getBoolean(exempt);
    }

    public void setExempt(boolean v) {
        this.setBoolean(exempt, v, null);
    }

    public BSMAExpirationMonitorMode getMode() {
        return (BSMAExpirationMonitorMode)this.get(mode);
    }

    public void setMode(BSMAExpirationMonitorMode v) {
        this.set(mode, (BValue)v, null);
    }

    public int getWarnBelow() {
        return this.getInt(warnBelow);
    }

    public void setWarnBelow(int v) {
        this.setInt(warnBelow, v, null);
    }

    public BRelTime getCheckInterval() {
        return (BRelTime)this.get(checkInterval);
    }

    public void setCheckInterval(BRelTime v) {
        this.set(checkInterval, (BValue)v, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    public BStatusNumeric getRemaining() {
        return (BStatusNumeric)this.get(remaining);
    }

    public void setRemaining(BStatusNumeric v) {
        this.set(remaining, (BValue)v, null);
    }

    public void checkMaintenanceExpiration() {
        this.invoke(checkMaintenanceExpiration, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.setExempt(LicenseUtil.isSmaExempt());
        this.checkMaintenanceExpiration();
    }

    public void stopped() {
        this.cancelTicket();
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && (property.equals(mode) || property.equals(warnBelow))) {
            this.checkMaintenanceExpiration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckMaintenanceExpiration() {
        Object object = this.checkLock;
        synchronized (object) {
            this.logCurrentValues();
            if (this.getMode() == BSMAExpirationMonitorMode.disabled) {
                this.reportDisabled();
            } else {
                if (LicenseUtil.isSmaExempt()) {
                    this.reportOk();
                    return;
                }
                Optional<Long> expirationOp = this.getSmaExpiration();
                if (!expirationOp.isPresent()) {
                    this.reportNoSma();
                    log.info("SMA expiration date unavailable.");
                    return;
                }
                long expiration = expirationOp.get();
                long now = BAbsTime.now().getMillis();
                PrefixLogUtil.logWithPrefix(log, Level.FINEST, () -> "SMA Expiration: " + BAbsTime.make((long)expiration), (Object)this);
                if (now >= expiration) {
                    this.reportExpired();
                } else {
                    this.updateDaysRemaining(now, expiration);
                    long nowPlusWarning = now + (long)this.getWarnBelow() * 86400000L;
                    if (nowPlusWarning >= expiration) {
                        this.reportWarning();
                    } else {
                        this.reportOk();
                    }
                    this.scheduleNextCheck();
                }
            }
            this.logCurrentValues();
        }
    }

    private void reportDisabled() {
        this.cancelTicket();
        this.getRemaining().setStatusDisabled(true);
        this.getRemaining().setStatusInAlarm(false);
        this.getRemaining().setStatusFault(false);
        if (!this.getExempt()) {
            log.info("SMA Expiration Monitor Disabled");
        }
    }

    private void reportOk() {
        PrefixLogUtil.logWithPrefix(log, Level.FINE, "Expiration check passed ok", (Object)this);
        if (this.getRemaining().getStatus().isAlarm()) {
            try {
                this.alarmSupport.toNormal(Context.NULL);
                this.getRemaining().setStatusInAlarm(false);
                this.getRemaining().setStatusFault(false);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Generating toNormal Alarm", e);
            }
        }
    }

    private void reportWarning() {
        log.info(LOG_WARNING + this.getRemaining());
        if (this.getRemaining().getStatus().isFault()) {
            this.getRemaining().setStatusFault(false);
            this.service().initLicenseProperty();
        }
        if (!this.getRemaining().getStatus().isAlarm() && BSMAExpirationMonitorMode.warning == this.getMode()) {
            try {
                BAlarmRecord rec = this.alarmSupport.newOffnormalAlarm();
                PrefixLogUtil.logWithPrefix(log, Level.FINE, () -> "Raising offNormal SMA Warning:" + rec, (Object)this);
                this.getRemaining().setStatusInAlarm(true);
                this.getRemaining().setStatusUnackedAlarm(true);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "New OffNormal Alarm", e);
            }
        }
    }

    private void reportNoSma() {
        log.warning(LOG_NO_SMA);
        try {
            if (!this.service().isFatalFault()) {
                this.service().configFatal(HttpClientUtils.LEX.getText("noSma"));
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not update HttpClient Service fault cause", e);
        }
    }

    private void reportExpired() {
        log.warning("HttpClient requires active Software Maintenance. Remaining  days: 0");
        try {
            this.service().setStatus(BStatus.fault);
            this.service().setFaultCause(HttpClientUtils.LEX.getText("smaExpired"));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not update service fault cause", e);
        }
        if (!this.getRemaining().getStatus().isFault()) {
            try {
                BAlarmRecord fault = this.alarmSupport.newFaultAlarm();
                this.getRemaining().setStatusFault(true);
                this.getRemaining().setStatusInAlarm(true);
                this.getRemaining().setStatusUnackedAlarm(true);
                this.getRemaining().setValue(0.0);
                PrefixLogUtil.logWithPrefix(log, Level.FINE, () -> "Raising Fault for expired SMA: " + fault, (Object)this);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Raising fault alarm for expired SMA", e);
            }
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord alarmRecord) {
        PrefixLogUtil.logWithPrefix(log, Level.FINE, () -> "Entering AckAlarm " + alarmRecord, (Object)this);
        try {
            BBoolean result = BBoolean.make((boolean)this.alarmSupport.ackAlarm(alarmRecord));
            if (!alarmRecord.getAckRequired()) {
                PrefixLogUtil.logWithPrefix(log, Level.FINEST, "Removing unack status", (Object)this);
                this.getRemaining().setStatusUnackedAlarm(false);
            }
            return result;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error acking alarm " + alarmRecord.getUuid(), e);
            return BBoolean.FALSE;
        }
    }

    private Optional<Long> getSmaExpiration() {
        if (this.testExpiration != null) {
            log.fine(() -> "Found test expiration date: " + BAbsTime.make((long)this.testExpiration));
            return Optional.of(this.testExpiration);
        }
        Optional<Long> expirationOp = LicenseUtil.getSmaExpiration();
        if (!expirationOp.isPresent() && !this.getExempt()) {
            log.info("SMA expiration date unavailable.");
        }
        return expirationOp;
    }

    private void updateDaysRemaining(long now, long expiration) {
        int remain = BSMAExpirationMonitor.getDaysRemaining(now, expiration);
        this.getRemaining().setStatus(BStatus.make((BStatus)this.getRemaining().getStatus(), (int)16, (boolean)false));
        this.getRemaining().setValue((double)remain);
    }

    private void logCurrentValues() {
        PrefixLogUtil.logWithPrefix(log, Level.FINE, () -> "Current values: " + this.getRemaining() + " svc: " + this.service().getStatus(), (Object)this);
    }

    public static int getDaysRemaining(long now, long expiration) {
        long daysRemain = (expiration - now) / 86400000L;
        int days = Math.toIntExact(daysRemain);
        int positiveDays = -days;
        PrefixLogUtil.logWithPrefix(log, Level.FINE, () -> String.format("Calculating days remaining as (%s-%s) / %s = %sL [i:%s]", expiration, now, 86400000L, daysRemain, positiveDays), null);
        return positiveDays;
    }

    private void scheduleNextCheck() {
        this.cancelTicket();
        if (this.isRunning()) {
            BAbsTime nextTime = BAbsTime.now().add(this.getCheckInterval());
            log.fine(() -> "Scheduling next SMA Expiration check for " + nextTime);
            this.smaSchedule = Clock.schedule((BComponent)this, (BAbsTime)nextTime, (Action)checkMaintenanceExpiration, null);
        }
    }

    private void cancelTicket() {
        if (!this.smaSchedule.isExpired()) {
            this.smaSchedule.cancel();
            this.smaSchedule = Clock.expiredTicket;
        }
    }

    public BHttpClientService service() {
        return (BHttpClientService)this.getParent();
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        return ModuleThreadPool.getInstance().post(this, action, argument, cx);
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BHttpClientService.TYPE);
    }

    public boolean isChildLegal(BComponent child) {
        return false;
    }

    public boolean isNavChild() {
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }

    static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"%parent.parent.displayName%.%parent.displayName%"));
        asi.setToFaultText(BFormat.make((String)"%lexicon(httpClient:smaExpired)%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(httpClient:smaWarn)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(httpClient:smaOk)%"));
        asi.setAlarmIcon(BOrd.make((String)"module://icons/x16/braces.png"));
        return asi;
    }
}

