/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.servlet;

import com.tridium.session.NiagaraSuperSession;
import com.tridium.session.SessionManager;
import com.tridiumeurope.httpClient.datatypes.exception.HttpCommException;
import com.tridiumeurope.httpClient.servlet.BReceivedRequest;
import com.tridiumeurope.httpClient.servlet.response.BResponse;
import com.tridiumeurope.httpClient.servlet.response.BResponseFolder;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.IPrefixLoggable;
import com.tridiumeurope.httpClient.util.InputStreamUtil;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.report.BReport;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.session.CsrfException;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebServlet;
import javax.baja.web.CsrfUtil;
import javax.baja.web.WebOp;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.encoder.Encode;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="out", type="String", defaultValue="BString.DEFAULT", flags=73, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="lastReceived", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="servletName", type="String", defaultValue="stringServlet", override=true), @NiagaraProperty(name="requireSecure", type="boolean", defaultValue="true", flags=260), @NiagaraProperty(name="csrfProtection", type="boolean", defaultValue="false", flags=256, facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="clearBetweenDuplicateRequests", type="boolean", defaultValue="false"), @NiagaraProperty(name="maximumRequestBodySize", type="long", defaultValue="10", flags=4, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"megabyte\")"), @Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="10")}), @NiagaraProperty(name="responseBody", type="BResponseFolder", defaultValue="new BResponseFolder()"), @NiagaraProperty(name="reportName", type="String", defaultValue="postBodyContent"), @NiagaraProperty(name="reportFileExt", type="String", defaultValue="txt")})
@NiagaraAction(name="reset")
@NiagaraTopics(value={@NiagaraTopic(name="receivedRequest", eventType="BReceivedRequest", flags=8), @NiagaraTopic(name="report", eventType="BReport", flags=8)})
public class BStringServlet
extends BWebServlet
implements IPrefixLoggable {
    public static final Property out = BStringServlet.newProperty((int)73, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property lastReceived = BStringServlet.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property servletName = BStringServlet.newProperty((int)0, (String)"stringServlet", null);
    public static final Property requireSecure = BStringServlet.newProperty((int)260, (boolean)true, null);
    public static final Property csrfProtection = BStringServlet.newProperty((int)256, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property clearBetweenDuplicateRequests = BStringServlet.newProperty((int)0, (boolean)false, null);
    public static final Property maximumRequestBodySize = BStringServlet.newProperty((int)4, (int)10, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"megabyte")), (BFacets)BFacets.make((String)"min", (int)1)), (BFacets)BFacets.make((String)"max", (int)10)));
    public static final Property responseBody = BStringServlet.newProperty((int)0, (BValue)new BResponseFolder(), null);
    public static final Property reportName = BStringServlet.newProperty((int)0, (String)"postBodyContent", null);
    public static final Property reportFileExt = BStringServlet.newProperty((int)0, (String)"txt", null);
    public static final Action reset = BStringServlet.newAction((int)0, null);
    public static final Topic receivedRequest = BStringServlet.newTopic((int)8, null);
    public static final Topic report = BStringServlet.newTopic((int)8, null);
    public static final Type TYPE = Sys.loadType(BStringServlet.class);
    static final Logger log = HttpClientUtils.child("servlet");
    private static final String SECURE_CONN_REQUIRED = HttpClientUtils.LEX.getText("servlet.secure");
    private static final long MB_BYTES = 0x100000L;

    public String getOut() {
        return this.getString(out);
    }

    public void setOut(String v) {
        this.setString(out, v, null);
    }

    public BAbsTime getLastReceived() {
        return (BAbsTime)this.get(lastReceived);
    }

    public void setLastReceived(BAbsTime v) {
        this.set(lastReceived, (BValue)v, null);
    }

    public boolean getRequireSecure() {
        return this.getBoolean(requireSecure);
    }

    public void setRequireSecure(boolean v) {
        this.setBoolean(requireSecure, v, null);
    }

    public boolean getCsrfProtection() {
        return this.getBoolean(csrfProtection);
    }

    public void setCsrfProtection(boolean v) {
        this.setBoolean(csrfProtection, v, null);
    }

    public boolean getClearBetweenDuplicateRequests() {
        return this.getBoolean(clearBetweenDuplicateRequests);
    }

    public void setClearBetweenDuplicateRequests(boolean v) {
        this.setBoolean(clearBetweenDuplicateRequests, v, null);
    }

    public long getMaximumRequestBodySize() {
        return this.getLong(maximumRequestBodySize);
    }

    public void setMaximumRequestBodySize(long v) {
        this.setLong(maximumRequestBodySize, v, null);
    }

    public BResponseFolder getResponseBody() {
        return (BResponseFolder)this.get(responseBody);
    }

    public void setResponseBody(BResponseFolder v) {
        this.set(responseBody, (BValue)v, null);
    }

    public String getReportName() {
        return this.getString(reportName);
    }

    public void setReportName(String v) {
        this.setString(reportName, v, null);
    }

    public String getReportFileExt() {
        return this.getString(reportFileExt);
    }

    public void setReportFileExt(String v) {
        this.setString(reportFileExt, v, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void fireReceivedRequest(BReceivedRequest event) {
        this.fire(receivedRequest, (BValue)event, null);
    }

    public void fireReport(BReport event) {
        this.fire(report, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doPost(WebOp op) throws IOException {
        this.handleRequest(op, true);
    }

    public void doGet(WebOp op) throws IOException {
        this.handleRequest(op, false);
    }

    public void doReset() {
        this.setOut("");
        this.setLastReceived(BAbsTime.DEFAULT);
        this.clearFault();
    }

    private void sanityCheck(WebOp op) throws HttpCommException {
        if (this.isDisabled()) {
            throw new HttpCommException("Received request for disabled StringServlet", 503);
        }
        if (this.getRequireSecure() && !op.getRequest().isSecure()) {
            throw new HttpCommException(SECURE_CONN_REQUIRED, 400);
        }
    }

    private void handleRequest(WebOp op, boolean post) throws IOException {
        try {
            this.sanityCheck(op);
            HttpServletRequest req = op.getRequest();
            HttpServletResponse resp = op.getResponse();
            if (this.getCsrfProtection() && !BStringServlet.csrfCheck(req, resp, post)) {
                return;
            }
            BUser user = op.getUser();
            BPermissions permissions = user.getPermissionsFor((BIProtected)this);
            if (!permissions.has(2)) {
                resp.sendError(401);
                this.setFaultCause(HttpClientUtils.LEX.getText("postForbidden") + ' ' + op.getUser());
                throw new LocalizableException(Lexicon.make((String)TYPE.getModule().getModuleName(), (Context)op), "postForbidden");
            }
            String body = "";
            if (post && !(body = InputStreamUtil.streamToBoundedString((InputStream)req.getInputStream(), this.getMaximumRequestBodySize() * 0x100000L)).isEmpty()) {
                String safeBody = Encode.forJava((String)body);
                PrefixLogUtil.logWithPrefix(log, Level.FINE, () -> String.format("%1.20s", safeBody), (Object)this);
            }
            this.update(body);
            BReceivedRequest receivedRequest = new BReceivedRequest(req, body);
            this.fireTopics(receivedRequest, this.determineMime(body.getBytes(StandardCharsets.UTF_8)));
            BResponse responseBody = this.getResponseBody().matchResponse(receivedRequest);
            BStringServlet.writeResponse(resp, responseBody);
            this.clearFault();
        }
        catch (HttpCommException e) {
            if (e.getCause() != null) {
                PrefixLogUtil.logWithPrefix(log, Level.SEVERE, "Failed to handle servlet request", (Throwable)((Object)e), (Object)this);
            }
            this.fault(e.getMessage());
            int responseCode = e.getResponseCode() > 0 ? e.getResponseCode() : 500;
            op.getResponse().sendError(responseCode);
        }
        catch (Throwable t) {
            PrefixLogUtil.logWithPrefix(log, Level.SEVERE, "Failed to handle incoming request", t, (Object)this);
            this.fault(t.getMessage());
            op.getResponse().sendError(500);
        }
    }

    private static boolean csrfCheck(HttpServletRequest req, HttpServletResponse resp, boolean post) throws IOException {
        boolean proceed = true;
        try {
            if (!post && Boolean.parseBoolean(req.getHeader("x-niagara-csrfToken"))) {
                proceed = false;
                NiagaraSuperSession session = SessionManager.getCurrentNiagaraSuperSession();
                if (session != null) {
                    resp.setHeader("x-niagara-csrfToken", session.getCsrfToken());
                    resp.setStatus(200);
                } else {
                    resp.sendError(403, "No valid session");
                }
            } else {
                CsrfUtil.verifyCsrfToken((HttpServletRequest)req);
            }
        }
        catch (CsrfException e) {
            resp.sendError(403, "Invalid CSRF token");
            proceed = false;
        }
        return proceed;
    }

    private void update(String body) {
        if (this.getOut().equals(body) && this.getClearBetweenDuplicateRequests()) {
            this.setOut("");
            HttpClientUtils.waitForEngineCycles(2, BRelTime.makeSeconds((int)5));
        }
        this.setOut(body);
        this.setLastReceived(BAbsTime.now());
    }

    private void fireTopics(BReceivedRequest receivedRequest, String mime) {
        this.fireReceivedRequest(receivedRequest);
        this.fireReportTopic(receivedRequest.getBody(), mime);
    }

    private static void writeResponse(HttpServletResponse servletResponse, BResponse response) throws IOException {
        servletResponse.setStatus(response.getResponseCode());
        PrintWriter out = servletResponse.getWriter();
        String responseBody = response.getData();
        if (!responseBody.isEmpty()) {
            servletResponse.setContentType(HttpClientUtils.deriveTextContentType(new ByteArrayInputStream(responseBody.getBytes(StandardCharsets.UTF_8))));
        }
        servletResponse.setContentLength(responseBody.getBytes(StandardCharsets.UTF_8).length);
        out.print(responseBody);
        out.flush();
    }

    protected void fireReportTopic(String body, String mime) {
        String reportName = String.format("%s-%s.%s", this.getReportName(), System.currentTimeMillis(), this.getReportFileExt());
        this.fireReport(new BReport(reportName, reportName, mime, body.getBytes(StandardCharsets.UTF_8)));
    }

    private String determineMime(byte[] bytes) {
        String mime = "text/plain";
        try {
            mime = HttpClientUtils.deriveTextContentType(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            PrefixLogUtil.logWithPrefix(log, Level.FINE, () -> "Failed to determine mime type: " + e.getMessage(), (Object)this);
        }
        return mime;
    }

    private void fault(String faultCause) {
        this.setStatus(BStatus.fault);
        this.setFaultCause(faultCause);
    }

    private void clearFault() {
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
    }

    @Override
    public String identifierForLogs() {
        return "StringServlet-" + this.getName();
    }

    public BIcon getIcon() {
        return HttpClientUtils.HTTP_IMPORT_ICON;
    }
}

