/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.datatypes.payload;

import com.tridiumeurope.httpClient.comm.client.BIHttpCommClient;
import com.tridiumeurope.httpClient.datatypes.payload.BAbstractPayloadSource;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.ModuleThreadPool;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.report.BReport;
import javax.baja.report.BReportSource;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.CannotValidateException;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperty(name="reportSourceOrd", type="BOrd", defaultValue="BOrd.DEFAULT")
@NiagaraAction(name="routeReport", parameterType="BReport", defaultValue="new BReport()", flags=20)
public class BReportPayloadSource
extends BAbstractPayloadSource {
    public static final Property reportSourceOrd = BReportPayloadSource.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Action routeReport = BReportPayloadSource.newAction((int)20, (BValue)new BReport(), null);
    public static final Type TYPE = Sys.loadType(BReportPayloadSource.class);
    private ReportSourceSubscriber subscriber;
    private BReport currentReport;
    private final Object sendMutex = new Object();
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public BOrd getReportSourceOrd() {
        return (BOrd)this.get(reportSourceOrd);
    }

    public void setReportSourceOrd(BOrd v) {
        this.set(reportSourceOrd, (BValue)v, null);
    }

    public void routeReport(BReport parameter) {
        this.invoke(routeReport, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BReportPayloadSource make(BOrd reportSourceOrd) {
        BReportPayloadSource source2 = new BReportPayloadSource();
        source2.setReportSourceOrd(reportSourceOrd);
        return source2;
    }

    public void started() {
        if (this.isRunning()) {
            this.subscribe();
        }
    }

    public void stopped() {
        this.unsubscribe();
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property.equals(reportSourceOrd)) {
            this.unsubscribe();
            this.subscribe();
        }
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (property.equals(reportSourceOrd)) {
            return (validatable, ctx) -> {
                BOrd proposedOrd = (BOrd)validatable.getProposedValue(reportSourceOrd).as(BOrd.class);
                BReportPayloadSource.checkOrdIsExportSource(proposedOrd);
            };
        }
        return null;
    }

    private static void checkOrdIsExportSource(BOrd ord) {
        if (BReportPayloadSource.getReportSource(ord) == null) {
            throw new CannotValidateException("Source ord must be a Report Source component");
        }
    }

    private static BReportSource getReportSource(BOrd ord) {
        BObject object = ord.get((BObject)Sys.getStation());
        if (object instanceof BReportSource) {
            return (BReportSource)object.as(BReportSource.class);
        }
        return null;
    }

    private void subscribe() {
        if (!this.getReportSourceOrd().equals((Object)BOrd.DEFAULT)) {
            BReportSource reportSource;
            if (this.subscriber == null) {
                this.subscriber = new ReportSourceSubscriber();
            }
            if ((reportSource = BReportPayloadSource.getReportSource(this.getReportSourceOrd())) != null) {
                this.subscriber.subscribe((BComponent)reportSource);
            } else {
                String warning = String.format("Report Payload ord [%s] is not a report source in [%s]", this.getReportSourceOrd(), this.getSlotPath());
                PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.WARNING, warning, (Object)this);
                throw new CannotValidateException(warning);
            }
        }
    }

    private void unsubscribe() {
        if (this.subscriber != null) {
            this.subscriber.unsubscribeAll();
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        return ModuleThreadPool.getInstance().post(this, action, argument, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRouteReport(BReport report) {
        if (this.isRunning()) {
            Object object = this.sendMutex;
            synchronized (object) {
                this.currentReport = report;
                BIHttpCommClient client = HttpClientUtils.getParent((BComplex)this, BIHttpCommClient.class);
                if (client != null) {
                    PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINE, String.format("Report Payload Source [%s] triggering http send in [%s]", this.getReportSourceOrd(), this.getSlotPath()), (Object)this);
                    try {
                        client.sendSync();
                    }
                    catch (Exception e) {
                        PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.SEVERE, String.format("Report Payload Source [%s] send failed in [%s]", this.getReportSourceOrd(), this.getSlotPath()), (Throwable)e, (Object)this);
                    }
                    this.currentReport = null;
                }
            }
        }
    }

    @Override
    public void prepareToSend() {
        if (this.currentReport == null) {
            throw new BajaRuntimeException("No report exists to send");
        }
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.hasReportToPublish() ? this.currentReport.getContent() : EMPTY_BYTE_ARRAY);
    }

    @Override
    public long length() {
        return this.hasReportToPublish() ? (long)this.currentReport.getContent().length : 0L;
    }

    public boolean hasReportToPublish() {
        return this.currentReport != null && this.currentReport.getContent() != null;
    }

    @Override
    public String identifierForLogs() {
        return this.getReportSourceOrd().encodeToString();
    }

    public BIcon getIcon() {
        return BIcon.std((String)"export.png");
    }

    class ReportSourceSubscriber
    extends Subscriber {
        ReportSourceSubscriber() {
        }

        public void event(BComponentEvent event) {
            if (event.getId() == 5 && event.getSlotName().equals(BReportSource.out.getName())) {
                BReport report = (BReport)event.getValue().as(BReport.class);
                BReportPayloadSource.this.routeReport(report);
            }
        }
    }
}

