/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.datatypes.options.autoheaders;

import com.tridiumeurope.httpClient.comm.client.BIHttpCommClient;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClientWrite;
import com.tridiumeurope.httpClient.datatypes.enums.BHttpRequestMethod;
import com.tridiumeurope.httpClient.datatypes.options.autoheaders.BAutoHeader;
import com.tridiumeurope.httpClient.datatypes.payload.BAbstractPayloadSource;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="userContentType", type="String", defaultValue="BString.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"httpClient:MediaTypeFieldEditor\"))")})
public class BContentTypeHeader
extends BAutoHeader {
    public static final Property userContentType = BContentTypeHeader.newProperty((int)0, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"httpClient:MediaTypeFieldEditor")));
    public static final Type TYPE = Sys.loadType(BContentTypeHeader.class);

    public String getUserContentType() {
        return this.getString(userContentType);
    }

    public void setUserContentType(String v) {
        this.setString(userContentType, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected String calculateNewValue() {
        String contentType = "";
        String usersContentType = this.getUserContentType();
        if (usersContentType != null && !usersContentType.isEmpty()) {
            return usersContentType;
        }
        BIHttpCommClientWrite write = HttpClientUtils.getParent((BComplex)this, BIHttpCommClientWrite.class);
        BIHttpCommClient client = HttpClientUtils.getParent((BComplex)this, BIHttpCommClient.class);
        if (write != null && client != null && client.getMethod() != BHttpRequestMethod.get) {
            contentType = this.deriveContentType(write.getPayloadSource());
        }
        return contentType;
    }

    private String deriveContentType(BAbstractPayloadSource payloadSource) {
        String contentType = "";
        try (InputStream is = payloadSource.getStream();){
            contentType = URLConnection.guessContentTypeFromStream(is);
            if (contentType == null) {
                contentType = HttpClientUtils.deriveTextContentType(is);
            }
        }
        catch (IOException e) {
            PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.WARNING, "Error guessing content type", (Throwable)e, (Object)this);
        }
        return contentType;
    }
}

