/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.datatypes.enums;

import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="insecure"), @Range(value="secure")}, defaultValue="secure")
public final class BHttpMode
extends BFrozenEnum {
    public static final int INSECURE = 0;
    public static final int SECURE = 1;
    public static final BHttpMode insecure = new BHttpMode(0);
    public static final BHttpMode secure;
    public static final BHttpMode DEFAULT;
    public static final Type TYPE;

    public static BHttpMode make(int ordinal) {
        return (BHttpMode)insecure.getRange().get(ordinal, false);
    }

    public static BHttpMode make(String tag) {
        return (BHttpMode)insecure.getRange().get(tag);
    }

    private BHttpMode(int ordinal) {
        super(ordinal);
    }

    public Type getType() {
        return TYPE;
    }

    public int getDefaultServicePort() {
        return this.equals((Object)insecure) ? 80 : 443;
    }

    public String getModeString(boolean websocket) {
        return websocket ? (this == insecure ? "ws" : "wss") : (this == insecure ? "http" : "https");
    }

    public static BHttpMode makeForScheme(String scheme) {
        String lowerScheme = scheme.toLowerCase();
        if (lowerScheme.equals("http") || lowerScheme.equals("ws")) {
            return insecure;
        }
        if (lowerScheme.equals("https") || lowerScheme.equals("wss")) {
            return secure;
        }
        throw new BajaRuntimeException("Unsupported url protocol: " + scheme);
    }

    static {
        DEFAULT = secure = new BHttpMode(1);
        TYPE = Sys.loadType(BHttpMode.class);
    }
}

