/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.datatypes.auth;

import com.tridiumeurope.httpClient.datatypes.auth.BHttpAuthenticator;
import com.tridiumeurope.httpClient.datatypes.auth.BTokenAuthScheme;
import com.tridiumeurope.httpClient.datatypes.exception.HttpCommException;
import com.tridiumeurope.httpClient.datatypes.options.BHttpHeaders;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="headerName", type="String", defaultValue="BString.DEFAULT")
public class BHeaderTokenAuth
extends BTokenAuthScheme {
    public static final Property headerName = BHeaderTokenAuth.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BHeaderTokenAuth.class);

    public String getHeaderName() {
        return this.getString(headerName);
    }

    public void setHeaderName(String v) {
        this.setString(headerName, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BHttpAuthenticator createHeaderTokenAuthenticator(String headerName, String headerValue) {
        BHttpAuthenticator authenticator = new BHttpAuthenticator();
        authenticator.setAuthType(TYPE.getTypeSpec());
        authenticator.checkAuthenticator();
        BHeaderTokenAuth headerTokenAuth = (BHeaderTokenAuth)authenticator.getConfig().as(BHeaderTokenAuth.class);
        headerTokenAuth.setHeaderName(headerName);
        headerTokenAuth.setToken(BPassword.make((String)headerValue));
        return authenticator;
    }

    @Override
    public void appendHeaders(BHttpHeaders headers) throws HttpCommException {
        headers.addToRequest(this.getHeaderName(), this.getToken().getValue());
    }
}

