/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.comm.transport.httpUrlConnection;

import com.tridiumeurope.httpClient.comm.client.BIHttpCommClient;
import com.tridiumeurope.httpClient.comm.transport.BAbstractHttpTransport;
import com.tridiumeurope.httpClient.comm.transport.HttpRequestInstance;
import com.tridiumeurope.httpClient.comm.transport.httpUrlConnection.HttpUrlConnectionUtil;
import com.tridiumeurope.httpClient.datatypes.BHttpAddress;
import com.tridiumeurope.httpClient.datatypes.BHttpTuningPolicy;
import com.tridiumeurope.httpClient.datatypes.auth.BAbstractHttpAuth;
import com.tridiumeurope.httpClient.datatypes.auth.BAuthorizationHeaderScheme;
import com.tridiumeurope.httpClient.datatypes.auth.BNoHttpAuth;
import com.tridiumeurope.httpClient.datatypes.enums.BHttpRequestMethod;
import com.tridiumeurope.httpClient.datatypes.exception.HttpCommException;
import com.tridiumeurope.httpClient.datatypes.options.BHttpHeaders;
import com.tridiumeurope.httpClient.datatypes.options.BHttpParameters;
import com.tridiumeurope.httpClient.datatypes.payload.BRequestBody;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpUrlConnectionRequest
extends HttpRequestInstance {
    private BRequestBody requestBody;
    private BAbstractHttpAuth authenticator;
    private BHttpTuningPolicy policy;
    private BHttpHeaders headers;
    private BHttpAddress address;
    private HttpURLConnection connection;
    protected static final Logger log = BAbstractHttpTransport.TRANSPORT_LOG;

    HttpUrlConnectionRequest(BIHttpCommClient client) {
        super(client);
    }

    @Override
    public HttpRequestInstance applyAddress(BHttpAddress address) {
        this.address = address;
        return this;
    }

    @Override
    public HttpRequestInstance applyData(BHttpRequestMethod method, BHttpParameters parameters, BRequestBody requestBody) throws HttpCommException {
        this.requestBody = requestBody;
        try {
            URL url = this.address.getUrl(method, parameters);
            this.connection = (HttpURLConnection)url.openConnection();
            this.connection.setRequestMethod(method.getTag().toUpperCase());
            this.headers.asMap().forEach((k, v) -> this.connection.setRequestProperty((String)k, (String)v));
            if (this.authenticator.getType().is(BAuthorizationHeaderScheme.TYPE)) {
                HttpUrlConnectionUtil.applyAuthHeader(this.connection, (BAuthorizationHeaderScheme)this.authenticator.as(BAuthorizationHeaderScheme.class), this.getClient());
            } else if (!this.authenticator.getType().is(BNoHttpAuth.TYPE)) {
                this.authenticator.apply(this);
            }
            HttpUrlConnectionUtil.applyTuningPolicy(this.policy, this.connection);
            if (HttpUrlConnectionUtil.requiresRequestBody(this.connection)) {
                if (requestBody != null) {
                    String contentType = requestBody.getLatestContentType();
                    if (contentType != null && !contentType.isEmpty()) {
                        this.connection.setRequestProperty("Content-Type", contentType);
                    }
                } else {
                    PrefixLogUtil.logWithPrefix(log, Level.FINE, "Content Type Header skipped - No request body supplied", (Object)parameters);
                }
            }
        }
        catch (IOException e) {
            throw new HttpCommException("Error configuring HttpUrlConnection: " + e.getMessage(), e);
        }
        return this;
    }

    @Override
    public HttpRequestInstance applyHeaders(BHttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    @Override
    public HttpRequestInstance applyAuthenticator(BAbstractHttpAuth authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    @Override
    public HttpRequestInstance applyTuningPolicy(BHttpTuningPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Override
    public String identifierForLogs() {
        return this.address.identifierForLogs();
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public BRequestBody getRequestBody() {
        return this.requestBody;
    }
}

