/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.schedule;

import com.tridium.util.ComponentTreeCursor;
import javax.baja.collection.BITable;
import javax.baja.driver.schedule.BScheduleExport;
import javax.baja.driver.schedule.BScheduleImportExt;
import javax.baja.driver.util.BDescriptorDeviceExt;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="subscribeWindow", type="BRelTime", defaultValue="BRelTime.DAY")
@NiagaraAction(name="subscribe", flags=20)
public abstract class BScheduleDeviceExt
extends BDescriptorDeviceExt {
    public static final Property subscribeWindow = BScheduleDeviceExt.newProperty((int)0, (BValue)BRelTime.DAY, null);
    public static final Action subscribe = BScheduleDeviceExt.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BScheduleDeviceExt.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/schedules.png");
    private BAbsTime started = BAbsTime.NULL;

    public BRelTime getSubscribeWindow() {
        return (BRelTime)this.get(subscribeWindow);
    }

    public void setSubscribeWindow(BRelTime v) {
        this.set(subscribeWindow, (BValue)v, null);
    }

    public void subscribe() {
        this.invoke(subscribe, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void added(Property p, Context c) {
        super.added(p, c);
        if (c == Context.decoding || !this.isRunning()) {
            return;
        }
        BValue o = this.get(p);
        if (o instanceof BAbstractSchedule) {
            BAbstractSchedule s = (BAbstractSchedule)o;
            if (BScheduleDeviceExt.getExt(s) != null && !Flags.isReadonly((BComplex)this, (Slot)p)) {
                final Property t = p;
                new Thread(){

                    @Override
                    public void run() {
                        int flags = BScheduleDeviceExt.this.getFlags((Slot)t) | 1;
                        BScheduleDeviceExt.this.setFlags((Slot)t, flags);
                    }
                }.start();
            }
            this.subscribe();
        }
    }

    public final void doSubscribe() {
        ComponentTreeCursor cur = new ComponentTreeCursor((BComponent)this, null);
        while (cur.next(BScheduleImportExt.class)) {
            BScheduleImportExt ext = (BScheduleImportExt)cur.get();
            BAbsTime t = ext.getExecutionTime().getLastTrigger();
            if (!ext.isRunning() || !this.started.isAfter(t)) continue;
            ext.execute();
        }
    }

    public static BScheduleImportExt getExt(BAbstractSchedule sch) {
        BValue o = sch.get("ext");
        if (o != null) {
            return (BScheduleImportExt)o;
        }
        SlotCursor c = sch.getProperties();
        if (c.next(BScheduleImportExt.class)) {
            return (BScheduleImportExt)c.get();
        }
        return null;
    }

    public final BIcon getIcon() {
        return icon;
    }

    public static BAbsTime getVersionOf(BAbstractSchedule sch) {
        return (BAbsTime)sch.get("lastModified");
    }

    public abstract BScheduleExport makeExport(String var1);

    public abstract BScheduleImportExt makeImportExt();

    public BAbsTime processExport(String supervisorId, BAbstractSchedule supervisor) throws Exception {
        BScheduleImportExt ext = this.getExt(supervisorId);
        if (ext == null) {
            throw new IllegalArgumentException("Subordinate schedule not found for supervisor id: " + supervisorId);
        }
        ext.importSupervisor(supervisor);
        ext.setLastSuccess(Clock.time());
        return BScheduleDeviceExt.getVersionOf(ext.getSubordinate());
    }

    public BAbstractSchedule processImport(String supervisorId, BAbsTime subordinateVersion) throws Exception {
        BScheduleExport desc = this.getDescriptor(supervisorId);
        try {
            BAbstractSchedule sup = desc.getSupervisor();
            desc.setLastSuccess(Clock.time());
            desc.updateStatus();
            BAbsTime supVer = BScheduleDeviceExt.getVersionOf(sup);
            if (!supVer.equals((Object)subordinateVersion)) {
                desc.setSubordinateVersion(supVer);
                return desc.getExportableSchedule();
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Could not determine fault cause";
            }
            desc.setLastFailure(Clock.time());
            desc.setFaultCause(message);
            desc.updateStatus();
            throw e;
        }
        return null;
    }

    public final BITable<?> processLearn() {
        String query = "station:|slot:/|bql: select name,slotPathOrd,type from schedule:AbstractSchedule where (parent.type != schedule:AbstractSchedule)";
        BOrd queryOrd = BOrd.make((BOrd)this.getComponentSpace().getAbsoluteOrd(), (String)query);
        return (BITable)queryOrd.resolve().get();
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.started = Clock.time();
        SlotCursor c = this.getProperties();
        while (c.next(BAbstractSchedule.class)) {
            Property p;
            BAbstractSchedule sch = (BAbstractSchedule)c.get();
            if (BScheduleDeviceExt.getExt(sch) == null || Flags.isReadonly((BComplex)this, (Slot)(p = c.property()))) continue;
            int flags = this.getFlags((Slot)p) | 1;
            this.setFlags((Slot)p, flags);
        }
        this.scheduleSubscribe();
    }

    protected BScheduleExport getDescriptor(String supervisorId) throws Exception {
        String orig;
        ComponentTreeCursor cur = new ComponentTreeCursor((BComponent)this, null);
        while (cur.next(BScheduleExport.class)) {
            BScheduleExport tmp = (BScheduleExport)cur.get();
            if (!supervisorId.equals(tmp.getSupervisorId())) continue;
            return tmp;
        }
        BOrd ord = BOrd.make((String)supervisorId);
        BAbstractSchedule sch = (BAbstractSchedule)ord.resolve((BObject)this).get();
        String name = orig = sch.getName() + "Export";
        int i = 0;
        while (this.get(name) != null) {
            name = orig + ++i;
        }
        BScheduleExport ret = this.makeExport(supervisorId);
        this.add(name, (BValue)ret);
        return ret;
    }

    protected BScheduleImportExt getExt(String supervisorId) {
        ComponentTreeCursor cur = new ComponentTreeCursor((BComponent)this, null);
        while (cur.next(BScheduleImportExt.class)) {
            BScheduleImportExt tmp = (BScheduleImportExt)cur.get();
            if (!supervisorId.equals(tmp.getSupervisorId())) continue;
            return tmp;
        }
        return null;
    }

    private void scheduleSubscribe() {
        long millis = this.getSubscribeWindow().getMillis();
        if (millis == 0L) {
            return;
        }
        millis = (long)((double)millis * Math.random());
        Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)millis), (Action)subscribe, null);
    }
}

