/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.point;

import java.util.ArrayList;
import javax.baja.agent.AgentList;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BPointDeviceExt
extends BDeviceExt
implements BIPointFolder {
    public static final Type TYPE = Sys.loadType(BPointDeviceExt.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/points.png");

    @Override
    public Type getType() {
        return TYPE;
    }

    public abstract Type getDeviceType();

    @Override
    public abstract Type getProxyExtType();

    @Override
    public abstract Type getPointFolderType();

    @Override
    public final BPointDeviceExt getDeviceExt() {
        return this;
    }

    public BControlPoint[] getPoints() {
        ArrayList<BControlPoint> list = new ArrayList<BControlPoint>();
        this.getPoints(this, this.getProxyExtType(), list);
        return list.toArray(new BControlPoint[list.size()]);
    }

    private void getPoints(BComponent comp, Type proxyExtType, ArrayList<BControlPoint> list) {
        SlotCursor cursor = comp.loadSlots().getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = cursor.get().asComponent();
            if (kid instanceof BControlPoint) {
                if (!((BControlPoint)kid).getProxyExt().getType().is(proxyExtType)) continue;
                list.add((BControlPoint)kid);
                continue;
            }
            this.getPoints(kid, proxyExtType, list);
        }
    }

    @Override
    public void updateStatus() {
        BControlPoint[] points = this.getPoints();
        for (int i = 0; i < points.length; ++i) {
            BAbstractProxyExt ext = points[i].getProxyExt();
            if (!(ext instanceof BProxyExt)) continue;
            ((BProxyExt)ext).updateStatus();
        }
    }

    public AgentList getAgents(Context cx) {
        TypeInfo pointManager = Sys.getRegistry().getType("driver:PointManager");
        AgentList agents = super.getAgents(cx);
        for (int i = 0; i < agents.size(); ++i) {
            if (!agents.get(i).getAgentType().is(pointManager)) continue;
            return agents;
        }
        agents.add(pointManager.getAgentInfo());
        return agents;
    }

    public BIcon getIcon() {
        return icon;
    }
}

