/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.loadable;

import javax.baja.driver.BDevice;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BILoadable;
import javax.baja.driver.loadable.BLoadableNetwork;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.driver.loadable.LoadUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public abstract class BLoadableDevice
extends BDevice
implements BILoadable {
    public static final Action upload = BLoadableDevice.newAction((int)16, (BValue)new BUploadParameters(), null);
    public static final Action download = BLoadableDevice.newAction((int)16, (BValue)new BDownloadParameters(), null);
    public static final Type TYPE = Sys.loadType(BLoadableDevice.class);

    @Override
    public void upload(BUploadParameters parameters) {
        this.invoke(upload, (BValue)parameters, null);
    }

    @Override
    public void download(BDownloadParameters parameters) {
        this.invoke(download, (BValue)parameters, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public IFuture postAsync(Runnable r) {
        return ((BLoadableNetwork)this.getNetwork()).postAsync(r);
    }

    @Override
    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(upload)) {
            return this.postUpload((BUploadParameters)arg, cx);
        }
        if (action.equals(download)) {
            return this.postDownload((BDownloadParameters)arg, cx);
        }
        return super.post(action, arg, cx);
    }

    @Override
    protected IFuture postPing() {
        return this.postAsync((Runnable)new Invocation((BComponent)this, ping, null, null));
    }

    protected IFuture postUpload(BUploadParameters params, Context cx) {
        return this.postAsync((Runnable)new Invocation((BComponent)this, upload, (BValue)params, cx));
    }

    protected IFuture postDownload(BDownloadParameters params, Context cx) {
        return this.postAsync((Runnable)new Invocation((BComponent)this, download, (BValue)params, cx));
    }

    @Override
    public void doUpload(BUploadParameters params, Context cx) throws Exception {
        if (params.getRecursive()) {
            LoadUtil.uploadChildren(this, params, cx);
        }
    }

    @Override
    public void doDownload(BDownloadParameters params, Context cx) throws Exception {
        if (params.getRecursive()) {
            LoadUtil.downloadChildren(this, params, cx);
        }
    }
}

