/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.loadable;

import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BILoadable;
import javax.baja.driver.loadable.BLoadableDevice;
import javax.baja.driver.loadable.BLoadableNetwork;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.driver.loadable.LoadUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public abstract class BLoadable
extends BComponent
implements BILoadable {
    public static final Action upload = BLoadable.newAction((int)16, (BValue)new BUploadParameters(), null);
    public static final Action download = BLoadable.newAction((int)16, (BValue)new BDownloadParameters(), null);
    public static final Type TYPE = Sys.loadType(BLoadable.class);

    @Override
    public void upload(BUploadParameters parameters) {
        this.invoke(upload, (BValue)parameters, null);
    }

    @Override
    public void download(BDownloadParameters parameters) {
        this.invoke(download, (BValue)parameters, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BLoadableNetwork getNetwork() {
        try {
            return (BLoadableNetwork)this.getDevice().getNetwork();
        }
        catch (Exception e) {
            return null;
        }
    }

    public BLoadableDevice getDevice() {
        try {
            BComplex p = this.getParent();
            while (!(p instanceof BLoadableDevice)) {
                p = p.getParent();
            }
            return (BLoadableDevice)p;
        }
        catch (Exception e) {
            return null;
        }
    }

    public IFuture postAsync(Runnable r) {
        return this.getNetwork().postAsync(r);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BILoadable;
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(upload)) {
            return this.postUpload((BUploadParameters)arg, cx);
        }
        if (action.equals(download)) {
            return this.postDownload((BDownloadParameters)arg, cx);
        }
        return super.post(action, arg, cx);
    }

    protected IFuture postUpload(BUploadParameters params, Context cx) {
        return this.postAsync((Runnable)new Invocation((BComponent)this, upload, (BValue)params, cx));
    }

    protected IFuture postDownload(BDownloadParameters params, Context cx) {
        return this.postAsync((Runnable)new Invocation((BComponent)this, download, (BValue)params, cx));
    }

    @Override
    public void doUpload(BUploadParameters params, Context cx) throws Exception {
        if (params.getRecursive()) {
            LoadUtil.uploadChildren(this, params, cx);
        }
    }

    @Override
    public void doDownload(BDownloadParameters params, Context cx) throws Exception {
        if (params.getRecursive()) {
            LoadUtil.downloadChildren(this, params, cx);
        }
    }
}

